/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.PreferredCredential;
import com.oracle.bmc.databasemanagement.model.PreferredCredentialStatus;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class NamedPreferredCredential
extends PreferredCredential {
    @JsonProperty(value="namedCredentialId")
    private final String namedCredentialId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NamedPreferredCredential(String credentialName, PreferredCredentialStatus status, Boolean isAccessible, String namedCredentialId) {
        super(credentialName, status, isAccessible);
        this.namedCredentialId = namedCredentialId;
    }

    public String getNamedCredentialId() {
        return this.namedCredentialId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NamedPreferredCredential(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namedCredentialId=").append(String.valueOf(this.namedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedPreferredCredential)) {
            return false;
        }
        NamedPreferredCredential other = (NamedPreferredCredential)((Object)o);
        return Objects.equals(this.namedCredentialId, other.namedCredentialId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namedCredentialId == null ? 43 : this.namedCredentialId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialName")
        private String credentialName;
        @JsonProperty(value="status")
        private PreferredCredentialStatus status;
        @JsonProperty(value="isAccessible")
        private Boolean isAccessible;
        @JsonProperty(value="namedCredentialId")
        private String namedCredentialId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialName(String credentialName) {
            this.credentialName = credentialName;
            this.__explicitlySet__.add("credentialName");
            return this;
        }

        public Builder status(PreferredCredentialStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder isAccessible(Boolean isAccessible) {
            this.isAccessible = isAccessible;
            this.__explicitlySet__.add("isAccessible");
            return this;
        }

        public Builder namedCredentialId(String namedCredentialId) {
            this.namedCredentialId = namedCredentialId;
            this.__explicitlySet__.add("namedCredentialId");
            return this;
        }

        public NamedPreferredCredential build() {
            NamedPreferredCredential model = new NamedPreferredCredential(this.credentialName, this.status, this.isAccessible, this.namedCredentialId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NamedPreferredCredential model) {
            if (model.wasPropertyExplicitlySet("credentialName")) {
                this.credentialName(model.getCredentialName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("isAccessible")) {
                this.isAccessible(model.getIsAccessible());
            }
            if (model.wasPropertyExplicitlySet("namedCredentialId")) {
                this.namedCredentialId(model.getNamedCredentialId());
            }
            return this;
        }
    }
}

