/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RestCredential
extends ExplicitlySetBmcModel {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="sslTrustStoreType")
    private final SslTrustStoreType sslTrustStoreType;
    @JsonProperty(value="sslTrustStoreLocation")
    private final String sslTrustStoreLocation;
    @JsonProperty(value="sslTrustStorePassword")
    private final String sslTrustStorePassword;

    @Deprecated
    @ConstructorProperties(value={"username", "password", "sslTrustStoreType", "sslTrustStoreLocation", "sslTrustStorePassword"})
    public RestCredential(String username, String password, SslTrustStoreType sslTrustStoreType, String sslTrustStoreLocation, String sslTrustStorePassword) {
        this.username = username;
        this.password = password;
        this.sslTrustStoreType = sslTrustStoreType;
        this.sslTrustStoreLocation = sslTrustStoreLocation;
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SslTrustStoreType getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public String getSslTrustStoreLocation() {
        return this.sslTrustStoreLocation;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RestCredential(");
        sb.append("super=").append(super.toString());
        sb.append("username=").append(String.valueOf(this.username));
        sb.append(", password=").append("<redacted>");
        sb.append(", sslTrustStoreType=").append(String.valueOf((Object)this.sslTrustStoreType));
        sb.append(", sslTrustStoreLocation=").append(String.valueOf(this.sslTrustStoreLocation));
        sb.append(", sslTrustStorePassword=").append("<redacted>");
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestCredential)) {
            return false;
        }
        RestCredential other = (RestCredential)((Object)o);
        return Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals((Object)this.sslTrustStoreType, (Object)other.sslTrustStoreType) && Objects.equals(this.sslTrustStoreLocation, other.sslTrustStoreLocation) && Objects.equals(this.sslTrustStorePassword, other.sslTrustStorePassword) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.sslTrustStoreType == null ? 43 : this.sslTrustStoreType.hashCode());
        result = result * 59 + (this.sslTrustStoreLocation == null ? 43 : this.sslTrustStoreLocation.hashCode());
        result = result * 59 + (this.sslTrustStorePassword == null ? 43 : this.sslTrustStorePassword.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SslTrustStoreType implements BmcEnum
    {
        Jks("JKS"),
        Bcfks("BCFKS");

        private final String value;
        private static Map<String, SslTrustStoreType> map;

        private SslTrustStoreType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SslTrustStoreType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SslTrustStoreType: " + key);
        }

        static {
            map = new HashMap<String, SslTrustStoreType>();
            for (SslTrustStoreType v : SslTrustStoreType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="sslTrustStoreType")
        private SslTrustStoreType sslTrustStoreType;
        @JsonProperty(value="sslTrustStoreLocation")
        private String sslTrustStoreLocation;
        @JsonProperty(value="sslTrustStorePassword")
        private String sslTrustStorePassword;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder sslTrustStoreType(SslTrustStoreType sslTrustStoreType) {
            this.sslTrustStoreType = sslTrustStoreType;
            this.__explicitlySet__.add("sslTrustStoreType");
            return this;
        }

        public Builder sslTrustStoreLocation(String sslTrustStoreLocation) {
            this.sslTrustStoreLocation = sslTrustStoreLocation;
            this.__explicitlySet__.add("sslTrustStoreLocation");
            return this;
        }

        public Builder sslTrustStorePassword(String sslTrustStorePassword) {
            this.sslTrustStorePassword = sslTrustStorePassword;
            this.__explicitlySet__.add("sslTrustStorePassword");
            return this;
        }

        public RestCredential build() {
            RestCredential model = new RestCredential(this.username, this.password, this.sslTrustStoreType, this.sslTrustStoreLocation, this.sslTrustStorePassword);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RestCredential model) {
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("sslTrustStoreType")) {
                this.sslTrustStoreType(model.getSslTrustStoreType());
            }
            if (model.wasPropertyExplicitlySet("sslTrustStoreLocation")) {
                this.sslTrustStoreLocation(model.getSslTrustStoreLocation());
            }
            if (model.wasPropertyExplicitlySet("sslTrustStorePassword")) {
                this.sslTrustStorePassword(model.getSslTrustStorePassword());
            }
            return this;
        }
    }
}

