/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlCpuActivity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseName")
    private final String databaseName;
    @JsonProperty(value="sqlId")
    private final String sqlId;
    @JsonProperty(value="cpuActivity")
    private final Float cpuActivity;

    @Deprecated
    @ConstructorProperties(value={"databaseName", "sqlId", "cpuActivity"})
    public SqlCpuActivity(String databaseName, String sqlId, Float cpuActivity) {
        this.databaseName = databaseName;
        this.sqlId = sqlId;
        this.cpuActivity = cpuActivity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public Float getCpuActivity() {
        return this.cpuActivity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlCpuActivity(");
        sb.append("super=").append(super.toString());
        sb.append("databaseName=").append(String.valueOf(this.databaseName));
        sb.append(", sqlId=").append(String.valueOf(this.sqlId));
        sb.append(", cpuActivity=").append(String.valueOf(this.cpuActivity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlCpuActivity)) {
            return false;
        }
        SqlCpuActivity other = (SqlCpuActivity)((Object)o);
        return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.sqlId, other.sqlId) && Objects.equals(this.cpuActivity, other.cpuActivity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseName == null ? 43 : this.databaseName.hashCode());
        result = result * 59 + (this.sqlId == null ? 43 : this.sqlId.hashCode());
        result = result * 59 + (this.cpuActivity == null ? 43 : this.cpuActivity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseName")
        private String databaseName;
        @JsonProperty(value="sqlId")
        private String sqlId;
        @JsonProperty(value="cpuActivity")
        private Float cpuActivity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.__explicitlySet__.add("databaseName");
            return this;
        }

        public Builder sqlId(String sqlId) {
            this.sqlId = sqlId;
            this.__explicitlySet__.add("sqlId");
            return this;
        }

        public Builder cpuActivity(Float cpuActivity) {
            this.cpuActivity = cpuActivity;
            this.__explicitlySet__.add("cpuActivity");
            return this;
        }

        public SqlCpuActivity build() {
            SqlCpuActivity model = new SqlCpuActivity(this.databaseName, this.sqlId, this.cpuActivity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlCpuActivity model) {
            if (model.wasPropertyExplicitlySet("databaseName")) {
                this.databaseName(model.getDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("sqlId")) {
                this.sqlId(model.getSqlId());
            }
            if (model.wasPropertyExplicitlySet("cpuActivity")) {
                this.cpuActivity(model.getCpuActivity());
            }
            return this;
        }
    }
}

