/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningAdvisorTaskRecommendationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlTuningAdvisorTaskId")
    private final Long sqlTuningAdvisorTaskId;
    @JsonProperty(value="sqlTuningAdvisorTaskObjectId")
    private final Long sqlTuningAdvisorTaskObjectId;
    @JsonProperty(value="recommendationKey")
    private final Integer recommendationKey;
    @JsonProperty(value="recommendationType")
    private final RecommendationType recommendationType;
    @JsonProperty(value="finding")
    private final String finding;
    @JsonProperty(value="recommendation")
    private final String recommendation;
    @JsonProperty(value="rationale")
    private final String rationale;
    @JsonProperty(value="benefit")
    private final Float benefit;
    @JsonProperty(value="implementActionSql")
    private final String implementActionSql;
    @JsonProperty(value="isParallelExecution")
    private final Boolean isParallelExecution;

    @Deprecated
    @ConstructorProperties(value={"sqlTuningAdvisorTaskId", "sqlTuningAdvisorTaskObjectId", "recommendationKey", "recommendationType", "finding", "recommendation", "rationale", "benefit", "implementActionSql", "isParallelExecution"})
    public SqlTuningAdvisorTaskRecommendationSummary(Long sqlTuningAdvisorTaskId, Long sqlTuningAdvisorTaskObjectId, Integer recommendationKey, RecommendationType recommendationType, String finding, String recommendation, String rationale, Float benefit, String implementActionSql, Boolean isParallelExecution) {
        this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
        this.sqlTuningAdvisorTaskObjectId = sqlTuningAdvisorTaskObjectId;
        this.recommendationKey = recommendationKey;
        this.recommendationType = recommendationType;
        this.finding = finding;
        this.recommendation = recommendation;
        this.rationale = rationale;
        this.benefit = benefit;
        this.implementActionSql = implementActionSql;
        this.isParallelExecution = isParallelExecution;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public Long getSqlTuningAdvisorTaskObjectId() {
        return this.sqlTuningAdvisorTaskObjectId;
    }

    public Integer getRecommendationKey() {
        return this.recommendationKey;
    }

    public RecommendationType getRecommendationType() {
        return this.recommendationType;
    }

    public String getFinding() {
        return this.finding;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public String getRationale() {
        return this.rationale;
    }

    public Float getBenefit() {
        return this.benefit;
    }

    public String getImplementActionSql() {
        return this.implementActionSql;
    }

    public Boolean getIsParallelExecution() {
        return this.isParallelExecution;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningAdvisorTaskRecommendationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(", sqlTuningAdvisorTaskObjectId=").append(String.valueOf(this.sqlTuningAdvisorTaskObjectId));
        sb.append(", recommendationKey=").append(String.valueOf(this.recommendationKey));
        sb.append(", recommendationType=").append(String.valueOf((Object)this.recommendationType));
        sb.append(", finding=").append(String.valueOf(this.finding));
        sb.append(", recommendation=").append(String.valueOf(this.recommendation));
        sb.append(", rationale=").append(String.valueOf(this.rationale));
        sb.append(", benefit=").append(String.valueOf(this.benefit));
        sb.append(", implementActionSql=").append(String.valueOf(this.implementActionSql));
        sb.append(", isParallelExecution=").append(String.valueOf(this.isParallelExecution));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningAdvisorTaskRecommendationSummary)) {
            return false;
        }
        SqlTuningAdvisorTaskRecommendationSummary other = (SqlTuningAdvisorTaskRecommendationSummary)((Object)o);
        return Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals(this.sqlTuningAdvisorTaskObjectId, other.sqlTuningAdvisorTaskObjectId) && Objects.equals(this.recommendationKey, other.recommendationKey) && Objects.equals((Object)this.recommendationType, (Object)other.recommendationType) && Objects.equals(this.finding, other.finding) && Objects.equals(this.recommendation, other.recommendation) && Objects.equals(this.rationale, other.rationale) && Objects.equals(this.benefit, other.benefit) && Objects.equals(this.implementActionSql, other.implementActionSql) && Objects.equals(this.isParallelExecution, other.isParallelExecution) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskObjectId == null ? 43 : this.sqlTuningAdvisorTaskObjectId.hashCode());
        result = result * 59 + (this.recommendationKey == null ? 43 : this.recommendationKey.hashCode());
        result = result * 59 + (this.recommendationType == null ? 43 : this.recommendationType.hashCode());
        result = result * 59 + (this.finding == null ? 43 : this.finding.hashCode());
        result = result * 59 + (this.recommendation == null ? 43 : this.recommendation.hashCode());
        result = result * 59 + (this.rationale == null ? 43 : this.rationale.hashCode());
        result = result * 59 + (this.benefit == null ? 43 : this.benefit.hashCode());
        result = result * 59 + (this.implementActionSql == null ? 43 : this.implementActionSql.hashCode());
        result = result * 59 + (this.isParallelExecution == null ? 43 : this.isParallelExecution.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RecommendationType implements BmcEnum
    {
        Statistics("STATISTICS"),
        Index("INDEX"),
        SqlProfile("SQL_PROFILE"),
        RestructureSql("RESTRUCTURE_SQL"),
        AlternativePlans("ALTERNATIVE_PLANS"),
        Error("ERROR"),
        Miscellaneous("MISCELLANEOUS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RecommendationType> map;

        private RecommendationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RecommendationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RecommendationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RecommendationType.class);
            map = new HashMap<String, RecommendationType>();
            for (RecommendationType v : RecommendationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlTuningAdvisorTaskId")
        private Long sqlTuningAdvisorTaskId;
        @JsonProperty(value="sqlTuningAdvisorTaskObjectId")
        private Long sqlTuningAdvisorTaskObjectId;
        @JsonProperty(value="recommendationKey")
        private Integer recommendationKey;
        @JsonProperty(value="recommendationType")
        private RecommendationType recommendationType;
        @JsonProperty(value="finding")
        private String finding;
        @JsonProperty(value="recommendation")
        private String recommendation;
        @JsonProperty(value="rationale")
        private String rationale;
        @JsonProperty(value="benefit")
        private Float benefit;
        @JsonProperty(value="implementActionSql")
        private String implementActionSql;
        @JsonProperty(value="isParallelExecution")
        private Boolean isParallelExecution;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            this.__explicitlySet__.add("sqlTuningAdvisorTaskId");
            return this;
        }

        public Builder sqlTuningAdvisorTaskObjectId(Long sqlTuningAdvisorTaskObjectId) {
            this.sqlTuningAdvisorTaskObjectId = sqlTuningAdvisorTaskObjectId;
            this.__explicitlySet__.add("sqlTuningAdvisorTaskObjectId");
            return this;
        }

        public Builder recommendationKey(Integer recommendationKey) {
            this.recommendationKey = recommendationKey;
            this.__explicitlySet__.add("recommendationKey");
            return this;
        }

        public Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType = recommendationType;
            this.__explicitlySet__.add("recommendationType");
            return this;
        }

        public Builder finding(String finding) {
            this.finding = finding;
            this.__explicitlySet__.add("finding");
            return this;
        }

        public Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            this.__explicitlySet__.add("recommendation");
            return this;
        }

        public Builder rationale(String rationale) {
            this.rationale = rationale;
            this.__explicitlySet__.add("rationale");
            return this;
        }

        public Builder benefit(Float benefit) {
            this.benefit = benefit;
            this.__explicitlySet__.add("benefit");
            return this;
        }

        public Builder implementActionSql(String implementActionSql) {
            this.implementActionSql = implementActionSql;
            this.__explicitlySet__.add("implementActionSql");
            return this;
        }

        public Builder isParallelExecution(Boolean isParallelExecution) {
            this.isParallelExecution = isParallelExecution;
            this.__explicitlySet__.add("isParallelExecution");
            return this;
        }

        public SqlTuningAdvisorTaskRecommendationSummary build() {
            SqlTuningAdvisorTaskRecommendationSummary model = new SqlTuningAdvisorTaskRecommendationSummary(this.sqlTuningAdvisorTaskId, this.sqlTuningAdvisorTaskObjectId, this.recommendationKey, this.recommendationType, this.finding, this.recommendation, this.rationale, this.benefit, this.implementActionSql, this.isParallelExecution);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningAdvisorTaskRecommendationSummary model) {
            if (model.wasPropertyExplicitlySet("sqlTuningAdvisorTaskId")) {
                this.sqlTuningAdvisorTaskId(model.getSqlTuningAdvisorTaskId());
            }
            if (model.wasPropertyExplicitlySet("sqlTuningAdvisorTaskObjectId")) {
                this.sqlTuningAdvisorTaskObjectId(model.getSqlTuningAdvisorTaskObjectId());
            }
            if (model.wasPropertyExplicitlySet("recommendationKey")) {
                this.recommendationKey(model.getRecommendationKey());
            }
            if (model.wasPropertyExplicitlySet("recommendationType")) {
                this.recommendationType(model.getRecommendationType());
            }
            if (model.wasPropertyExplicitlySet("finding")) {
                this.finding(model.getFinding());
            }
            if (model.wasPropertyExplicitlySet("recommendation")) {
                this.recommendation(model.getRecommendation());
            }
            if (model.wasPropertyExplicitlySet("rationale")) {
                this.rationale(model.getRationale());
            }
            if (model.wasPropertyExplicitlySet("benefit")) {
                this.benefit(model.getBenefit());
            }
            if (model.wasPropertyExplicitlySet("implementActionSql")) {
                this.implementActionSql(model.getImplementActionSql());
            }
            if (model.wasPropertyExplicitlySet("isParallelExecution")) {
                this.isParallelExecution(model.getIsParallelExecution());
            }
            return this;
        }
    }
}

