/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentialDetails;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetInput;
import com.oracle.bmc.databasemanagement.model.SqlTuningTaskCredentialDetails;
import com.oracle.bmc.databasemanagement.model.SqlTuningTaskSqlDetail;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StartSqlTuningTaskDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="taskName")
    private final String taskName;
    @JsonProperty(value="taskDescription")
    private final String taskDescription;
    @JsonProperty(value="credentialDetails")
    private final SqlTuningTaskCredentialDetails credentialDetails;
    @JsonProperty(value="databaseCredential")
    private final DatabaseCredentialDetails databaseCredential;
    @JsonProperty(value="totalTimeLimitInMinutes")
    private final Integer totalTimeLimitInMinutes;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="statementTimeLimitInMinutes")
    private final Integer statementTimeLimitInMinutes;
    @JsonProperty(value="sqlTuningSet")
    private final SqlTuningSetInput sqlTuningSet;
    @JsonProperty(value="sqlDetails")
    private final List<SqlTuningTaskSqlDetail> sqlDetails;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;

    @Deprecated
    @ConstructorProperties(value={"taskName", "taskDescription", "credentialDetails", "databaseCredential", "totalTimeLimitInMinutes", "scope", "statementTimeLimitInMinutes", "sqlTuningSet", "sqlDetails", "timeStarted", "timeEnded"})
    public StartSqlTuningTaskDetails(String taskName, String taskDescription, SqlTuningTaskCredentialDetails credentialDetails, DatabaseCredentialDetails databaseCredential, Integer totalTimeLimitInMinutes, Scope scope, Integer statementTimeLimitInMinutes, SqlTuningSetInput sqlTuningSet, List<SqlTuningTaskSqlDetail> sqlDetails, Date timeStarted, Date timeEnded) {
        this.taskName = taskName;
        this.taskDescription = taskDescription;
        this.credentialDetails = credentialDetails;
        this.databaseCredential = databaseCredential;
        this.totalTimeLimitInMinutes = totalTimeLimitInMinutes;
        this.scope = scope;
        this.statementTimeLimitInMinutes = statementTimeLimitInMinutes;
        this.sqlTuningSet = sqlTuningSet;
        this.sqlDetails = sqlDetails;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public SqlTuningTaskCredentialDetails getCredentialDetails() {
        return this.credentialDetails;
    }

    public DatabaseCredentialDetails getDatabaseCredential() {
        return this.databaseCredential;
    }

    public Integer getTotalTimeLimitInMinutes() {
        return this.totalTimeLimitInMinutes;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Integer getStatementTimeLimitInMinutes() {
        return this.statementTimeLimitInMinutes;
    }

    public SqlTuningSetInput getSqlTuningSet() {
        return this.sqlTuningSet;
    }

    public List<SqlTuningTaskSqlDetail> getSqlDetails() {
        return this.sqlDetails;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StartSqlTuningTaskDetails(");
        sb.append("super=").append(super.toString());
        sb.append("taskName=").append(String.valueOf(this.taskName));
        sb.append(", taskDescription=").append(String.valueOf(this.taskDescription));
        sb.append(", credentialDetails=").append(String.valueOf((Object)this.credentialDetails));
        sb.append(", databaseCredential=").append(String.valueOf((Object)this.databaseCredential));
        sb.append(", totalTimeLimitInMinutes=").append(String.valueOf(this.totalTimeLimitInMinutes));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", statementTimeLimitInMinutes=").append(String.valueOf(this.statementTimeLimitInMinutes));
        sb.append(", sqlTuningSet=").append(String.valueOf((Object)this.sqlTuningSet));
        sb.append(", sqlDetails=").append(String.valueOf(this.sqlDetails));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StartSqlTuningTaskDetails)) {
            return false;
        }
        StartSqlTuningTaskDetails other = (StartSqlTuningTaskDetails)((Object)o);
        return Objects.equals(this.taskName, other.taskName) && Objects.equals(this.taskDescription, other.taskDescription) && Objects.equals((Object)this.credentialDetails, (Object)other.credentialDetails) && Objects.equals((Object)this.databaseCredential, (Object)other.databaseCredential) && Objects.equals(this.totalTimeLimitInMinutes, other.totalTimeLimitInMinutes) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.statementTimeLimitInMinutes, other.statementTimeLimitInMinutes) && Objects.equals((Object)this.sqlTuningSet, (Object)other.sqlTuningSet) && Objects.equals(this.sqlDetails, other.sqlDetails) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.taskName == null ? 43 : this.taskName.hashCode());
        result = result * 59 + (this.taskDescription == null ? 43 : this.taskDescription.hashCode());
        result = result * 59 + (this.credentialDetails == null ? 43 : this.credentialDetails.hashCode());
        result = result * 59 + (this.databaseCredential == null ? 43 : this.databaseCredential.hashCode());
        result = result * 59 + (this.totalTimeLimitInMinutes == null ? 43 : this.totalTimeLimitInMinutes.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.statementTimeLimitInMinutes == null ? 43 : this.statementTimeLimitInMinutes.hashCode());
        result = result * 59 + (this.sqlTuningSet == null ? 43 : this.sqlTuningSet.hashCode());
        result = result * 59 + (this.sqlDetails == null ? 43 : this.sqlDetails.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Scope implements BmcEnum
    {
        Limited("LIMITED"),
        Comprehensive("COMPREHENSIVE");

        private final String value;
        private static Map<String, Scope> map;

        private Scope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Scope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Scope: " + key);
        }

        static {
            map = new HashMap<String, Scope>();
            for (Scope v : Scope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="taskName")
        private String taskName;
        @JsonProperty(value="taskDescription")
        private String taskDescription;
        @JsonProperty(value="credentialDetails")
        private SqlTuningTaskCredentialDetails credentialDetails;
        @JsonProperty(value="databaseCredential")
        private DatabaseCredentialDetails databaseCredential;
        @JsonProperty(value="totalTimeLimitInMinutes")
        private Integer totalTimeLimitInMinutes;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="statementTimeLimitInMinutes")
        private Integer statementTimeLimitInMinutes;
        @JsonProperty(value="sqlTuningSet")
        private SqlTuningSetInput sqlTuningSet;
        @JsonProperty(value="sqlDetails")
        private List<SqlTuningTaskSqlDetail> sqlDetails;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            this.__explicitlySet__.add("taskName");
            return this;
        }

        public Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            this.__explicitlySet__.add("taskDescription");
            return this;
        }

        public Builder credentialDetails(SqlTuningTaskCredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            this.__explicitlySet__.add("credentialDetails");
            return this;
        }

        public Builder databaseCredential(DatabaseCredentialDetails databaseCredential) {
            this.databaseCredential = databaseCredential;
            this.__explicitlySet__.add("databaseCredential");
            return this;
        }

        public Builder totalTimeLimitInMinutes(Integer totalTimeLimitInMinutes) {
            this.totalTimeLimitInMinutes = totalTimeLimitInMinutes;
            this.__explicitlySet__.add("totalTimeLimitInMinutes");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder statementTimeLimitInMinutes(Integer statementTimeLimitInMinutes) {
            this.statementTimeLimitInMinutes = statementTimeLimitInMinutes;
            this.__explicitlySet__.add("statementTimeLimitInMinutes");
            return this;
        }

        public Builder sqlTuningSet(SqlTuningSetInput sqlTuningSet) {
            this.sqlTuningSet = sqlTuningSet;
            this.__explicitlySet__.add("sqlTuningSet");
            return this;
        }

        public Builder sqlDetails(List<SqlTuningTaskSqlDetail> sqlDetails) {
            this.sqlDetails = sqlDetails;
            this.__explicitlySet__.add("sqlDetails");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public StartSqlTuningTaskDetails build() {
            StartSqlTuningTaskDetails model = new StartSqlTuningTaskDetails(this.taskName, this.taskDescription, this.credentialDetails, this.databaseCredential, this.totalTimeLimitInMinutes, this.scope, this.statementTimeLimitInMinutes, this.sqlTuningSet, this.sqlDetails, this.timeStarted, this.timeEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StartSqlTuningTaskDetails model) {
            if (model.wasPropertyExplicitlySet("taskName")) {
                this.taskName(model.getTaskName());
            }
            if (model.wasPropertyExplicitlySet("taskDescription")) {
                this.taskDescription(model.getTaskDescription());
            }
            if (model.wasPropertyExplicitlySet("credentialDetails")) {
                this.credentialDetails(model.getCredentialDetails());
            }
            if (model.wasPropertyExplicitlySet("databaseCredential")) {
                this.databaseCredential(model.getDatabaseCredential());
            }
            if (model.wasPropertyExplicitlySet("totalTimeLimitInMinutes")) {
                this.totalTimeLimitInMinutes(model.getTotalTimeLimitInMinutes());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("statementTimeLimitInMinutes")) {
                this.statementTimeLimitInMinutes(model.getStatementTimeLimitInMinutes());
            }
            if (model.wasPropertyExplicitlySet("sqlTuningSet")) {
                this.sqlTuningSet(model.getSqlTuningSet());
            }
            if (model.wasPropertyExplicitlySet("sqlDetails")) {
                this.sqlDetails(model.getSqlDetails());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            return this;
        }
    }
}

