/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SystemPrivilegeSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="adminOption")
    private final AdminOption adminOption;
    @JsonProperty(value="common")
    private final Common common;
    @JsonProperty(value="inherited")
    private final Inherited inherited;

    @Deprecated
    @ConstructorProperties(value={"name", "adminOption", "common", "inherited"})
    public SystemPrivilegeSummary(String name, AdminOption adminOption, Common common, Inherited inherited) {
        this.name = name;
        this.adminOption = adminOption;
        this.common = common;
        this.inherited = inherited;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public AdminOption getAdminOption() {
        return this.adminOption;
    }

    public Common getCommon() {
        return this.common;
    }

    public Inherited getInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemPrivilegeSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", adminOption=").append(String.valueOf((Object)this.adminOption));
        sb.append(", common=").append(String.valueOf((Object)this.common));
        sb.append(", inherited=").append(String.valueOf((Object)this.inherited));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemPrivilegeSummary)) {
            return false;
        }
        SystemPrivilegeSummary other = (SystemPrivilegeSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.adminOption, (Object)other.adminOption) && Objects.equals((Object)this.common, (Object)other.common) && Objects.equals((Object)this.inherited, (Object)other.inherited) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.adminOption == null ? 43 : this.adminOption.hashCode());
        result = result * 59 + (this.common == null ? 43 : this.common.hashCode());
        result = result * 59 + (this.inherited == null ? 43 : this.inherited.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Inherited implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Inherited> map;

        private Inherited(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Inherited create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Inherited', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Inherited.class);
            map = new HashMap<String, Inherited>();
            for (Inherited v : Inherited.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Common implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Common> map;

        private Common(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Common create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Common', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Common.class);
            map = new HashMap<String, Common>();
            for (Common v : Common.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AdminOption implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AdminOption> map;

        private AdminOption(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AdminOption create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AdminOption', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AdminOption.class);
            map = new HashMap<String, AdminOption>();
            for (AdminOption v : AdminOption.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="adminOption")
        private AdminOption adminOption;
        @JsonProperty(value="common")
        private Common common;
        @JsonProperty(value="inherited")
        private Inherited inherited;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder adminOption(AdminOption adminOption) {
            this.adminOption = adminOption;
            this.__explicitlySet__.add("adminOption");
            return this;
        }

        public Builder common(Common common) {
            this.common = common;
            this.__explicitlySet__.add("common");
            return this;
        }

        public Builder inherited(Inherited inherited) {
            this.inherited = inherited;
            this.__explicitlySet__.add("inherited");
            return this;
        }

        public SystemPrivilegeSummary build() {
            SystemPrivilegeSummary model = new SystemPrivilegeSummary(this.name, this.adminOption, this.common, this.inherited);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SystemPrivilegeSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("adminOption")) {
                this.adminOption(model.getAdminOption());
            }
            if (model.wasPropertyExplicitlySet("common")) {
                this.common(model.getCommon());
            }
            if (model.wasPropertyExplicitlySet("inherited")) {
                this.inherited(model.getInherited());
            }
            return this;
        }
    }
}

