/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class User
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeLocked")
    private final Date timeLocked;
    @JsonProperty(value="timeExpiring")
    private final Date timeExpiring;
    @JsonProperty(value="defaultTablespace")
    private final String defaultTablespace;
    @JsonProperty(value="tempTablespace")
    private final String tempTablespace;
    @JsonProperty(value="localTempTablespace")
    private final String localTempTablespace;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="profile")
    private final String profile;
    @JsonProperty(value="consumerGroup")
    private final String consumerGroup;
    @JsonProperty(value="externalName")
    private final String externalName;
    @JsonProperty(value="passwordVersions")
    private final String passwordVersions;
    @JsonProperty(value="editionsEnabled")
    private final EditionsEnabled editionsEnabled;
    @JsonProperty(value="authentication")
    private final Authentication authentication;
    @JsonProperty(value="proxyConnect")
    private final ProxyConnect proxyConnect;
    @JsonProperty(value="common")
    private final Common common;
    @JsonProperty(value="timeLastLogin")
    private final Date timeLastLogin;
    @JsonProperty(value="oracleMaintained")
    private final OracleMaintained oracleMaintained;
    @JsonProperty(value="inherited")
    private final Inherited inherited;
    @JsonProperty(value="defaultCollation")
    private final String defaultCollation;
    @JsonProperty(value="implicit")
    private final Implicit implicit;
    @JsonProperty(value="allShared")
    private final AllShared allShared;
    @JsonProperty(value="externalShared")
    private final ExternalShared externalShared;
    @JsonProperty(value="timePasswordChanged")
    private final Date timePasswordChanged;

    @Deprecated
    @ConstructorProperties(value={"name", "status", "timeLocked", "timeExpiring", "defaultTablespace", "tempTablespace", "localTempTablespace", "timeCreated", "profile", "consumerGroup", "externalName", "passwordVersions", "editionsEnabled", "authentication", "proxyConnect", "common", "timeLastLogin", "oracleMaintained", "inherited", "defaultCollation", "implicit", "allShared", "externalShared", "timePasswordChanged"})
    public User(String name, Status status, Date timeLocked, Date timeExpiring, String defaultTablespace, String tempTablespace, String localTempTablespace, Date timeCreated, String profile, String consumerGroup, String externalName, String passwordVersions, EditionsEnabled editionsEnabled, Authentication authentication, ProxyConnect proxyConnect, Common common, Date timeLastLogin, OracleMaintained oracleMaintained, Inherited inherited, String defaultCollation, Implicit implicit, AllShared allShared, ExternalShared externalShared, Date timePasswordChanged) {
        this.name = name;
        this.status = status;
        this.timeLocked = timeLocked;
        this.timeExpiring = timeExpiring;
        this.defaultTablespace = defaultTablespace;
        this.tempTablespace = tempTablespace;
        this.localTempTablespace = localTempTablespace;
        this.timeCreated = timeCreated;
        this.profile = profile;
        this.consumerGroup = consumerGroup;
        this.externalName = externalName;
        this.passwordVersions = passwordVersions;
        this.editionsEnabled = editionsEnabled;
        this.authentication = authentication;
        this.proxyConnect = proxyConnect;
        this.common = common;
        this.timeLastLogin = timeLastLogin;
        this.oracleMaintained = oracleMaintained;
        this.inherited = inherited;
        this.defaultCollation = defaultCollation;
        this.implicit = implicit;
        this.allShared = allShared;
        this.externalShared = externalShared;
        this.timePasswordChanged = timePasswordChanged;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeLocked() {
        return this.timeLocked;
    }

    public Date getTimeExpiring() {
        return this.timeExpiring;
    }

    public String getDefaultTablespace() {
        return this.defaultTablespace;
    }

    public String getTempTablespace() {
        return this.tempTablespace;
    }

    public String getLocalTempTablespace() {
        return this.localTempTablespace;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getPasswordVersions() {
        return this.passwordVersions;
    }

    public EditionsEnabled getEditionsEnabled() {
        return this.editionsEnabled;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ProxyConnect getProxyConnect() {
        return this.proxyConnect;
    }

    public Common getCommon() {
        return this.common;
    }

    public Date getTimeLastLogin() {
        return this.timeLastLogin;
    }

    public OracleMaintained getOracleMaintained() {
        return this.oracleMaintained;
    }

    public Inherited getInherited() {
        return this.inherited;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public Implicit getImplicit() {
        return this.implicit;
    }

    public AllShared getAllShared() {
        return this.allShared;
    }

    public ExternalShared getExternalShared() {
        return this.externalShared;
    }

    public Date getTimePasswordChanged() {
        return this.timePasswordChanged;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("User(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeLocked=").append(String.valueOf(this.timeLocked));
        sb.append(", timeExpiring=").append(String.valueOf(this.timeExpiring));
        sb.append(", defaultTablespace=").append(String.valueOf(this.defaultTablespace));
        sb.append(", tempTablespace=").append(String.valueOf(this.tempTablespace));
        sb.append(", localTempTablespace=").append(String.valueOf(this.localTempTablespace));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", profile=").append(String.valueOf(this.profile));
        sb.append(", consumerGroup=").append(String.valueOf(this.consumerGroup));
        sb.append(", externalName=").append(String.valueOf(this.externalName));
        sb.append(", passwordVersions=").append(String.valueOf(this.passwordVersions));
        sb.append(", editionsEnabled=").append(String.valueOf((Object)this.editionsEnabled));
        sb.append(", authentication=").append(String.valueOf((Object)this.authentication));
        sb.append(", proxyConnect=").append(String.valueOf((Object)this.proxyConnect));
        sb.append(", common=").append(String.valueOf((Object)this.common));
        sb.append(", timeLastLogin=").append(String.valueOf(this.timeLastLogin));
        sb.append(", oracleMaintained=").append(String.valueOf((Object)this.oracleMaintained));
        sb.append(", inherited=").append(String.valueOf((Object)this.inherited));
        sb.append(", defaultCollation=").append(String.valueOf(this.defaultCollation));
        sb.append(", implicit=").append(String.valueOf((Object)this.implicit));
        sb.append(", allShared=").append(String.valueOf((Object)this.allShared));
        sb.append(", externalShared=").append(String.valueOf((Object)this.externalShared));
        sb.append(", timePasswordChanged=").append(String.valueOf(this.timePasswordChanged));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeLocked, other.timeLocked) && Objects.equals(this.timeExpiring, other.timeExpiring) && Objects.equals(this.defaultTablespace, other.defaultTablespace) && Objects.equals(this.tempTablespace, other.tempTablespace) && Objects.equals(this.localTempTablespace, other.localTempTablespace) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.profile, other.profile) && Objects.equals(this.consumerGroup, other.consumerGroup) && Objects.equals(this.externalName, other.externalName) && Objects.equals(this.passwordVersions, other.passwordVersions) && Objects.equals((Object)this.editionsEnabled, (Object)other.editionsEnabled) && Objects.equals((Object)this.authentication, (Object)other.authentication) && Objects.equals((Object)this.proxyConnect, (Object)other.proxyConnect) && Objects.equals((Object)this.common, (Object)other.common) && Objects.equals(this.timeLastLogin, other.timeLastLogin) && Objects.equals((Object)this.oracleMaintained, (Object)other.oracleMaintained) && Objects.equals((Object)this.inherited, (Object)other.inherited) && Objects.equals(this.defaultCollation, other.defaultCollation) && Objects.equals((Object)this.implicit, (Object)other.implicit) && Objects.equals((Object)this.allShared, (Object)other.allShared) && Objects.equals((Object)this.externalShared, (Object)other.externalShared) && Objects.equals(this.timePasswordChanged, other.timePasswordChanged) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeLocked == null ? 43 : this.timeLocked.hashCode());
        result = result * 59 + (this.timeExpiring == null ? 43 : this.timeExpiring.hashCode());
        result = result * 59 + (this.defaultTablespace == null ? 43 : this.defaultTablespace.hashCode());
        result = result * 59 + (this.tempTablespace == null ? 43 : this.tempTablespace.hashCode());
        result = result * 59 + (this.localTempTablespace == null ? 43 : this.localTempTablespace.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.profile == null ? 43 : this.profile.hashCode());
        result = result * 59 + (this.consumerGroup == null ? 43 : this.consumerGroup.hashCode());
        result = result * 59 + (this.externalName == null ? 43 : this.externalName.hashCode());
        result = result * 59 + (this.passwordVersions == null ? 43 : this.passwordVersions.hashCode());
        result = result * 59 + (this.editionsEnabled == null ? 43 : this.editionsEnabled.hashCode());
        result = result * 59 + (this.authentication == null ? 43 : this.authentication.hashCode());
        result = result * 59 + (this.proxyConnect == null ? 43 : this.proxyConnect.hashCode());
        result = result * 59 + (this.common == null ? 43 : this.common.hashCode());
        result = result * 59 + (this.timeLastLogin == null ? 43 : this.timeLastLogin.hashCode());
        result = result * 59 + (this.oracleMaintained == null ? 43 : this.oracleMaintained.hashCode());
        result = result * 59 + (this.inherited == null ? 43 : this.inherited.hashCode());
        result = result * 59 + (this.defaultCollation == null ? 43 : this.defaultCollation.hashCode());
        result = result * 59 + (this.implicit == null ? 43 : this.implicit.hashCode());
        result = result * 59 + (this.allShared == null ? 43 : this.allShared.hashCode());
        result = result * 59 + (this.externalShared == null ? 43 : this.externalShared.hashCode());
        result = result * 59 + (this.timePasswordChanged == null ? 43 : this.timePasswordChanged.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExternalShared implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExternalShared> map;

        private ExternalShared(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExternalShared create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExternalShared', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExternalShared.class);
            map = new HashMap<String, ExternalShared>();
            for (ExternalShared v : ExternalShared.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AllShared implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllShared> map;

        private AllShared(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllShared create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllShared', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllShared.class);
            map = new HashMap<String, AllShared>();
            for (AllShared v : AllShared.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Implicit implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Implicit> map;

        private Implicit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Implicit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Implicit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Implicit.class);
            map = new HashMap<String, Implicit>();
            for (Implicit v : Implicit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Inherited implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Inherited> map;

        private Inherited(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Inherited create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Inherited', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Inherited.class);
            map = new HashMap<String, Inherited>();
            for (Inherited v : Inherited.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OracleMaintained implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OracleMaintained> map;

        private OracleMaintained(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OracleMaintained create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OracleMaintained', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OracleMaintained.class);
            map = new HashMap<String, OracleMaintained>();
            for (OracleMaintained v : OracleMaintained.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Common implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Common> map;

        private Common(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Common create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Common', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Common.class);
            map = new HashMap<String, Common>();
            for (Common v : Common.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ProxyConnect implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ProxyConnect> map;

        private ProxyConnect(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ProxyConnect create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ProxyConnect', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ProxyConnect.class);
            map = new HashMap<String, ProxyConnect>();
            for (ProxyConnect v : ProxyConnect.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Authentication implements BmcEnum
    {
        None("NONE"),
        External("EXTERNAL"),
        Global("GLOBAL"),
        Password("PASSWORD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Authentication> map;

        private Authentication(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Authentication create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Authentication', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Authentication.class);
            map = new HashMap<String, Authentication>();
            for (Authentication v : Authentication.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EditionsEnabled implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EditionsEnabled> map;

        private EditionsEnabled(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EditionsEnabled create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EditionsEnabled', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EditionsEnabled.class);
            map = new HashMap<String, EditionsEnabled>();
            for (EditionsEnabled v : EditionsEnabled.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Open("OPEN"),
        Expired("EXPIRED"),
        ExpiredGrace("EXPIRED_GRACE"),
        Locked("LOCKED"),
        LockedTimed("LOCKED_TIMED"),
        ExpiredAndLocked("EXPIRED_AND_LOCKED"),
        ExpiredGraceAndLocked("EXPIRED_GRACE_AND_LOCKED"),
        ExpiredAndLockedTimed("EXPIRED_AND_LOCKED_TIMED"),
        ExpiredGraceAndLockedTimed("EXPIRED_GRACE_AND_LOCKED_TIMED"),
        OpenAndInRollover("OPEN_AND_IN_ROLLOVER"),
        ExpiredAndInRollover("EXPIRED_AND_IN_ROLLOVER"),
        LockedAndInRollover("LOCKED_AND_IN_ROLLOVER"),
        ExpiredAndLockedAndInRollover("EXPIRED_AND_LOCKED_AND_IN_ROLLOVER"),
        LockedTimedAndInRollover("LOCKED_TIMED_AND_IN_ROLLOVER"),
        ExpiredAndLockedTimedAndInRol("EXPIRED_AND_LOCKED_TIMED_AND_IN_ROL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeLocked")
        private Date timeLocked;
        @JsonProperty(value="timeExpiring")
        private Date timeExpiring;
        @JsonProperty(value="defaultTablespace")
        private String defaultTablespace;
        @JsonProperty(value="tempTablespace")
        private String tempTablespace;
        @JsonProperty(value="localTempTablespace")
        private String localTempTablespace;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="profile")
        private String profile;
        @JsonProperty(value="consumerGroup")
        private String consumerGroup;
        @JsonProperty(value="externalName")
        private String externalName;
        @JsonProperty(value="passwordVersions")
        private String passwordVersions;
        @JsonProperty(value="editionsEnabled")
        private EditionsEnabled editionsEnabled;
        @JsonProperty(value="authentication")
        private Authentication authentication;
        @JsonProperty(value="proxyConnect")
        private ProxyConnect proxyConnect;
        @JsonProperty(value="common")
        private Common common;
        @JsonProperty(value="timeLastLogin")
        private Date timeLastLogin;
        @JsonProperty(value="oracleMaintained")
        private OracleMaintained oracleMaintained;
        @JsonProperty(value="inherited")
        private Inherited inherited;
        @JsonProperty(value="defaultCollation")
        private String defaultCollation;
        @JsonProperty(value="implicit")
        private Implicit implicit;
        @JsonProperty(value="allShared")
        private AllShared allShared;
        @JsonProperty(value="externalShared")
        private ExternalShared externalShared;
        @JsonProperty(value="timePasswordChanged")
        private Date timePasswordChanged;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeLocked(Date timeLocked) {
            this.timeLocked = timeLocked;
            this.__explicitlySet__.add("timeLocked");
            return this;
        }

        public Builder timeExpiring(Date timeExpiring) {
            this.timeExpiring = timeExpiring;
            this.__explicitlySet__.add("timeExpiring");
            return this;
        }

        public Builder defaultTablespace(String defaultTablespace) {
            this.defaultTablespace = defaultTablespace;
            this.__explicitlySet__.add("defaultTablespace");
            return this;
        }

        public Builder tempTablespace(String tempTablespace) {
            this.tempTablespace = tempTablespace;
            this.__explicitlySet__.add("tempTablespace");
            return this;
        }

        public Builder localTempTablespace(String localTempTablespace) {
            this.localTempTablespace = localTempTablespace;
            this.__explicitlySet__.add("localTempTablespace");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            this.__explicitlySet__.add("profile");
            return this;
        }

        public Builder consumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            this.__explicitlySet__.add("consumerGroup");
            return this;
        }

        public Builder externalName(String externalName) {
            this.externalName = externalName;
            this.__explicitlySet__.add("externalName");
            return this;
        }

        public Builder passwordVersions(String passwordVersions) {
            this.passwordVersions = passwordVersions;
            this.__explicitlySet__.add("passwordVersions");
            return this;
        }

        public Builder editionsEnabled(EditionsEnabled editionsEnabled) {
            this.editionsEnabled = editionsEnabled;
            this.__explicitlySet__.add("editionsEnabled");
            return this;
        }

        public Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            this.__explicitlySet__.add("authentication");
            return this;
        }

        public Builder proxyConnect(ProxyConnect proxyConnect) {
            this.proxyConnect = proxyConnect;
            this.__explicitlySet__.add("proxyConnect");
            return this;
        }

        public Builder common(Common common) {
            this.common = common;
            this.__explicitlySet__.add("common");
            return this;
        }

        public Builder timeLastLogin(Date timeLastLogin) {
            this.timeLastLogin = timeLastLogin;
            this.__explicitlySet__.add("timeLastLogin");
            return this;
        }

        public Builder oracleMaintained(OracleMaintained oracleMaintained) {
            this.oracleMaintained = oracleMaintained;
            this.__explicitlySet__.add("oracleMaintained");
            return this;
        }

        public Builder inherited(Inherited inherited) {
            this.inherited = inherited;
            this.__explicitlySet__.add("inherited");
            return this;
        }

        public Builder defaultCollation(String defaultCollation) {
            this.defaultCollation = defaultCollation;
            this.__explicitlySet__.add("defaultCollation");
            return this;
        }

        public Builder implicit(Implicit implicit) {
            this.implicit = implicit;
            this.__explicitlySet__.add("implicit");
            return this;
        }

        public Builder allShared(AllShared allShared) {
            this.allShared = allShared;
            this.__explicitlySet__.add("allShared");
            return this;
        }

        public Builder externalShared(ExternalShared externalShared) {
            this.externalShared = externalShared;
            this.__explicitlySet__.add("externalShared");
            return this;
        }

        public Builder timePasswordChanged(Date timePasswordChanged) {
            this.timePasswordChanged = timePasswordChanged;
            this.__explicitlySet__.add("timePasswordChanged");
            return this;
        }

        public User build() {
            User model = new User(this.name, this.status, this.timeLocked, this.timeExpiring, this.defaultTablespace, this.tempTablespace, this.localTempTablespace, this.timeCreated, this.profile, this.consumerGroup, this.externalName, this.passwordVersions, this.editionsEnabled, this.authentication, this.proxyConnect, this.common, this.timeLastLogin, this.oracleMaintained, this.inherited, this.defaultCollation, this.implicit, this.allShared, this.externalShared, this.timePasswordChanged);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(User model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeLocked")) {
                this.timeLocked(model.getTimeLocked());
            }
            if (model.wasPropertyExplicitlySet("timeExpiring")) {
                this.timeExpiring(model.getTimeExpiring());
            }
            if (model.wasPropertyExplicitlySet("defaultTablespace")) {
                this.defaultTablespace(model.getDefaultTablespace());
            }
            if (model.wasPropertyExplicitlySet("tempTablespace")) {
                this.tempTablespace(model.getTempTablespace());
            }
            if (model.wasPropertyExplicitlySet("localTempTablespace")) {
                this.localTempTablespace(model.getLocalTempTablespace());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("profile")) {
                this.profile(model.getProfile());
            }
            if (model.wasPropertyExplicitlySet("consumerGroup")) {
                this.consumerGroup(model.getConsumerGroup());
            }
            if (model.wasPropertyExplicitlySet("externalName")) {
                this.externalName(model.getExternalName());
            }
            if (model.wasPropertyExplicitlySet("passwordVersions")) {
                this.passwordVersions(model.getPasswordVersions());
            }
            if (model.wasPropertyExplicitlySet("editionsEnabled")) {
                this.editionsEnabled(model.getEditionsEnabled());
            }
            if (model.wasPropertyExplicitlySet("authentication")) {
                this.authentication(model.getAuthentication());
            }
            if (model.wasPropertyExplicitlySet("proxyConnect")) {
                this.proxyConnect(model.getProxyConnect());
            }
            if (model.wasPropertyExplicitlySet("common")) {
                this.common(model.getCommon());
            }
            if (model.wasPropertyExplicitlySet("timeLastLogin")) {
                this.timeLastLogin(model.getTimeLastLogin());
            }
            if (model.wasPropertyExplicitlySet("oracleMaintained")) {
                this.oracleMaintained(model.getOracleMaintained());
            }
            if (model.wasPropertyExplicitlySet("inherited")) {
                this.inherited(model.getInherited());
            }
            if (model.wasPropertyExplicitlySet("defaultCollation")) {
                this.defaultCollation(model.getDefaultCollation());
            }
            if (model.wasPropertyExplicitlySet("implicit")) {
                this.implicit(model.getImplicit());
            }
            if (model.wasPropertyExplicitlySet("allShared")) {
                this.allShared(model.getAllShared());
            }
            if (model.wasPropertyExplicitlySet("externalShared")) {
                this.externalShared(model.getExternalShared());
            }
            if (model.wasPropertyExplicitlySet("timePasswordChanged")) {
                this.timePasswordChanged(model.getTimePasswordChanged());
            }
            return this;
        }
    }
}

