/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalClusterInstanceRequest
extends BmcRequest<Void> {
    private String externalClusterInstanceId;
    private String opcRequestId;

    public String getExternalClusterInstanceId() {
        return this.externalClusterInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalClusterInstanceId(this.externalClusterInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalClusterInstanceId=").append(String.valueOf(this.externalClusterInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalClusterInstanceRequest)) {
            return false;
        }
        GetExternalClusterInstanceRequest other = (GetExternalClusterInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalClusterInstanceId, other.externalClusterInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalClusterInstanceId == null ? 43 : this.externalClusterInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalClusterInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalClusterInstanceId = null;
        private String opcRequestId = null;

        public Builder externalClusterInstanceId(String externalClusterInstanceId) {
            this.externalClusterInstanceId = externalClusterInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalClusterInstanceRequest o) {
            this.externalClusterInstanceId(o.getExternalClusterInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalClusterInstanceRequest build() {
            GetExternalClusterInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalClusterInstanceRequest buildWithoutInvocationCallback() {
            GetExternalClusterInstanceRequest request = new GetExternalClusterInstanceRequest();
            request.externalClusterInstanceId = this.externalClusterInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

