/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetSqlTuningAdvisorTaskSummaryReportRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private Long sqlTuningAdvisorTaskId;
    private SearchPeriod searchPeriod;
    private Date timeGreaterThanOrEqualTo;
    private Date timeLessThanOrEqualTo;
    private Long beginExecIdGreaterThanOrEqualTo;
    private Long endExecIdLessThanOrEqualTo;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Long getSqlTuningAdvisorTaskId() {
        return this.sqlTuningAdvisorTaskId;
    }

    public SearchPeriod getSearchPeriod() {
        return this.searchPeriod;
    }

    public Date getTimeGreaterThanOrEqualTo() {
        return this.timeGreaterThanOrEqualTo;
    }

    public Date getTimeLessThanOrEqualTo() {
        return this.timeLessThanOrEqualTo;
    }

    public Long getBeginExecIdGreaterThanOrEqualTo() {
        return this.beginExecIdGreaterThanOrEqualTo;
    }

    public Long getEndExecIdLessThanOrEqualTo() {
        return this.endExecIdLessThanOrEqualTo;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningAdvisorTaskId(this.sqlTuningAdvisorTaskId).searchPeriod(this.searchPeriod).timeGreaterThanOrEqualTo(this.timeGreaterThanOrEqualTo).timeLessThanOrEqualTo(this.timeLessThanOrEqualTo).beginExecIdGreaterThanOrEqualTo(this.beginExecIdGreaterThanOrEqualTo).endExecIdLessThanOrEqualTo(this.endExecIdLessThanOrEqualTo).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningAdvisorTaskId=").append(String.valueOf(this.sqlTuningAdvisorTaskId));
        sb.append(",searchPeriod=").append(String.valueOf((Object)this.searchPeriod));
        sb.append(",timeGreaterThanOrEqualTo=").append(String.valueOf(this.timeGreaterThanOrEqualTo));
        sb.append(",timeLessThanOrEqualTo=").append(String.valueOf(this.timeLessThanOrEqualTo));
        sb.append(",beginExecIdGreaterThanOrEqualTo=").append(String.valueOf(this.beginExecIdGreaterThanOrEqualTo));
        sb.append(",endExecIdLessThanOrEqualTo=").append(String.valueOf(this.endExecIdLessThanOrEqualTo));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSqlTuningAdvisorTaskSummaryReportRequest)) {
            return false;
        }
        GetSqlTuningAdvisorTaskSummaryReportRequest other = (GetSqlTuningAdvisorTaskSummaryReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningAdvisorTaskId, other.sqlTuningAdvisorTaskId) && Objects.equals((Object)this.searchPeriod, (Object)other.searchPeriod) && Objects.equals(this.timeGreaterThanOrEqualTo, other.timeGreaterThanOrEqualTo) && Objects.equals(this.timeLessThanOrEqualTo, other.timeLessThanOrEqualTo) && Objects.equals(this.beginExecIdGreaterThanOrEqualTo, other.beginExecIdGreaterThanOrEqualTo) && Objects.equals(this.endExecIdLessThanOrEqualTo, other.endExecIdLessThanOrEqualTo) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningAdvisorTaskId == null ? 43 : this.sqlTuningAdvisorTaskId.hashCode());
        result = result * 59 + (this.searchPeriod == null ? 43 : this.searchPeriod.hashCode());
        result = result * 59 + (this.timeGreaterThanOrEqualTo == null ? 43 : this.timeGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLessThanOrEqualTo == null ? 43 : this.timeLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.beginExecIdGreaterThanOrEqualTo == null ? 43 : this.beginExecIdGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.endExecIdLessThanOrEqualTo == null ? 43 : this.endExecIdLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSqlTuningAdvisorTaskSummaryReportRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Long sqlTuningAdvisorTaskId = null;
        private SearchPeriod searchPeriod = null;
        private Date timeGreaterThanOrEqualTo = null;
        private Date timeLessThanOrEqualTo = null;
        private Long beginExecIdGreaterThanOrEqualTo = null;
        private Long endExecIdLessThanOrEqualTo = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningAdvisorTaskId(Long sqlTuningAdvisorTaskId) {
            this.sqlTuningAdvisorTaskId = sqlTuningAdvisorTaskId;
            return this;
        }

        public Builder searchPeriod(SearchPeriod searchPeriod) {
            this.searchPeriod = searchPeriod;
            return this;
        }

        public Builder timeGreaterThanOrEqualTo(Date timeGreaterThanOrEqualTo) {
            this.timeGreaterThanOrEqualTo = timeGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLessThanOrEqualTo(Date timeLessThanOrEqualTo) {
            this.timeLessThanOrEqualTo = timeLessThanOrEqualTo;
            return this;
        }

        public Builder beginExecIdGreaterThanOrEqualTo(Long beginExecIdGreaterThanOrEqualTo) {
            this.beginExecIdGreaterThanOrEqualTo = beginExecIdGreaterThanOrEqualTo;
            return this;
        }

        public Builder endExecIdLessThanOrEqualTo(Long endExecIdLessThanOrEqualTo) {
            this.endExecIdLessThanOrEqualTo = endExecIdLessThanOrEqualTo;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSqlTuningAdvisorTaskSummaryReportRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningAdvisorTaskId(o.getSqlTuningAdvisorTaskId());
            this.searchPeriod(o.getSearchPeriod());
            this.timeGreaterThanOrEqualTo(o.getTimeGreaterThanOrEqualTo());
            this.timeLessThanOrEqualTo(o.getTimeLessThanOrEqualTo());
            this.beginExecIdGreaterThanOrEqualTo(o.getBeginExecIdGreaterThanOrEqualTo());
            this.endExecIdLessThanOrEqualTo(o.getEndExecIdLessThanOrEqualTo());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSqlTuningAdvisorTaskSummaryReportRequest build() {
            GetSqlTuningAdvisorTaskSummaryReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSqlTuningAdvisorTaskSummaryReportRequest buildWithoutInvocationCallback() {
            GetSqlTuningAdvisorTaskSummaryReportRequest request = new GetSqlTuningAdvisorTaskSummaryReportRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningAdvisorTaskId = this.sqlTuningAdvisorTaskId;
            request.searchPeriod = this.searchPeriod;
            request.timeGreaterThanOrEqualTo = this.timeGreaterThanOrEqualTo;
            request.timeLessThanOrEqualTo = this.timeLessThanOrEqualTo;
            request.beginExecIdGreaterThanOrEqualTo = this.beginExecIdGreaterThanOrEqualTo;
            request.endExecIdLessThanOrEqualTo = this.endExecIdLessThanOrEqualTo;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum SearchPeriod implements BmcEnum
    {
        Last24Hr("LAST_24HR"),
        Last7Day("LAST_7DAY"),
        Last31Day("LAST_31DAY"),
        SinceLast("SINCE_LAST"),
        All("ALL");

        private final String value;
        private static Map<String, SearchPeriod> map;

        private SearchPeriod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SearchPeriod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SearchPeriod: " + key);
        }

        static {
            map = new HashMap<String, SearchPeriod>();
            for (SearchPeriod v : SearchPeriod.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

