/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.SaveSqlTuningSetAsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SaveSqlTuningSetAsRequest
extends BmcRequest<SaveSqlTuningSetAsDetails> {
    private String managedDatabaseId;
    private Integer sqlTuningSetId;
    private SaveSqlTuningSetAsDetails saveSqlTuningSetAsDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public Integer getSqlTuningSetId() {
        return this.sqlTuningSetId;
    }

    public SaveSqlTuningSetAsDetails getSaveSqlTuningSetAsDetails() {
        return this.saveSqlTuningSetAsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public SaveSqlTuningSetAsDetails getBody$() {
        return this.saveSqlTuningSetAsDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).sqlTuningSetId(this.sqlTuningSetId).saveSqlTuningSetAsDetails(this.saveSqlTuningSetAsDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",sqlTuningSetId=").append(String.valueOf(this.sqlTuningSetId));
        sb.append(",saveSqlTuningSetAsDetails=").append(String.valueOf((Object)this.saveSqlTuningSetAsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaveSqlTuningSetAsRequest)) {
            return false;
        }
        SaveSqlTuningSetAsRequest other = (SaveSqlTuningSetAsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.sqlTuningSetId, other.sqlTuningSetId) && Objects.equals((Object)this.saveSqlTuningSetAsDetails, (Object)other.saveSqlTuningSetAsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.sqlTuningSetId == null ? 43 : this.sqlTuningSetId.hashCode());
        result = result * 59 + (this.saveSqlTuningSetAsDetails == null ? 43 : this.saveSqlTuningSetAsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SaveSqlTuningSetAsRequest, SaveSqlTuningSetAsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private Integer sqlTuningSetId = null;
        private SaveSqlTuningSetAsDetails saveSqlTuningSetAsDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder sqlTuningSetId(Integer sqlTuningSetId) {
            this.sqlTuningSetId = sqlTuningSetId;
            return this;
        }

        public Builder saveSqlTuningSetAsDetails(SaveSqlTuningSetAsDetails saveSqlTuningSetAsDetails) {
            this.saveSqlTuningSetAsDetails = saveSqlTuningSetAsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SaveSqlTuningSetAsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.sqlTuningSetId(o.getSqlTuningSetId());
            this.saveSqlTuningSetAsDetails(o.getSaveSqlTuningSetAsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SaveSqlTuningSetAsRequest build() {
            SaveSqlTuningSetAsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SaveSqlTuningSetAsDetails body) {
            this.saveSqlTuningSetAsDetails(body);
            return this;
        }

        public SaveSqlTuningSetAsRequest buildWithoutInvocationCallback() {
            SaveSqlTuningSetAsRequest request = new SaveSqlTuningSetAsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.sqlTuningSetId = this.sqlTuningSetId;
            request.saveSqlTuningSetAsDetails = this.saveSqlTuningSetAsDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

