/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemComponentType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociatedComponent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="componentId")
    private final String componentId;
    @JsonProperty(value="componentType")
    private final ExternalDbSystemComponentType componentType;
    @JsonProperty(value="associationType")
    private final AssociationType associationType;

    @Deprecated
    @ConstructorProperties(value={"componentId", "componentType", "associationType"})
    public AssociatedComponent(String componentId, ExternalDbSystemComponentType componentType, AssociationType associationType) {
        this.componentId = componentId;
        this.componentType = componentType;
        this.associationType = associationType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getComponentId() {
        return this.componentId;
    }

    public ExternalDbSystemComponentType getComponentType() {
        return this.componentType;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociatedComponent(");
        sb.append("super=").append(super.toString());
        sb.append("componentId=").append(String.valueOf(this.componentId));
        sb.append(", componentType=").append(String.valueOf((Object)this.componentType));
        sb.append(", associationType=").append(String.valueOf((Object)this.associationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociatedComponent)) {
            return false;
        }
        AssociatedComponent other = (AssociatedComponent)((Object)o);
        return Objects.equals(this.componentId, other.componentId) && Objects.equals((Object)this.componentType, (Object)other.componentType) && Objects.equals((Object)this.associationType, (Object)other.associationType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.componentId == null ? 43 : this.componentId.hashCode());
        result = result * 59 + (this.componentType == null ? 43 : this.componentType.hashCode());
        result = result * 59 + (this.associationType == null ? 43 : this.associationType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AssociationType implements BmcEnum
    {
        Contains("CONTAINS"),
        Uses("USES"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AssociationType> map;

        private AssociationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssociationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AssociationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AssociationType.class);
            map = new HashMap<String, AssociationType>();
            for (AssociationType v : AssociationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="componentType")
        private ExternalDbSystemComponentType componentType;
        @JsonProperty(value="associationType")
        private AssociationType associationType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder componentType(ExternalDbSystemComponentType componentType) {
            this.componentType = componentType;
            this.__explicitlySet__.add("componentType");
            return this;
        }

        public Builder associationType(AssociationType associationType) {
            this.associationType = associationType;
            this.__explicitlySet__.add("associationType");
            return this;
        }

        public AssociatedComponent build() {
            AssociatedComponent model = new AssociatedComponent(this.componentId, this.componentType, this.associationType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociatedComponent model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("componentType")) {
                this.componentType(model.getComponentType());
            }
            if (model.wasPropertyExplicitlySet("associationType")) {
                this.associationType(model.getAssociationType());
            }
            return this;
        }
    }
}

