/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AttentionLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="messageUrgency")
    private final MessageUrgency messageUrgency;
    @JsonProperty(value="messageType")
    private final MessageType messageType;
    @JsonProperty(value="messageContent")
    private final String messageContent;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="scope")
    private final String scope;
    @JsonProperty(value="targetUser")
    private final String targetUser;
    @JsonProperty(value="cause")
    private final String cause;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="supplementalDetail")
    private final String supplementalDetail;
    @JsonProperty(value="fileLocation")
    private final String fileLocation;

    @Deprecated
    @ConstructorProperties(value={"messageUrgency", "messageType", "messageContent", "timestamp", "scope", "targetUser", "cause", "action", "supplementalDetail", "fileLocation"})
    public AttentionLogSummary(MessageUrgency messageUrgency, MessageType messageType, String messageContent, Date timestamp, String scope, String targetUser, String cause, String action, String supplementalDetail, String fileLocation) {
        this.messageUrgency = messageUrgency;
        this.messageType = messageType;
        this.messageContent = messageContent;
        this.timestamp = timestamp;
        this.scope = scope;
        this.targetUser = targetUser;
        this.cause = cause;
        this.action = action;
        this.supplementalDetail = supplementalDetail;
        this.fileLocation = fileLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MessageUrgency getMessageUrgency() {
        return this.messageUrgency;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTargetUser() {
        return this.targetUser;
    }

    public String getCause() {
        return this.cause;
    }

    public String getAction() {
        return this.action;
    }

    public String getSupplementalDetail() {
        return this.supplementalDetail;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttentionLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("messageUrgency=").append(String.valueOf((Object)this.messageUrgency));
        sb.append(", messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(", messageContent=").append(String.valueOf(this.messageContent));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", scope=").append(String.valueOf(this.scope));
        sb.append(", targetUser=").append(String.valueOf(this.targetUser));
        sb.append(", cause=").append(String.valueOf(this.cause));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", supplementalDetail=").append(String.valueOf(this.supplementalDetail));
        sb.append(", fileLocation=").append(String.valueOf(this.fileLocation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttentionLogSummary)) {
            return false;
        }
        AttentionLogSummary other = (AttentionLogSummary)((Object)o);
        return Objects.equals((Object)this.messageUrgency, (Object)other.messageUrgency) && Objects.equals((Object)this.messageType, (Object)other.messageType) && Objects.equals(this.messageContent, other.messageContent) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.scope, other.scope) && Objects.equals(this.targetUser, other.targetUser) && Objects.equals(this.cause, other.cause) && Objects.equals(this.action, other.action) && Objects.equals(this.supplementalDetail, other.supplementalDetail) && Objects.equals(this.fileLocation, other.fileLocation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.messageUrgency == null ? 43 : this.messageUrgency.hashCode());
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        result = result * 59 + (this.messageContent == null ? 43 : this.messageContent.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.targetUser == null ? 43 : this.targetUser.hashCode());
        result = result * 59 + (this.cause == null ? 43 : this.cause.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.supplementalDetail == null ? 43 : this.supplementalDetail.hashCode());
        result = result * 59 + (this.fileLocation == null ? 43 : this.fileLocation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MessageType implements BmcEnum
    {
        Unknown("UNKNOWN"),
        IncidentError("INCIDENT_ERROR"),
        Error("ERROR"),
        Warning("WARNING"),
        Notification("NOTIFICATION"),
        Trace("TRACE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageType.class);
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MessageUrgency implements BmcEnum
    {
        Immediate("IMMEDIATE"),
        Soon("SOON"),
        Deferrable("DEFERRABLE"),
        Info("INFO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageUrgency> map;

        private MessageUrgency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageUrgency create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageUrgency', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageUrgency.class);
            map = new HashMap<String, MessageUrgency>();
            for (MessageUrgency v : MessageUrgency.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messageUrgency")
        private MessageUrgency messageUrgency;
        @JsonProperty(value="messageType")
        private MessageType messageType;
        @JsonProperty(value="messageContent")
        private String messageContent;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="scope")
        private String scope;
        @JsonProperty(value="targetUser")
        private String targetUser;
        @JsonProperty(value="cause")
        private String cause;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="supplementalDetail")
        private String supplementalDetail;
        @JsonProperty(value="fileLocation")
        private String fileLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messageUrgency(MessageUrgency messageUrgency) {
            this.messageUrgency = messageUrgency;
            this.__explicitlySet__.add("messageUrgency");
            return this;
        }

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            this.__explicitlySet__.add("messageType");
            return this;
        }

        public Builder messageContent(String messageContent) {
            this.messageContent = messageContent;
            this.__explicitlySet__.add("messageContent");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder targetUser(String targetUser) {
            this.targetUser = targetUser;
            this.__explicitlySet__.add("targetUser");
            return this;
        }

        public Builder cause(String cause) {
            this.cause = cause;
            this.__explicitlySet__.add("cause");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder supplementalDetail(String supplementalDetail) {
            this.supplementalDetail = supplementalDetail;
            this.__explicitlySet__.add("supplementalDetail");
            return this;
        }

        public Builder fileLocation(String fileLocation) {
            this.fileLocation = fileLocation;
            this.__explicitlySet__.add("fileLocation");
            return this;
        }

        public AttentionLogSummary build() {
            AttentionLogSummary model = new AttentionLogSummary(this.messageUrgency, this.messageType, this.messageContent, this.timestamp, this.scope, this.targetUser, this.cause, this.action, this.supplementalDetail, this.fileLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttentionLogSummary model) {
            if (model.wasPropertyExplicitlySet("messageUrgency")) {
                this.messageUrgency(model.getMessageUrgency());
            }
            if (model.wasPropertyExplicitlySet("messageType")) {
                this.messageType(model.getMessageType());
            }
            if (model.wasPropertyExplicitlySet("messageContent")) {
                this.messageContent(model.getMessageContent());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("targetUser")) {
                this.targetUser(model.getTargetUser());
            }
            if (model.wasPropertyExplicitlySet("cause")) {
                this.cause(model.getCause());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("supplementalDetail")) {
                this.supplementalDetail(model.getSupplementalDetail());
            }
            if (model.wasPropertyExplicitlySet("fileLocation")) {
                this.fileLocation(model.getFileLocation());
            }
            return this;
        }
    }
}

