/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedServiceDetails;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDatabaseManagementConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExternalDbSystemDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbSystemDiscoveryId")
    private final String dbSystemDiscoveryId;
    @JsonProperty(value="databaseManagementConfig")
    private final ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;
    @JsonProperty(value="stackMonitoringConfig")
    private final AssociatedServiceDetails stackMonitoringConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "dbSystemDiscoveryId", "databaseManagementConfig", "stackMonitoringConfig", "freeformTags", "definedTags"})
    public CreateExternalDbSystemDetails(String displayName, String compartmentId, String dbSystemDiscoveryId, ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig, AssociatedServiceDetails stackMonitoringConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.dbSystemDiscoveryId = dbSystemDiscoveryId;
        this.databaseManagementConfig = databaseManagementConfig;
        this.stackMonitoringConfig = stackMonitoringConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbSystemDiscoveryId() {
        return this.dbSystemDiscoveryId;
    }

    public ExternalDbSystemDatabaseManagementConfigDetails getDatabaseManagementConfig() {
        return this.databaseManagementConfig;
    }

    public AssociatedServiceDetails getStackMonitoringConfig() {
        return this.stackMonitoringConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExternalDbSystemDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbSystemDiscoveryId=").append(String.valueOf(this.dbSystemDiscoveryId));
        sb.append(", databaseManagementConfig=").append(String.valueOf((Object)this.databaseManagementConfig));
        sb.append(", stackMonitoringConfig=").append(String.valueOf((Object)this.stackMonitoringConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExternalDbSystemDetails)) {
            return false;
        }
        CreateExternalDbSystemDetails other = (CreateExternalDbSystemDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbSystemDiscoveryId, other.dbSystemDiscoveryId) && Objects.equals((Object)this.databaseManagementConfig, (Object)other.databaseManagementConfig) && Objects.equals((Object)this.stackMonitoringConfig, (Object)other.stackMonitoringConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbSystemDiscoveryId == null ? 43 : this.dbSystemDiscoveryId.hashCode());
        result = result * 59 + (this.databaseManagementConfig == null ? 43 : this.databaseManagementConfig.hashCode());
        result = result * 59 + (this.stackMonitoringConfig == null ? 43 : this.stackMonitoringConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbSystemDiscoveryId")
        private String dbSystemDiscoveryId;
        @JsonProperty(value="databaseManagementConfig")
        private ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig;
        @JsonProperty(value="stackMonitoringConfig")
        private AssociatedServiceDetails stackMonitoringConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbSystemDiscoveryId(String dbSystemDiscoveryId) {
            this.dbSystemDiscoveryId = dbSystemDiscoveryId;
            this.__explicitlySet__.add("dbSystemDiscoveryId");
            return this;
        }

        public Builder databaseManagementConfig(ExternalDbSystemDatabaseManagementConfigDetails databaseManagementConfig) {
            this.databaseManagementConfig = databaseManagementConfig;
            this.__explicitlySet__.add("databaseManagementConfig");
            return this;
        }

        public Builder stackMonitoringConfig(AssociatedServiceDetails stackMonitoringConfig) {
            this.stackMonitoringConfig = stackMonitoringConfig;
            this.__explicitlySet__.add("stackMonitoringConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateExternalDbSystemDetails build() {
            CreateExternalDbSystemDetails model = new CreateExternalDbSystemDetails(this.displayName, this.compartmentId, this.dbSystemDiscoveryId, this.databaseManagementConfig, this.stackMonitoringConfig, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExternalDbSystemDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemDiscoveryId")) {
                this.dbSystemDiscoveryId(model.getDbSystemDiscoveryId());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConfig")) {
                this.databaseManagementConfig(model.getDatabaseManagementConfig());
            }
            if (model.wasPropertyExplicitlySet("stackMonitoringConfig")) {
                this.stackMonitoringConfig(model.getStackMonitoringConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

