/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbManagementAnalyticsMetric
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="durationInSeconds")
    private final Long durationInSeconds;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;
    @JsonProperty(value="dimensions")
    private final Map<String, String> dimensions;
    @JsonProperty(value="startTimestampInEpochSeconds")
    private final Long startTimestampInEpochSeconds;
    @JsonProperty(value="mean")
    private final Double mean;

    @Deprecated
    @ConstructorProperties(value={"metricName", "durationInSeconds", "metadata", "dimensions", "startTimestampInEpochSeconds", "mean"})
    public DbManagementAnalyticsMetric(String metricName, Long durationInSeconds, Map<String, String> metadata, Map<String, String> dimensions, Long startTimestampInEpochSeconds, Double mean) {
        this.metricName = metricName;
        this.durationInSeconds = durationInSeconds;
        this.metadata = metadata;
        this.dimensions = dimensions;
        this.startTimestampInEpochSeconds = startTimestampInEpochSeconds;
        this.mean = mean;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Long getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Long getStartTimestampInEpochSeconds() {
        return this.startTimestampInEpochSeconds;
    }

    public Double getMean() {
        return this.mean;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbManagementAnalyticsMetric(");
        sb.append("super=").append(super.toString());
        sb.append("metricName=").append(String.valueOf(this.metricName));
        sb.append(", durationInSeconds=").append(String.valueOf(this.durationInSeconds));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", startTimestampInEpochSeconds=").append(String.valueOf(this.startTimestampInEpochSeconds));
        sb.append(", mean=").append(String.valueOf(this.mean));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbManagementAnalyticsMetric)) {
            return false;
        }
        DbManagementAnalyticsMetric other = (DbManagementAnalyticsMetric)((Object)o);
        return Objects.equals(this.metricName, other.metricName) && Objects.equals(this.durationInSeconds, other.durationInSeconds) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.startTimestampInEpochSeconds, other.startTimestampInEpochSeconds) && Objects.equals(this.mean, other.mean) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.durationInSeconds == null ? 43 : this.durationInSeconds.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.startTimestampInEpochSeconds == null ? 43 : this.startTimestampInEpochSeconds.hashCode());
        result = result * 59 + (this.mean == null ? 43 : this.mean.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="durationInSeconds")
        private Long durationInSeconds;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonProperty(value="dimensions")
        private Map<String, String> dimensions;
        @JsonProperty(value="startTimestampInEpochSeconds")
        private Long startTimestampInEpochSeconds;
        @JsonProperty(value="mean")
        private Double mean;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.__explicitlySet__.add("durationInSeconds");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder startTimestampInEpochSeconds(Long startTimestampInEpochSeconds) {
            this.startTimestampInEpochSeconds = startTimestampInEpochSeconds;
            this.__explicitlySet__.add("startTimestampInEpochSeconds");
            return this;
        }

        public Builder mean(Double mean) {
            this.mean = mean;
            this.__explicitlySet__.add("mean");
            return this;
        }

        public DbManagementAnalyticsMetric build() {
            DbManagementAnalyticsMetric model = new DbManagementAnalyticsMetric(this.metricName, this.durationInSeconds, this.metadata, this.dimensions, this.startTimestampInEpochSeconds, this.mean);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbManagementAnalyticsMetric model) {
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("durationInSeconds")) {
                this.durationInSeconds(model.getDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("startTimestampInEpochSeconds")) {
                this.startTimestampInEpochSeconds(model.getStartTimestampInEpochSeconds());
            }
            if (model.wasPropertyExplicitlySet("mean")) {
                this.mean(model.getMean());
            }
            return this;
        }
    }
}

