/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.ExternalExadataDatabaseSystemSummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructure;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructureSummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageConnector;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageConnectorSummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageGrid;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageGridSummary;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageServer;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageServerSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceType", defaultImpl=DbmResource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ExternalExadataStorageConnector.class, name="STORAGE_CONNECTOR"), @JsonSubTypes.Type(value=ExternalExadataStorageGridSummary.class, name="STORAGE_GRID_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataStorageServer.class, name="STORAGE_SERVER"), @JsonSubTypes.Type(value=ExternalExadataInfrastructure.class, name="INFRASTRUCTURE"), @JsonSubTypes.Type(value=ExternalExadataStorageGrid.class, name="STORAGE_GRID"), @JsonSubTypes.Type(value=ExternalExadataInfrastructureSummary.class, name="INFRASTRUCTURE_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataDatabaseSystemSummary.class, name="DATABASE_SYSTEM_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataStorageConnectorSummary.class, name="STORAGE_CONNECTOR_SUMMARY"), @JsonSubTypes.Type(value=ExternalExadataStorageServerSummary.class, name="STORAGE_SERVER_SUMMARY")})
@JsonFilter(value="explicitlySetFilter")
public class DbmResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="internalId")
    private final String internalId;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="additionalDetails")
    private final Map<String, String> additionalDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "version", "internalId", "status", "lifecycleState", "timeCreated", "timeUpdated", "lifecycleDetails", "additionalDetails"})
    protected DbmResource(String id, String displayName, String version, String internalId, String status, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, String lifecycleDetails, Map<String, String> additionalDetails) {
        this.id = id;
        this.displayName = displayName;
        this.version = version;
        this.internalId = internalId;
        this.status = status;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleDetails = lifecycleDetails;
        this.additionalDetails = additionalDetails;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getStatus() {
        return this.status;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbmResource(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", internalId=").append(String.valueOf(this.internalId));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", additionalDetails=").append(String.valueOf(this.additionalDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbmResource)) {
            return false;
        }
        DbmResource other = (DbmResource)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.version, other.version) && Objects.equals(this.internalId, other.internalId) && Objects.equals(this.status, other.status) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.additionalDetails, other.additionalDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.internalId == null ? 43 : this.internalId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.additionalDetails == null ? 43 : this.additionalDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceType implements BmcEnum
    {
        InfrastructureSummary("INFRASTRUCTURE_SUMMARY"),
        Infrastructure("INFRASTRUCTURE"),
        StorageServerSummary("STORAGE_SERVER_SUMMARY"),
        StorageServer("STORAGE_SERVER"),
        StorageGridSummary("STORAGE_GRID_SUMMARY"),
        StorageGrid("STORAGE_GRID"),
        StorageConnectorSummary("STORAGE_CONNECTOR_SUMMARY"),
        StorageConnector("STORAGE_CONNECTOR"),
        DatabaseSystemSummary("DATABASE_SYSTEM_SUMMARY"),
        DatabaseSummary("DATABASE_SUMMARY");

        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ResourceType: " + key);
        }

        static {
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

