/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiscoverExternalExadataInfrastructureDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="discoveryType")
    private final DiscoveryType discoveryType;
    @JsonProperty(value="dbSystemIds")
    private final List<String> dbSystemIds;
    @JsonProperty(value="exadataInfrastructureId")
    private final String exadataInfrastructureId;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "discoveryType", "dbSystemIds", "exadataInfrastructureId"})
    public DiscoverExternalExadataInfrastructureDetails(String compartmentId, DiscoveryType discoveryType, List<String> dbSystemIds, String exadataInfrastructureId) {
        this.compartmentId = compartmentId;
        this.discoveryType = discoveryType;
        this.dbSystemIds = dbSystemIds;
        this.exadataInfrastructureId = exadataInfrastructureId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public List<String> getDbSystemIds() {
        return this.dbSystemIds;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoverExternalExadataInfrastructureDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", discoveryType=").append(String.valueOf((Object)this.discoveryType));
        sb.append(", dbSystemIds=").append(String.valueOf(this.dbSystemIds));
        sb.append(", exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoverExternalExadataInfrastructureDetails)) {
            return false;
        }
        DiscoverExternalExadataInfrastructureDetails other = (DiscoverExternalExadataInfrastructureDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.discoveryType, (Object)other.discoveryType) && Objects.equals(this.dbSystemIds, other.dbSystemIds) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result = result * 59 + (this.dbSystemIds == null ? 43 : this.dbSystemIds.hashCode());
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DiscoveryType implements BmcEnum
    {
        New("NEW"),
        Override("OVERRIDE");

        private final String value;
        private static Map<String, DiscoveryType> map;

        private DiscoveryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiscoveryType: " + key);
        }

        static {
            map = new HashMap<String, DiscoveryType>();
            for (DiscoveryType v : DiscoveryType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="discoveryType")
        private DiscoveryType discoveryType;
        @JsonProperty(value="dbSystemIds")
        private List<String> dbSystemIds;
        @JsonProperty(value="exadataInfrastructureId")
        private String exadataInfrastructureId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            this.__explicitlySet__.add("discoveryType");
            return this;
        }

        public Builder dbSystemIds(List<String> dbSystemIds) {
            this.dbSystemIds = dbSystemIds;
            this.__explicitlySet__.add("dbSystemIds");
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            this.__explicitlySet__.add("exadataInfrastructureId");
            return this;
        }

        public DiscoverExternalExadataInfrastructureDetails build() {
            DiscoverExternalExadataInfrastructureDetails model = new DiscoverExternalExadataInfrastructureDetails(this.compartmentId, this.discoveryType, this.dbSystemIds, this.exadataInfrastructureId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoverExternalExadataInfrastructureDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("discoveryType")) {
                this.discoveryType(model.getDiscoveryType());
            }
            if (model.wasPropertyExplicitlySet("dbSystemIds")) {
                this.dbSystemIds(model.getDbSystemIds());
            }
            if (model.wasPropertyExplicitlySet("exadataInfrastructureId")) {
                this.exadataInfrastructureId(model.getExadataInfrastructureId());
            }
            return this;
        }
    }
}

