/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AsmConnectionCredentials;
import com.oracle.bmc.databasemanagement.model.AsmConnectionString;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectionInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalAsmConnectionInfo
extends ExternalDbSystemConnectionInfo {
    @JsonProperty(value="connectionString")
    private final AsmConnectionString connectionString;
    @JsonProperty(value="connectionCredentials")
    private final AsmConnectionCredentials connectionCredentials;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalAsmConnectionInfo(AsmConnectionString connectionString, AsmConnectionCredentials connectionCredentials) {
        this.connectionString = connectionString;
        this.connectionCredentials = connectionCredentials;
    }

    public AsmConnectionString getConnectionString() {
        return this.connectionString;
    }

    public AsmConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalAsmConnectionInfo(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionString=").append(String.valueOf((Object)this.connectionString));
        sb.append(", connectionCredentials=").append(String.valueOf((Object)this.connectionCredentials));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalAsmConnectionInfo)) {
            return false;
        }
        ExternalAsmConnectionInfo other = (ExternalAsmConnectionInfo)((Object)o);
        return Objects.equals((Object)this.connectionString, (Object)other.connectionString) && Objects.equals((Object)this.connectionCredentials, (Object)other.connectionCredentials) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.connectionCredentials == null ? 43 : this.connectionCredentials.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionString")
        private AsmConnectionString connectionString;
        @JsonProperty(value="connectionCredentials")
        private AsmConnectionCredentials connectionCredentials;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionString(AsmConnectionString connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder connectionCredentials(AsmConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            this.__explicitlySet__.add("connectionCredentials");
            return this;
        }

        public ExternalAsmConnectionInfo build() {
            ExternalAsmConnectionInfo model = new ExternalAsmConnectionInfo(this.connectionString, this.connectionCredentials);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalAsmConnectionInfo model) {
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentials")) {
                this.connectionCredentials(model.getConnectionCredentials());
            }
            return this;
        }
    }
}

