/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionCredentials;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionString;
import com.oracle.bmc.databasemanagement.model.DatabaseCredentialDetails;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectionInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDatabaseConnectionInfo
extends ExternalDbSystemConnectionInfo {
    @JsonProperty(value="connectionString")
    private final DatabaseConnectionString connectionString;
    @JsonProperty(value="connectionCredentials")
    private final DatabaseConnectionCredentials connectionCredentials;
    @JsonProperty(value="databaseCredential")
    private final DatabaseCredentialDetails databaseCredential;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalDatabaseConnectionInfo(DatabaseConnectionString connectionString, DatabaseConnectionCredentials connectionCredentials, DatabaseCredentialDetails databaseCredential) {
        this.connectionString = connectionString;
        this.connectionCredentials = connectionCredentials;
        this.databaseCredential = databaseCredential;
    }

    public DatabaseConnectionString getConnectionString() {
        return this.connectionString;
    }

    public DatabaseConnectionCredentials getConnectionCredentials() {
        return this.connectionCredentials;
    }

    public DatabaseCredentialDetails getDatabaseCredential() {
        return this.databaseCredential;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDatabaseConnectionInfo(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionString=").append(String.valueOf((Object)this.connectionString));
        sb.append(", connectionCredentials=").append(String.valueOf((Object)this.connectionCredentials));
        sb.append(", databaseCredential=").append(String.valueOf((Object)this.databaseCredential));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDatabaseConnectionInfo)) {
            return false;
        }
        ExternalDatabaseConnectionInfo other = (ExternalDatabaseConnectionInfo)((Object)o);
        return Objects.equals((Object)this.connectionString, (Object)other.connectionString) && Objects.equals((Object)this.connectionCredentials, (Object)other.connectionCredentials) && Objects.equals((Object)this.databaseCredential, (Object)other.databaseCredential) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionString == null ? 43 : this.connectionString.hashCode());
        result = result * 59 + (this.connectionCredentials == null ? 43 : this.connectionCredentials.hashCode());
        result = result * 59 + (this.databaseCredential == null ? 43 : this.databaseCredential.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionString")
        private DatabaseConnectionString connectionString;
        @JsonProperty(value="connectionCredentials")
        private DatabaseConnectionCredentials connectionCredentials;
        @JsonProperty(value="databaseCredential")
        private DatabaseCredentialDetails databaseCredential;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionString(DatabaseConnectionString connectionString) {
            this.connectionString = connectionString;
            this.__explicitlySet__.add("connectionString");
            return this;
        }

        public Builder connectionCredentials(DatabaseConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            this.__explicitlySet__.add("connectionCredentials");
            return this;
        }

        public Builder databaseCredential(DatabaseCredentialDetails databaseCredential) {
            this.databaseCredential = databaseCredential;
            this.__explicitlySet__.add("databaseCredential");
            return this;
        }

        public ExternalDatabaseConnectionInfo build() {
            ExternalDatabaseConnectionInfo model = new ExternalDatabaseConnectionInfo(this.connectionString, this.connectionCredentials, this.databaseCredential);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDatabaseConnectionInfo model) {
            if (model.wasPropertyExplicitlySet("connectionString")) {
                this.connectionString(model.getConnectionString());
            }
            if (model.wasPropertyExplicitlySet("connectionCredentials")) {
                this.connectionCredentials(model.getConnectionCredentials());
            }
            if (model.wasPropertyExplicitlySet("databaseCredential")) {
                this.databaseCredential(model.getDatabaseCredential());
            }
            return this;
        }
    }
}

