/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalDatabaseInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="instanceNumber")
    private final Integer instanceNumber;
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="hostName")
    private final String hostName;

    @Deprecated
    @ConstructorProperties(value={"instanceNumber", "instanceName", "hostName"})
    public ExternalDatabaseInstance(Integer instanceNumber, String instanceName, String hostName) {
        this.instanceNumber = instanceNumber;
        this.instanceName = instanceName;
        this.hostName = hostName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalDatabaseInstance(");
        sb.append("super=").append(super.toString());
        sb.append("instanceNumber=").append(String.valueOf(this.instanceNumber));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalDatabaseInstance)) {
            return false;
        }
        ExternalDatabaseInstance other = (ExternalDatabaseInstance)((Object)o);
        return Objects.equals(this.instanceNumber, other.instanceNumber) && Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.hostName, other.hostName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.instanceNumber == null ? 43 : this.instanceNumber.hashCode());
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="instanceNumber")
        private Integer instanceNumber;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder instanceNumber(Integer instanceNumber) {
            this.instanceNumber = instanceNumber;
            this.__explicitlySet__.add("instanceNumber");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public ExternalDatabaseInstance build() {
            ExternalDatabaseInstance model = new ExternalDatabaseInstance(this.instanceNumber, this.instanceName, this.hostName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalDatabaseInstance model) {
            if (model.wasPropertyExplicitlySet("instanceNumber")) {
                this.instanceNumber(model.getInstanceNumber());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            return this;
        }
    }
}

