/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.HeatWaveClusterStatus;
import com.oracle.bmc.databasemanagement.model.HeatWaveFleetMetricDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HeatWaveClusterUsageMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final HeatWaveClusterStatus status;
    @JsonProperty(value="dbSystemId")
    private final String dbSystemId;
    @JsonProperty(value="dbSystemName")
    private final String dbSystemName;
    @JsonProperty(value="heatWaveClusterDisplayName")
    private final String heatWaveClusterDisplayName;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="isLakehouseEnabled")
    private final Boolean isLakehouseEnabled;
    @JsonProperty(value="heatWaveNodeShape")
    private final String heatWaveNodeShape;
    @JsonProperty(value="memorySize")
    private final Integer memorySize;
    @JsonProperty(value="metrics")
    private final List<HeatWaveFleetMetricDefinition> metrics;

    @Deprecated
    @ConstructorProperties(value={"status", "dbSystemId", "dbSystemName", "heatWaveClusterDisplayName", "nodeCount", "isLakehouseEnabled", "heatWaveNodeShape", "memorySize", "metrics"})
    public HeatWaveClusterUsageMetrics(HeatWaveClusterStatus status, String dbSystemId, String dbSystemName, String heatWaveClusterDisplayName, Integer nodeCount, Boolean isLakehouseEnabled, String heatWaveNodeShape, Integer memorySize, List<HeatWaveFleetMetricDefinition> metrics) {
        this.status = status;
        this.dbSystemId = dbSystemId;
        this.dbSystemName = dbSystemName;
        this.heatWaveClusterDisplayName = heatWaveClusterDisplayName;
        this.nodeCount = nodeCount;
        this.isLakehouseEnabled = isLakehouseEnabled;
        this.heatWaveNodeShape = heatWaveNodeShape;
        this.memorySize = memorySize;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public HeatWaveClusterStatus getStatus() {
        return this.status;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getDbSystemName() {
        return this.dbSystemName;
    }

    public String getHeatWaveClusterDisplayName() {
        return this.heatWaveClusterDisplayName;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Boolean getIsLakehouseEnabled() {
        return this.isLakehouseEnabled;
    }

    public String getHeatWaveNodeShape() {
        return this.heatWaveNodeShape;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public List<HeatWaveFleetMetricDefinition> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HeatWaveClusterUsageMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(", dbSystemName=").append(String.valueOf(this.dbSystemName));
        sb.append(", heatWaveClusterDisplayName=").append(String.valueOf(this.heatWaveClusterDisplayName));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", isLakehouseEnabled=").append(String.valueOf(this.isLakehouseEnabled));
        sb.append(", heatWaveNodeShape=").append(String.valueOf(this.heatWaveNodeShape));
        sb.append(", memorySize=").append(String.valueOf(this.memorySize));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeatWaveClusterUsageMetrics)) {
            return false;
        }
        HeatWaveClusterUsageMetrics other = (HeatWaveClusterUsageMetrics)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.dbSystemName, other.dbSystemName) && Objects.equals(this.heatWaveClusterDisplayName, other.heatWaveClusterDisplayName) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.isLakehouseEnabled, other.isLakehouseEnabled) && Objects.equals(this.heatWaveNodeShape, other.heatWaveNodeShape) && Objects.equals(this.memorySize, other.memorySize) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.dbSystemName == null ? 43 : this.dbSystemName.hashCode());
        result = result * 59 + (this.heatWaveClusterDisplayName == null ? 43 : this.heatWaveClusterDisplayName.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.isLakehouseEnabled == null ? 43 : this.isLakehouseEnabled.hashCode());
        result = result * 59 + (this.heatWaveNodeShape == null ? 43 : this.heatWaveNodeShape.hashCode());
        result = result * 59 + (this.memorySize == null ? 43 : this.memorySize.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private HeatWaveClusterStatus status;
        @JsonProperty(value="dbSystemId")
        private String dbSystemId;
        @JsonProperty(value="dbSystemName")
        private String dbSystemName;
        @JsonProperty(value="heatWaveClusterDisplayName")
        private String heatWaveClusterDisplayName;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="isLakehouseEnabled")
        private Boolean isLakehouseEnabled;
        @JsonProperty(value="heatWaveNodeShape")
        private String heatWaveNodeShape;
        @JsonProperty(value="memorySize")
        private Integer memorySize;
        @JsonProperty(value="metrics")
        private List<HeatWaveFleetMetricDefinition> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(HeatWaveClusterStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            this.__explicitlySet__.add("dbSystemId");
            return this;
        }

        public Builder dbSystemName(String dbSystemName) {
            this.dbSystemName = dbSystemName;
            this.__explicitlySet__.add("dbSystemName");
            return this;
        }

        public Builder heatWaveClusterDisplayName(String heatWaveClusterDisplayName) {
            this.heatWaveClusterDisplayName = heatWaveClusterDisplayName;
            this.__explicitlySet__.add("heatWaveClusterDisplayName");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder isLakehouseEnabled(Boolean isLakehouseEnabled) {
            this.isLakehouseEnabled = isLakehouseEnabled;
            this.__explicitlySet__.add("isLakehouseEnabled");
            return this;
        }

        public Builder heatWaveNodeShape(String heatWaveNodeShape) {
            this.heatWaveNodeShape = heatWaveNodeShape;
            this.__explicitlySet__.add("heatWaveNodeShape");
            return this;
        }

        public Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            this.__explicitlySet__.add("memorySize");
            return this;
        }

        public Builder metrics(List<HeatWaveFleetMetricDefinition> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public HeatWaveClusterUsageMetrics build() {
            HeatWaveClusterUsageMetrics model = new HeatWaveClusterUsageMetrics(this.status, this.dbSystemId, this.dbSystemName, this.heatWaveClusterDisplayName, this.nodeCount, this.isLakehouseEnabled, this.heatWaveNodeShape, this.memorySize, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HeatWaveClusterUsageMetrics model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("dbSystemId")) {
                this.dbSystemId(model.getDbSystemId());
            }
            if (model.wasPropertyExplicitlySet("dbSystemName")) {
                this.dbSystemName(model.getDbSystemName());
            }
            if (model.wasPropertyExplicitlySet("heatWaveClusterDisplayName")) {
                this.heatWaveClusterDisplayName(model.getHeatWaveClusterDisplayName());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("isLakehouseEnabled")) {
                this.isLakehouseEnabled(model.getIsLakehouseEnabled());
            }
            if (model.wasPropertyExplicitlySet("heatWaveNodeShape")) {
                this.heatWaveNodeShape(model.getHeatWaveNodeShape());
            }
            if (model.wasPropertyExplicitlySet("memorySize")) {
                this.memorySize(model.getMemorySize());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

