/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseSubType;
import com.oracle.bmc.databasemanagement.model.DatabaseType;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.JobExecutionResultDetails;
import com.oracle.bmc.databasemanagement.model.JobInBindsDetails;
import com.oracle.bmc.databasemanagement.model.JobOutBindsDetails;
import com.oracle.bmc.databasemanagement.model.JobScheduleDetails;
import com.oracle.bmc.databasemanagement.model.WorkloadType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobExecution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="managedDatabaseGroupId")
    private final String managedDatabaseGroupId;
    @JsonProperty(value="managedDatabaseId")
    private final String managedDatabaseId;
    @JsonProperty(value="managedDatabaseName")
    private final String managedDatabaseName;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="databaseSubType")
    private final DatabaseSubType databaseSubType;
    @JsonProperty(value="deploymentType")
    private final DeploymentType deploymentType;
    @JsonProperty(value="isCluster")
    private final Boolean isCluster;
    @JsonProperty(value="workloadType")
    private final WorkloadType workloadType;
    @JsonProperty(value="jobId")
    private final String jobId;
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="jobRunId")
    private final String jobRunId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="resultDetails")
    private final JobExecutionResultDetails resultDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeCompleted")
    private final Date timeCompleted;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="inBinds")
    private final JobInBindsDetails inBinds;
    @JsonProperty(value="outBinds")
    private final JobOutBindsDetails outBinds;
    @JsonProperty(value="scheduleDetails")
    private final JobScheduleDetails scheduleDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "compartmentId", "managedDatabaseGroupId", "managedDatabaseId", "managedDatabaseName", "databaseType", "databaseSubType", "deploymentType", "isCluster", "workloadType", "jobId", "jobName", "jobRunId", "status", "errorMessage", "resultDetails", "timeCreated", "timeCompleted", "userName", "sqlText", "inBinds", "outBinds", "scheduleDetails"})
    public JobExecution(String id, String name, String compartmentId, String managedDatabaseGroupId, String managedDatabaseId, String managedDatabaseName, DatabaseType databaseType, DatabaseSubType databaseSubType, DeploymentType deploymentType, Boolean isCluster, WorkloadType workloadType, String jobId, String jobName, String jobRunId, Status status, String errorMessage, JobExecutionResultDetails resultDetails, Date timeCreated, Date timeCompleted, String userName, String sqlText, JobInBindsDetails inBinds, JobOutBindsDetails outBinds, JobScheduleDetails scheduleDetails) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.managedDatabaseId = managedDatabaseId;
        this.managedDatabaseName = managedDatabaseName;
        this.databaseType = databaseType;
        this.databaseSubType = databaseSubType;
        this.deploymentType = deploymentType;
        this.isCluster = isCluster;
        this.workloadType = workloadType;
        this.jobId = jobId;
        this.jobName = jobName;
        this.jobRunId = jobRunId;
        this.status = status;
        this.errorMessage = errorMessage;
        this.resultDetails = resultDetails;
        this.timeCreated = timeCreated;
        this.timeCompleted = timeCompleted;
        this.userName = userName;
        this.sqlText = sqlText;
        this.inBinds = inBinds;
        this.outBinds = outBinds;
        this.scheduleDetails = scheduleDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getManagedDatabaseName() {
        return this.managedDatabaseName;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public DatabaseSubType getDatabaseSubType() {
        return this.databaseSubType;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public WorkloadType getWorkloadType() {
        return this.workloadType;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobRunId() {
        return this.jobRunId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public JobExecutionResultDetails getResultDetails() {
        return this.resultDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public JobInBindsDetails getInBinds() {
        return this.inBinds;
    }

    public JobOutBindsDetails getOutBinds() {
        return this.outBinds;
    }

    public JobScheduleDetails getScheduleDetails() {
        return this.scheduleDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobExecution(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(", managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(", managedDatabaseName=").append(String.valueOf(this.managedDatabaseName));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", databaseSubType=").append(String.valueOf((Object)this.databaseSubType));
        sb.append(", deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(", isCluster=").append(String.valueOf(this.isCluster));
        sb.append(", workloadType=").append(String.valueOf((Object)this.workloadType));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(", jobName=").append(String.valueOf(this.jobName));
        sb.append(", jobRunId=").append(String.valueOf(this.jobRunId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", resultDetails=").append(String.valueOf((Object)this.resultDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeCompleted=").append(String.valueOf(this.timeCompleted));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", inBinds=").append(String.valueOf((Object)this.inBinds));
        sb.append(", outBinds=").append(String.valueOf((Object)this.outBinds));
        sb.append(", scheduleDetails=").append(String.valueOf((Object)this.scheduleDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobExecution)) {
            return false;
        }
        JobExecution other = (JobExecution)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.managedDatabaseName, other.managedDatabaseName) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.databaseSubType, (Object)other.databaseSubType) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.isCluster, other.isCluster) && Objects.equals((Object)this.workloadType, (Object)other.workloadType) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.jobName, other.jobName) && Objects.equals(this.jobRunId, other.jobRunId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals((Object)this.resultDetails, (Object)other.resultDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeCompleted, other.timeCompleted) && Objects.equals(this.userName, other.userName) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals((Object)this.inBinds, (Object)other.inBinds) && Objects.equals((Object)this.outBinds, (Object)other.outBinds) && Objects.equals((Object)this.scheduleDetails, (Object)other.scheduleDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.managedDatabaseName == null ? 43 : this.managedDatabaseName.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.databaseSubType == null ? 43 : this.databaseSubType.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.isCluster == null ? 43 : this.isCluster.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.jobRunId == null ? 43 : this.jobRunId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.resultDetails == null ? 43 : this.resultDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeCompleted == null ? 43 : this.timeCompleted.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.inBinds == null ? 43 : this.inBinds.hashCode());
        result = result * 59 + (this.outBinds == null ? 43 : this.outBinds.hashCode());
        result = result * 59 + (this.scheduleDetails == null ? 43 : this.scheduleDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="managedDatabaseGroupId")
        private String managedDatabaseGroupId;
        @JsonProperty(value="managedDatabaseId")
        private String managedDatabaseId;
        @JsonProperty(value="managedDatabaseName")
        private String managedDatabaseName;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="databaseSubType")
        private DatabaseSubType databaseSubType;
        @JsonProperty(value="deploymentType")
        private DeploymentType deploymentType;
        @JsonProperty(value="isCluster")
        private Boolean isCluster;
        @JsonProperty(value="workloadType")
        private WorkloadType workloadType;
        @JsonProperty(value="jobId")
        private String jobId;
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="jobRunId")
        private String jobRunId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="resultDetails")
        private JobExecutionResultDetails resultDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeCompleted")
        private Date timeCompleted;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="inBinds")
        private JobInBindsDetails inBinds;
        @JsonProperty(value="outBinds")
        private JobOutBindsDetails outBinds;
        @JsonProperty(value="scheduleDetails")
        private JobScheduleDetails scheduleDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            this.__explicitlySet__.add("managedDatabaseGroupId");
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            this.__explicitlySet__.add("managedDatabaseId");
            return this;
        }

        public Builder managedDatabaseName(String managedDatabaseName) {
            this.managedDatabaseName = managedDatabaseName;
            this.__explicitlySet__.add("managedDatabaseName");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder databaseSubType(DatabaseSubType databaseSubType) {
            this.databaseSubType = databaseSubType;
            this.__explicitlySet__.add("databaseSubType");
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder isCluster(Boolean isCluster) {
            this.isCluster = isCluster;
            this.__explicitlySet__.add("isCluster");
            return this;
        }

        public Builder workloadType(WorkloadType workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            this.__explicitlySet__.add("jobRunId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder resultDetails(JobExecutionResultDetails resultDetails) {
            this.resultDetails = resultDetails;
            this.__explicitlySet__.add("resultDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeCompleted(Date timeCompleted) {
            this.timeCompleted = timeCompleted;
            this.__explicitlySet__.add("timeCompleted");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder inBinds(JobInBindsDetails inBinds) {
            this.inBinds = inBinds;
            this.__explicitlySet__.add("inBinds");
            return this;
        }

        public Builder outBinds(JobOutBindsDetails outBinds) {
            this.outBinds = outBinds;
            this.__explicitlySet__.add("outBinds");
            return this;
        }

        public Builder scheduleDetails(JobScheduleDetails scheduleDetails) {
            this.scheduleDetails = scheduleDetails;
            this.__explicitlySet__.add("scheduleDetails");
            return this;
        }

        public JobExecution build() {
            JobExecution model = new JobExecution(this.id, this.name, this.compartmentId, this.managedDatabaseGroupId, this.managedDatabaseId, this.managedDatabaseName, this.databaseType, this.databaseSubType, this.deploymentType, this.isCluster, this.workloadType, this.jobId, this.jobName, this.jobRunId, this.status, this.errorMessage, this.resultDetails, this.timeCreated, this.timeCompleted, this.userName, this.sqlText, this.inBinds, this.outBinds, this.scheduleDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobExecution model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseGroupId")) {
                this.managedDatabaseGroupId(model.getManagedDatabaseGroupId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseId")) {
                this.managedDatabaseId(model.getManagedDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("managedDatabaseName")) {
                this.managedDatabaseName(model.getManagedDatabaseName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("databaseSubType")) {
                this.databaseSubType(model.getDatabaseSubType());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("isCluster")) {
                this.isCluster(model.getIsCluster());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("jobRunId")) {
                this.jobRunId(model.getJobRunId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("resultDetails")) {
                this.resultDetails(model.getResultDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeCompleted")) {
                this.timeCompleted(model.getTimeCompleted());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("inBinds")) {
                this.inBinds(model.getInBinds());
            }
            if (model.wasPropertyExplicitlySet("outBinds")) {
                this.outBinds(model.getOutBinds());
            }
            if (model.wasPropertyExplicitlySet("scheduleDetails")) {
                this.scheduleDetails(model.getScheduleDetails());
            }
            return this;
        }
    }
}

