/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DbRole;
import com.oracle.bmc.databasemanagement.model.PerformanceMetrics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PerformanceMetricsData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="primaryDbId")
    private final String primaryDbId;
    @JsonProperty(value="primaryDbUniqueName")
    private final String primaryDbUniqueName;
    @JsonProperty(value="databaseId")
    private final String databaseId;
    @JsonProperty(value="dbUniqueName")
    private final String dbUniqueName;
    @JsonProperty(value="deploymentType")
    private final String deploymentType;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="dbRole")
    private final DbRole dbRole;
    @JsonProperty(value="metrics")
    private final List<PerformanceMetrics> metrics;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "resourceId", "primaryDbId", "primaryDbUniqueName", "databaseId", "dbUniqueName", "deploymentType", "resourceName", "dbRole", "metrics"})
    public PerformanceMetricsData(String compartmentId, String resourceId, String primaryDbId, String primaryDbUniqueName, String databaseId, String dbUniqueName, String deploymentType, String resourceName, DbRole dbRole, List<PerformanceMetrics> metrics) {
        this.compartmentId = compartmentId;
        this.resourceId = resourceId;
        this.primaryDbId = primaryDbId;
        this.primaryDbUniqueName = primaryDbUniqueName;
        this.databaseId = databaseId;
        this.dbUniqueName = dbUniqueName;
        this.deploymentType = deploymentType;
        this.resourceName = resourceName;
        this.dbRole = dbRole;
        this.metrics = metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getPrimaryDbId() {
        return this.primaryDbId;
    }

    public String getPrimaryDbUniqueName() {
        return this.primaryDbUniqueName;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public DbRole getDbRole() {
        return this.dbRole;
    }

    public List<PerformanceMetrics> getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PerformanceMetricsData(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", primaryDbId=").append(String.valueOf(this.primaryDbId));
        sb.append(", primaryDbUniqueName=").append(String.valueOf(this.primaryDbUniqueName));
        sb.append(", databaseId=").append(String.valueOf(this.databaseId));
        sb.append(", dbUniqueName=").append(String.valueOf(this.dbUniqueName));
        sb.append(", deploymentType=").append(String.valueOf(this.deploymentType));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", dbRole=").append(String.valueOf((Object)this.dbRole));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerformanceMetricsData)) {
            return false;
        }
        PerformanceMetricsData other = (PerformanceMetricsData)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.primaryDbId, other.primaryDbId) && Objects.equals(this.primaryDbUniqueName, other.primaryDbUniqueName) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.dbUniqueName, other.dbUniqueName) && Objects.equals(this.deploymentType, other.deploymentType) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals((Object)this.dbRole, (Object)other.dbRole) && Objects.equals(this.metrics, other.metrics) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.primaryDbId == null ? 43 : this.primaryDbId.hashCode());
        result = result * 59 + (this.primaryDbUniqueName == null ? 43 : this.primaryDbUniqueName.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.dbUniqueName == null ? 43 : this.dbUniqueName.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.dbRole == null ? 43 : this.dbRole.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="primaryDbId")
        private String primaryDbId;
        @JsonProperty(value="primaryDbUniqueName")
        private String primaryDbUniqueName;
        @JsonProperty(value="databaseId")
        private String databaseId;
        @JsonProperty(value="dbUniqueName")
        private String dbUniqueName;
        @JsonProperty(value="deploymentType")
        private String deploymentType;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="dbRole")
        private DbRole dbRole;
        @JsonProperty(value="metrics")
        private List<PerformanceMetrics> metrics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder primaryDbId(String primaryDbId) {
            this.primaryDbId = primaryDbId;
            this.__explicitlySet__.add("primaryDbId");
            return this;
        }

        public Builder primaryDbUniqueName(String primaryDbUniqueName) {
            this.primaryDbUniqueName = primaryDbUniqueName;
            this.__explicitlySet__.add("primaryDbUniqueName");
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            this.__explicitlySet__.add("databaseId");
            return this;
        }

        public Builder dbUniqueName(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
            this.__explicitlySet__.add("dbUniqueName");
            return this;
        }

        public Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            this.__explicitlySet__.add("deploymentType");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder dbRole(DbRole dbRole) {
            this.dbRole = dbRole;
            this.__explicitlySet__.add("dbRole");
            return this;
        }

        public Builder metrics(List<PerformanceMetrics> metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public PerformanceMetricsData build() {
            PerformanceMetricsData model = new PerformanceMetricsData(this.compartmentId, this.resourceId, this.primaryDbId, this.primaryDbUniqueName, this.databaseId, this.dbUniqueName, this.deploymentType, this.resourceName, this.dbRole, this.metrics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PerformanceMetricsData model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("primaryDbId")) {
                this.primaryDbId(model.getPrimaryDbId());
            }
            if (model.wasPropertyExplicitlySet("primaryDbUniqueName")) {
                this.primaryDbUniqueName(model.getPrimaryDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("databaseId")) {
                this.databaseId(model.getDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("dbUniqueName")) {
                this.dbUniqueName(model.getDbUniqueName());
            }
            if (model.wasPropertyExplicitlySet("deploymentType")) {
                this.deploymentType(model.getDeploymentType());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("dbRole")) {
                this.dbRole(model.getDbRole());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            return this;
        }
    }
}

