/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SpmEvolveTaskParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="alternatePlanSources")
    private final List<AlternatePlanSources> alternatePlanSources;
    @JsonProperty(value="alternatePlanBaselines")
    private final List<AlternatePlanBaselines> alternatePlanBaselines;
    @JsonProperty(value="alternatePlanLimit")
    private final Integer alternatePlanLimit;
    @JsonProperty(value="arePlansAutoAccepted")
    private final Boolean arePlansAutoAccepted;
    @JsonProperty(value="allowedTimeLimit")
    private final Integer allowedTimeLimit;

    @Deprecated
    @ConstructorProperties(value={"alternatePlanSources", "alternatePlanBaselines", "alternatePlanLimit", "arePlansAutoAccepted", "allowedTimeLimit"})
    public SpmEvolveTaskParameters(List<AlternatePlanSources> alternatePlanSources, List<AlternatePlanBaselines> alternatePlanBaselines, Integer alternatePlanLimit, Boolean arePlansAutoAccepted, Integer allowedTimeLimit) {
        this.alternatePlanSources = alternatePlanSources;
        this.alternatePlanBaselines = alternatePlanBaselines;
        this.alternatePlanLimit = alternatePlanLimit;
        this.arePlansAutoAccepted = arePlansAutoAccepted;
        this.allowedTimeLimit = allowedTimeLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<AlternatePlanSources> getAlternatePlanSources() {
        return this.alternatePlanSources;
    }

    public List<AlternatePlanBaselines> getAlternatePlanBaselines() {
        return this.alternatePlanBaselines;
    }

    public Integer getAlternatePlanLimit() {
        return this.alternatePlanLimit;
    }

    public Boolean getArePlansAutoAccepted() {
        return this.arePlansAutoAccepted;
    }

    public Integer getAllowedTimeLimit() {
        return this.allowedTimeLimit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SpmEvolveTaskParameters(");
        sb.append("super=").append(super.toString());
        sb.append("alternatePlanSources=").append(String.valueOf(this.alternatePlanSources));
        sb.append(", alternatePlanBaselines=").append(String.valueOf(this.alternatePlanBaselines));
        sb.append(", alternatePlanLimit=").append(String.valueOf(this.alternatePlanLimit));
        sb.append(", arePlansAutoAccepted=").append(String.valueOf(this.arePlansAutoAccepted));
        sb.append(", allowedTimeLimit=").append(String.valueOf(this.allowedTimeLimit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpmEvolveTaskParameters)) {
            return false;
        }
        SpmEvolveTaskParameters other = (SpmEvolveTaskParameters)((Object)o);
        return Objects.equals(this.alternatePlanSources, other.alternatePlanSources) && Objects.equals(this.alternatePlanBaselines, other.alternatePlanBaselines) && Objects.equals(this.alternatePlanLimit, other.alternatePlanLimit) && Objects.equals(this.arePlansAutoAccepted, other.arePlansAutoAccepted) && Objects.equals(this.allowedTimeLimit, other.allowedTimeLimit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alternatePlanSources == null ? 43 : this.alternatePlanSources.hashCode());
        result = result * 59 + (this.alternatePlanBaselines == null ? 43 : this.alternatePlanBaselines.hashCode());
        result = result * 59 + (this.alternatePlanLimit == null ? 43 : this.alternatePlanLimit.hashCode());
        result = result * 59 + (this.arePlansAutoAccepted == null ? 43 : this.arePlansAutoAccepted.hashCode());
        result = result * 59 + (this.allowedTimeLimit == null ? 43 : this.allowedTimeLimit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AlternatePlanBaselines implements BmcEnum
    {
        Auto("AUTO"),
        Existing("EXISTING"),
        New("NEW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AlternatePlanBaselines> map;

        private AlternatePlanBaselines(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AlternatePlanBaselines create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AlternatePlanBaselines', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AlternatePlanBaselines.class);
            map = new HashMap<String, AlternatePlanBaselines>();
            for (AlternatePlanBaselines v : AlternatePlanBaselines.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AlternatePlanSources implements BmcEnum
    {
        Auto("AUTO"),
        AutomaticWorkloadRepository("AUTOMATIC_WORKLOAD_REPOSITORY"),
        CursorCache("CURSOR_CACHE"),
        SqlTuningSet("SQL_TUNING_SET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AlternatePlanSources> map;

        private AlternatePlanSources(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AlternatePlanSources create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AlternatePlanSources', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AlternatePlanSources.class);
            map = new HashMap<String, AlternatePlanSources>();
            for (AlternatePlanSources v : AlternatePlanSources.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="alternatePlanSources")
        private List<AlternatePlanSources> alternatePlanSources;
        @JsonProperty(value="alternatePlanBaselines")
        private List<AlternatePlanBaselines> alternatePlanBaselines;
        @JsonProperty(value="alternatePlanLimit")
        private Integer alternatePlanLimit;
        @JsonProperty(value="arePlansAutoAccepted")
        private Boolean arePlansAutoAccepted;
        @JsonProperty(value="allowedTimeLimit")
        private Integer allowedTimeLimit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder alternatePlanSources(List<AlternatePlanSources> alternatePlanSources) {
            this.alternatePlanSources = alternatePlanSources;
            this.__explicitlySet__.add("alternatePlanSources");
            return this;
        }

        public Builder alternatePlanBaselines(List<AlternatePlanBaselines> alternatePlanBaselines) {
            this.alternatePlanBaselines = alternatePlanBaselines;
            this.__explicitlySet__.add("alternatePlanBaselines");
            return this;
        }

        public Builder alternatePlanLimit(Integer alternatePlanLimit) {
            this.alternatePlanLimit = alternatePlanLimit;
            this.__explicitlySet__.add("alternatePlanLimit");
            return this;
        }

        public Builder arePlansAutoAccepted(Boolean arePlansAutoAccepted) {
            this.arePlansAutoAccepted = arePlansAutoAccepted;
            this.__explicitlySet__.add("arePlansAutoAccepted");
            return this;
        }

        public Builder allowedTimeLimit(Integer allowedTimeLimit) {
            this.allowedTimeLimit = allowedTimeLimit;
            this.__explicitlySet__.add("allowedTimeLimit");
            return this;
        }

        public SpmEvolveTaskParameters build() {
            SpmEvolveTaskParameters model = new SpmEvolveTaskParameters(this.alternatePlanSources, this.alternatePlanBaselines, this.alternatePlanLimit, this.arePlansAutoAccepted, this.allowedTimeLimit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SpmEvolveTaskParameters model) {
            if (model.wasPropertyExplicitlySet("alternatePlanSources")) {
                this.alternatePlanSources(model.getAlternatePlanSources());
            }
            if (model.wasPropertyExplicitlySet("alternatePlanBaselines")) {
                this.alternatePlanBaselines(model.getAlternatePlanBaselines());
            }
            if (model.wasPropertyExplicitlySet("alternatePlanLimit")) {
                this.alternatePlanLimit(model.getAlternatePlanLimit());
            }
            if (model.wasPropertyExplicitlySet("arePlansAutoAccepted")) {
                this.arePlansAutoAccepted(model.getArePlansAutoAccepted());
            }
            if (model.wasPropertyExplicitlySet("allowedTimeLimit")) {
                this.allowedTimeLimit(model.getAllowedTimeLimit());
            }
            return this;
        }
    }
}

