/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.SqlInSqlTuningSet;
import com.oracle.bmc.databasemanagement.model.SqlTuningSetStatusTypes;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlTuningSet
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final Integer id;
    @JsonProperty(value="owner")
    private final String owner;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="statementCount")
    private final Integer statementCount;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;
    @JsonProperty(value="status")
    private final SqlTuningSetStatusTypes status;
    @JsonProperty(value="scheduledJobName")
    private final String scheduledJobName;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="allSqlStatementsFetched")
    private final AllSqlStatementsFetched allSqlStatementsFetched;
    @JsonProperty(value="sqlList")
    private final List<SqlInSqlTuningSet> sqlList;

    @Deprecated
    @ConstructorProperties(value={"id", "owner", "name", "statementCount", "timeCreated", "description", "timeLastModified", "status", "scheduledJobName", "errorMessage", "allSqlStatementsFetched", "sqlList"})
    public SqlTuningSet(Integer id, String owner, String name, Integer statementCount, Date timeCreated, String description, Date timeLastModified, SqlTuningSetStatusTypes status, String scheduledJobName, String errorMessage, AllSqlStatementsFetched allSqlStatementsFetched, List<SqlInSqlTuningSet> sqlList) {
        this.id = id;
        this.owner = owner;
        this.name = name;
        this.statementCount = statementCount;
        this.timeCreated = timeCreated;
        this.description = description;
        this.timeLastModified = timeLastModified;
        this.status = status;
        this.scheduledJobName = scheduledJobName;
        this.errorMessage = errorMessage;
        this.allSqlStatementsFetched = allSqlStatementsFetched;
        this.sqlList = sqlList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStatementCount() {
        return this.statementCount;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public SqlTuningSetStatusTypes getStatus() {
        return this.status;
    }

    public String getScheduledJobName() {
        return this.scheduledJobName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AllSqlStatementsFetched getAllSqlStatementsFetched() {
        return this.allSqlStatementsFetched;
    }

    public List<SqlInSqlTuningSet> getSqlList() {
        return this.sqlList;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlTuningSet(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", owner=").append(String.valueOf(this.owner));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", statementCount=").append(String.valueOf(this.statementCount));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", scheduledJobName=").append(String.valueOf(this.scheduledJobName));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", allSqlStatementsFetched=").append(String.valueOf((Object)this.allSqlStatementsFetched));
        sb.append(", sqlList=").append(String.valueOf(this.sqlList));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlTuningSet)) {
            return false;
        }
        SqlTuningSet other = (SqlTuningSet)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.owner, other.owner) && Objects.equals(this.name, other.name) && Objects.equals(this.statementCount, other.statementCount) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.description, other.description) && Objects.equals(this.timeLastModified, other.timeLastModified) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.scheduledJobName, other.scheduledJobName) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals((Object)this.allSqlStatementsFetched, (Object)other.allSqlStatementsFetched) && Objects.equals(this.sqlList, other.sqlList) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.statementCount == null ? 43 : this.statementCount.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.scheduledJobName == null ? 43 : this.scheduledJobName.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.allSqlStatementsFetched == null ? 43 : this.allSqlStatementsFetched.hashCode());
        result = result * 59 + (this.sqlList == null ? 43 : this.sqlList.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AllSqlStatementsFetched implements BmcEnum
    {
        Yes("YES"),
        No("NO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllSqlStatementsFetched> map;

        private AllSqlStatementsFetched(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllSqlStatementsFetched create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllSqlStatementsFetched', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllSqlStatementsFetched.class);
            map = new HashMap<String, AllSqlStatementsFetched>();
            for (AllSqlStatementsFetched v : AllSqlStatementsFetched.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private Integer id;
        @JsonProperty(value="owner")
        private String owner;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="statementCount")
        private Integer statementCount;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonProperty(value="status")
        private SqlTuningSetStatusTypes status;
        @JsonProperty(value="scheduledJobName")
        private String scheduledJobName;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="allSqlStatementsFetched")
        private AllSqlStatementsFetched allSqlStatementsFetched;
        @JsonProperty(value="sqlList")
        private List<SqlInSqlTuningSet> sqlList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(Integer id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder statementCount(Integer statementCount) {
            this.statementCount = statementCount;
            this.__explicitlySet__.add("statementCount");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public Builder status(SqlTuningSetStatusTypes status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder scheduledJobName(String scheduledJobName) {
            this.scheduledJobName = scheduledJobName;
            this.__explicitlySet__.add("scheduledJobName");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder allSqlStatementsFetched(AllSqlStatementsFetched allSqlStatementsFetched) {
            this.allSqlStatementsFetched = allSqlStatementsFetched;
            this.__explicitlySet__.add("allSqlStatementsFetched");
            return this;
        }

        public Builder sqlList(List<SqlInSqlTuningSet> sqlList) {
            this.sqlList = sqlList;
            this.__explicitlySet__.add("sqlList");
            return this;
        }

        public SqlTuningSet build() {
            SqlTuningSet model = new SqlTuningSet(this.id, this.owner, this.name, this.statementCount, this.timeCreated, this.description, this.timeLastModified, this.status, this.scheduledJobName, this.errorMessage, this.allSqlStatementsFetched, this.sqlList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlTuningSet model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("statementCount")) {
                this.statementCount(model.getStatementCount());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("scheduledJobName")) {
                this.scheduledJobName(model.getScheduledJobName());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("allSqlStatementsFetched")) {
                this.allSqlStatementsFetched(model.getAllSqlStatementsFetched());
            }
            if (model.wasPropertyExplicitlySet("sqlList")) {
                this.sqlList(model.getSqlList());
            }
            return this;
        }
    }
}

