/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.CompareType;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetDatabaseFleetHealthMetricsRequest
extends BmcRequest<Void> {
    private String compareBaselineTime;
    private String compareTargetTime;
    private String opcRequestId;
    private String managedDatabaseGroupId;
    private String compartmentId;
    private CompareType compareType;
    private String filterByMetricNames;
    private String filterByDatabaseType;
    private String filterByDatabaseSubType;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String filterByDatabaseDeploymentType;
    private String filterByDatabaseVersion;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;

    public String getCompareBaselineTime() {
        return this.compareBaselineTime;
    }

    public String getCompareTargetTime() {
        return this.compareTargetTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public String getFilterByMetricNames() {
        return this.filterByMetricNames;
    }

    public String getFilterByDatabaseType() {
        return this.filterByDatabaseType;
    }

    public String getFilterByDatabaseSubType() {
        return this.filterByDatabaseSubType;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getFilterByDatabaseDeploymentType() {
        return this.filterByDatabaseDeploymentType;
    }

    public String getFilterByDatabaseVersion() {
        return this.filterByDatabaseVersion;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Builder toBuilder() {
        return new Builder().compareBaselineTime(this.compareBaselineTime).compareTargetTime(this.compareTargetTime).opcRequestId(this.opcRequestId).managedDatabaseGroupId(this.managedDatabaseGroupId).compartmentId(this.compartmentId).compareType(this.compareType).filterByMetricNames(this.filterByMetricNames).filterByDatabaseType(this.filterByDatabaseType).filterByDatabaseSubType(this.filterByDatabaseSubType).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).filterByDatabaseDeploymentType(this.filterByDatabaseDeploymentType).filterByDatabaseVersion(this.filterByDatabaseVersion).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compareBaselineTime=").append(String.valueOf(this.compareBaselineTime));
        sb.append(",compareTargetTime=").append(String.valueOf(this.compareTargetTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",managedDatabaseGroupId=").append(String.valueOf(this.managedDatabaseGroupId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compareType=").append(String.valueOf((Object)this.compareType));
        sb.append(",filterByMetricNames=").append(String.valueOf(this.filterByMetricNames));
        sb.append(",filterByDatabaseType=").append(String.valueOf(this.filterByDatabaseType));
        sb.append(",filterByDatabaseSubType=").append(String.valueOf(this.filterByDatabaseSubType));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",filterByDatabaseDeploymentType=").append(String.valueOf(this.filterByDatabaseDeploymentType));
        sb.append(",filterByDatabaseVersion=").append(String.valueOf(this.filterByDatabaseVersion));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseFleetHealthMetricsRequest)) {
            return false;
        }
        GetDatabaseFleetHealthMetricsRequest other = (GetDatabaseFleetHealthMetricsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compareBaselineTime, other.compareBaselineTime) && Objects.equals(this.compareTargetTime, other.compareTargetTime) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.managedDatabaseGroupId, other.managedDatabaseGroupId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.compareType, (Object)other.compareType) && Objects.equals(this.filterByMetricNames, other.filterByMetricNames) && Objects.equals(this.filterByDatabaseType, other.filterByDatabaseType) && Objects.equals(this.filterByDatabaseSubType, other.filterByDatabaseSubType) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.filterByDatabaseDeploymentType, other.filterByDatabaseDeploymentType) && Objects.equals(this.filterByDatabaseVersion, other.filterByDatabaseVersion) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compareBaselineTime == null ? 43 : this.compareBaselineTime.hashCode());
        result = result * 59 + (this.compareTargetTime == null ? 43 : this.compareTargetTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.managedDatabaseGroupId == null ? 43 : this.managedDatabaseGroupId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compareType == null ? 43 : this.compareType.hashCode());
        result = result * 59 + (this.filterByMetricNames == null ? 43 : this.filterByMetricNames.hashCode());
        result = result * 59 + (this.filterByDatabaseType == null ? 43 : this.filterByDatabaseType.hashCode());
        result = result * 59 + (this.filterByDatabaseSubType == null ? 43 : this.filterByDatabaseSubType.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.filterByDatabaseDeploymentType == null ? 43 : this.filterByDatabaseDeploymentType.hashCode());
        result = result * 59 + (this.filterByDatabaseVersion == null ? 43 : this.filterByDatabaseVersion.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseFleetHealthMetricsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compareBaselineTime = null;
        private String compareTargetTime = null;
        private String opcRequestId = null;
        private String managedDatabaseGroupId = null;
        private String compartmentId = null;
        private CompareType compareType = null;
        private String filterByMetricNames = null;
        private String filterByDatabaseType = null;
        private String filterByDatabaseSubType = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String filterByDatabaseDeploymentType = null;
        private String filterByDatabaseVersion = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;

        public Builder compareBaselineTime(String compareBaselineTime) {
            this.compareBaselineTime = compareBaselineTime;
            return this;
        }

        public Builder compareTargetTime(String compareTargetTime) {
            this.compareTargetTime = compareTargetTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compareType(CompareType compareType) {
            this.compareType = compareType;
            return this;
        }

        public Builder filterByMetricNames(String filterByMetricNames) {
            this.filterByMetricNames = filterByMetricNames;
            return this;
        }

        public Builder filterByDatabaseType(String filterByDatabaseType) {
            this.filterByDatabaseType = filterByDatabaseType;
            return this;
        }

        public Builder filterByDatabaseSubType(String filterByDatabaseSubType) {
            this.filterByDatabaseSubType = filterByDatabaseSubType;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder filterByDatabaseDeploymentType(String filterByDatabaseDeploymentType) {
            this.filterByDatabaseDeploymentType = filterByDatabaseDeploymentType;
            return this;
        }

        public Builder filterByDatabaseVersion(String filterByDatabaseVersion) {
            this.filterByDatabaseVersion = filterByDatabaseVersion;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseFleetHealthMetricsRequest o) {
            this.compareBaselineTime(o.getCompareBaselineTime());
            this.compareTargetTime(o.getCompareTargetTime());
            this.opcRequestId(o.getOpcRequestId());
            this.managedDatabaseGroupId(o.getManagedDatabaseGroupId());
            this.compartmentId(o.getCompartmentId());
            this.compareType(o.getCompareType());
            this.filterByMetricNames(o.getFilterByMetricNames());
            this.filterByDatabaseType(o.getFilterByDatabaseType());
            this.filterByDatabaseSubType(o.getFilterByDatabaseSubType());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.filterByDatabaseDeploymentType(o.getFilterByDatabaseDeploymentType());
            this.filterByDatabaseVersion(o.getFilterByDatabaseVersion());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseFleetHealthMetricsRequest build() {
            GetDatabaseFleetHealthMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseFleetHealthMetricsRequest buildWithoutInvocationCallback() {
            GetDatabaseFleetHealthMetricsRequest request = new GetDatabaseFleetHealthMetricsRequest();
            request.compareBaselineTime = this.compareBaselineTime;
            request.compareTargetTime = this.compareTargetTime;
            request.opcRequestId = this.opcRequestId;
            request.managedDatabaseGroupId = this.managedDatabaseGroupId;
            request.compartmentId = this.compartmentId;
            request.compareType = this.compareType;
            request.filterByMetricNames = this.filterByMetricNames;
            request.filterByDatabaseType = this.filterByDatabaseType;
            request.filterByDatabaseSubType = this.filterByDatabaseSubType;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.filterByDatabaseDeploymentType = this.filterByDatabaseDeploymentType;
            request.filterByDatabaseVersion = this.filterByDatabaseVersion;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

