/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalAsmConfigurationRequest
extends BmcRequest<Void> {
    private String externalAsmId;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getExternalAsmId() {
        return this.externalAsmId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().externalAsmId(this.externalAsmId).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalAsmId=").append(String.valueOf(this.externalAsmId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalAsmConfigurationRequest)) {
            return false;
        }
        GetExternalAsmConfigurationRequest other = (GetExternalAsmConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalAsmId, other.externalAsmId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalAsmId == null ? 43 : this.externalAsmId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalAsmConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalAsmId = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder externalAsmId(String externalAsmId) {
            this.externalAsmId = externalAsmId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalAsmConfigurationRequest o) {
            this.externalAsmId(o.getExternalAsmId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalAsmConfigurationRequest build() {
            GetExternalAsmConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalAsmConfigurationRequest buildWithoutInvocationCallback() {
            GetExternalAsmConfigurationRequest request = new GetExternalAsmConfigurationRequest();
            request.externalAsmId = this.externalAsmId;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }
}

