/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalListenerRequest
extends BmcRequest<Void> {
    private String externalListenerId;
    private String opcRequestId;

    public String getExternalListenerId() {
        return this.externalListenerId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().externalListenerId(this.externalListenerId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalListenerId=").append(String.valueOf(this.externalListenerId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalListenerRequest)) {
            return false;
        }
        GetExternalListenerRequest other = (GetExternalListenerRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalListenerId, other.externalListenerId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalListenerId == null ? 43 : this.externalListenerId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalListenerRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalListenerId = null;
        private String opcRequestId = null;

        public Builder externalListenerId(String externalListenerId) {
            this.externalListenerId = externalListenerId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalListenerRequest o) {
            this.externalListenerId(o.getExternalListenerId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalListenerRequest build() {
            GetExternalListenerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalListenerRequest buildWithoutInvocationCallback() {
            GetExternalListenerRequest request = new GetExternalListenerRequest();
            request.externalListenerId = this.externalListenerId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

