/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDatabaseParametersRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String opcRequestId;
    private Source source;
    private String name;
    private Boolean isAllowedValuesIncluded;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String opcNamedCredentialId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Source getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsAllowedValuesIncluded() {
        return this.isAllowedValuesIncluded;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).opcRequestId(this.opcRequestId).source(this.source).name(this.name).isAllowedValuesIncluded(this.isAllowedValuesIncluded).sortBy(this.sortBy).sortOrder(this.sortOrder).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",source=").append(String.valueOf((Object)this.source));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",isAllowedValuesIncluded=").append(String.valueOf(this.isAllowedValuesIncluded));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDatabaseParametersRequest)) {
            return false;
        }
        ListDatabaseParametersRequest other = (ListDatabaseParametersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.name, other.name) && Objects.equals(this.isAllowedValuesIncluded, other.isAllowedValuesIncluded) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isAllowedValuesIncluded == null ? 43 : this.isAllowedValuesIncluded.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDatabaseParametersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String opcRequestId = null;
        private Source source = null;
        private String name = null;
        private Boolean isAllowedValuesIncluded = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String opcNamedCredentialId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isAllowedValuesIncluded(Boolean isAllowedValuesIncluded) {
            this.isAllowedValuesIncluded = isAllowedValuesIncluded;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDatabaseParametersRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.source(o.getSource());
            this.name(o.getName());
            this.isAllowedValuesIncluded(o.getIsAllowedValuesIncluded());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDatabaseParametersRequest build() {
            ListDatabaseParametersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDatabaseParametersRequest buildWithoutInvocationCallback() {
            ListDatabaseParametersRequest request = new ListDatabaseParametersRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.opcRequestId = this.opcRequestId;
            request.source = this.source;
            request.name = this.name;
            request.isAllowedValuesIncluded = this.isAllowedValuesIncluded;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Source implements BmcEnum
    {
        Current("CURRENT"),
        Spfile("SPFILE");

        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Source: " + key);
        }

        static {
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

