/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListExternalListenerServicesRequest
extends BmcRequest<Void> {
    private String externalListenerId;
    private String managedDatabaseId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;
    private String opcRequestId;
    private String opcNamedCredentialId;

    public String getExternalListenerId() {
        return this.externalListenerId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNamedCredentialId() {
        return this.opcNamedCredentialId;
    }

    public Builder toBuilder() {
        return new Builder().externalListenerId(this.externalListenerId).managedDatabaseId(this.managedDatabaseId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).opcNamedCredentialId(this.opcNamedCredentialId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalListenerId=").append(String.valueOf(this.externalListenerId));
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNamedCredentialId=").append(String.valueOf(this.opcNamedCredentialId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListExternalListenerServicesRequest)) {
            return false;
        }
        ListExternalListenerServicesRequest other = (ListExternalListenerServicesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalListenerId, other.externalListenerId) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNamedCredentialId, other.opcNamedCredentialId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalListenerId == null ? 43 : this.externalListenerId.hashCode());
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNamedCredentialId == null ? 43 : this.opcNamedCredentialId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListExternalListenerServicesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalListenerId = null;
        private String managedDatabaseId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;
        private String opcRequestId = null;
        private String opcNamedCredentialId = null;

        public Builder externalListenerId(String externalListenerId) {
            this.externalListenerId = externalListenerId;
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNamedCredentialId(String opcNamedCredentialId) {
            this.opcNamedCredentialId = opcNamedCredentialId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListExternalListenerServicesRequest o) {
            this.externalListenerId(o.getExternalListenerId());
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNamedCredentialId(o.getOpcNamedCredentialId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListExternalListenerServicesRequest build() {
            ListExternalListenerServicesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListExternalListenerServicesRequest buildWithoutInvocationCallback() {
            ListExternalListenerServicesRequest request = new ListExternalListenerServicesRequest();
            request.externalListenerId = this.externalListenerId;
            request.managedDatabaseId = this.managedDatabaseId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.opcNamedCredentialId = this.opcNamedCredentialId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

