/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.DeploymentType;
import com.oracle.bmc.databasemanagement.model.ManagementOption;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListManagedDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String id;
    private String name;
    private ManagementOption managementOption;
    private DeploymentType deploymentType;
    private String externalExadataInfrastructureId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrders sortOrder;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ManagementOption getManagementOption() {
        return this.managementOption;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public String getExternalExadataInfrastructureId() {
        return this.externalExadataInfrastructureId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).id(this.id).name(this.name).managementOption(this.managementOption).deploymentType(this.deploymentType).externalExadataInfrastructureId(this.externalExadataInfrastructureId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",managementOption=").append(String.valueOf((Object)this.managementOption));
        sb.append(",deploymentType=").append(String.valueOf((Object)this.deploymentType));
        sb.append(",externalExadataInfrastructureId=").append(String.valueOf(this.externalExadataInfrastructureId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListManagedDatabasesRequest)) {
            return false;
        }
        ListManagedDatabasesRequest other = (ListManagedDatabasesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.managementOption, (Object)other.managementOption) && Objects.equals((Object)this.deploymentType, (Object)other.deploymentType) && Objects.equals(this.externalExadataInfrastructureId, other.externalExadataInfrastructureId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.managementOption == null ? 43 : this.managementOption.hashCode());
        result = result * 59 + (this.deploymentType == null ? 43 : this.deploymentType.hashCode());
        result = result * 59 + (this.externalExadataInfrastructureId == null ? 43 : this.externalExadataInfrastructureId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListManagedDatabasesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private String id = null;
        private String name = null;
        private ManagementOption managementOption = null;
        private DeploymentType deploymentType = null;
        private String externalExadataInfrastructureId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrders sortOrder = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder managementOption(ManagementOption managementOption) {
            this.managementOption = managementOption;
            return this;
        }

        public Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        public Builder externalExadataInfrastructureId(String externalExadataInfrastructureId) {
            this.externalExadataInfrastructureId = externalExadataInfrastructureId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListManagedDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.id(o.getId());
            this.name(o.getName());
            this.managementOption(o.getManagementOption());
            this.deploymentType(o.getDeploymentType());
            this.externalExadataInfrastructureId(o.getExternalExadataInfrastructureId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListManagedDatabasesRequest build() {
            ListManagedDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListManagedDatabasesRequest buildWithoutInvocationCallback() {
            ListManagedDatabasesRequest request = new ListManagedDatabasesRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.id = this.id;
            request.name = this.name;
            request.managementOption = this.managementOption;
            request.deploymentType = this.deploymentType;
            request.externalExadataInfrastructureId = this.externalExadataInfrastructureId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

