/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.PatchExternalDbSystemDiscoveryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PatchExternalDbSystemDiscoveryRequest
extends BmcRequest<PatchExternalDbSystemDiscoveryDetails> {
    private String externalDbSystemDiscoveryId;
    private PatchExternalDbSystemDiscoveryDetails patchExternalDbSystemDiscoveryDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getExternalDbSystemDiscoveryId() {
        return this.externalDbSystemDiscoveryId;
    }

    public PatchExternalDbSystemDiscoveryDetails getPatchExternalDbSystemDiscoveryDetails() {
        return this.patchExternalDbSystemDiscoveryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public PatchExternalDbSystemDiscoveryDetails getBody$() {
        return this.patchExternalDbSystemDiscoveryDetails;
    }

    public Builder toBuilder() {
        return new Builder().externalDbSystemDiscoveryId(this.externalDbSystemDiscoveryId).patchExternalDbSystemDiscoveryDetails(this.patchExternalDbSystemDiscoveryDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",externalDbSystemDiscoveryId=").append(String.valueOf(this.externalDbSystemDiscoveryId));
        sb.append(",patchExternalDbSystemDiscoveryDetails=").append(String.valueOf((Object)this.patchExternalDbSystemDiscoveryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchExternalDbSystemDiscoveryRequest)) {
            return false;
        }
        PatchExternalDbSystemDiscoveryRequest other = (PatchExternalDbSystemDiscoveryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.externalDbSystemDiscoveryId, other.externalDbSystemDiscoveryId) && Objects.equals((Object)this.patchExternalDbSystemDiscoveryDetails, (Object)other.patchExternalDbSystemDiscoveryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalDbSystemDiscoveryId == null ? 43 : this.externalDbSystemDiscoveryId.hashCode());
        result = result * 59 + (this.patchExternalDbSystemDiscoveryDetails == null ? 43 : this.patchExternalDbSystemDiscoveryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PatchExternalDbSystemDiscoveryRequest, PatchExternalDbSystemDiscoveryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String externalDbSystemDiscoveryId = null;
        private PatchExternalDbSystemDiscoveryDetails patchExternalDbSystemDiscoveryDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder externalDbSystemDiscoveryId(String externalDbSystemDiscoveryId) {
            this.externalDbSystemDiscoveryId = externalDbSystemDiscoveryId;
            return this;
        }

        public Builder patchExternalDbSystemDiscoveryDetails(PatchExternalDbSystemDiscoveryDetails patchExternalDbSystemDiscoveryDetails) {
            this.patchExternalDbSystemDiscoveryDetails = patchExternalDbSystemDiscoveryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchExternalDbSystemDiscoveryRequest o) {
            this.externalDbSystemDiscoveryId(o.getExternalDbSystemDiscoveryId());
            this.patchExternalDbSystemDiscoveryDetails(o.getPatchExternalDbSystemDiscoveryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchExternalDbSystemDiscoveryRequest build() {
            PatchExternalDbSystemDiscoveryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PatchExternalDbSystemDiscoveryDetails body) {
            this.patchExternalDbSystemDiscoveryDetails(body);
            return this;
        }

        public PatchExternalDbSystemDiscoveryRequest buildWithoutInvocationCallback() {
            PatchExternalDbSystemDiscoveryRequest request = new PatchExternalDbSystemDiscoveryRequest();
            request.externalDbSystemDiscoveryId = this.externalDbSystemDiscoveryId;
            request.patchExternalDbSystemDiscoveryDetails = this.patchExternalDbSystemDiscoveryDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

