/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.UpdateManagedDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateManagedDatabaseRequest
extends BmcRequest<UpdateManagedDatabaseDetails> {
    private String managedDatabaseId;
    private UpdateManagedDatabaseDetails updateManagedDatabaseDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public UpdateManagedDatabaseDetails getUpdateManagedDatabaseDetails() {
        return this.updateManagedDatabaseDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateManagedDatabaseDetails getBody$() {
        return this.updateManagedDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).updateManagedDatabaseDetails(this.updateManagedDatabaseDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",updateManagedDatabaseDetails=").append(String.valueOf((Object)this.updateManagedDatabaseDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateManagedDatabaseRequest)) {
            return false;
        }
        UpdateManagedDatabaseRequest other = (UpdateManagedDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.updateManagedDatabaseDetails, (Object)other.updateManagedDatabaseDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.updateManagedDatabaseDetails == null ? 43 : this.updateManagedDatabaseDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateManagedDatabaseRequest, UpdateManagedDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private UpdateManagedDatabaseDetails updateManagedDatabaseDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder updateManagedDatabaseDetails(UpdateManagedDatabaseDetails updateManagedDatabaseDetails) {
            this.updateManagedDatabaseDetails = updateManagedDatabaseDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateManagedDatabaseRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.updateManagedDatabaseDetails(o.getUpdateManagedDatabaseDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateManagedDatabaseRequest build() {
            UpdateManagedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateManagedDatabaseDetails body) {
            this.updateManagedDatabaseDetails(body);
            return this;
        }

        public UpdateManagedDatabaseRequest buildWithoutInvocationCallback() {
            UpdateManagedDatabaseRequest request = new UpdateManagedDatabaseRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.updateManagedDatabaseDetails = this.updateManagedDatabaseDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

