/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.DbManagementAsync;
import com.oracle.bmc.databasemanagement.model.AddmTasksCollection;
import com.oracle.bmc.databasemanagement.model.AsmPropertyCollection;
import com.oracle.bmc.databasemanagement.model.AssociatedDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbCpuUsageCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbMetricCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterChangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbParameterCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSnapshotRangeCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbSqlReport;
import com.oracle.bmc.databasemanagement.model.AwrDbSysstatCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbTopWaitEventCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventBucketCollection;
import com.oracle.bmc.databasemanagement.model.AwrDbWaitEventCollection;
import com.oracle.bmc.databasemanagement.model.ClusterCacheMetric;
import com.oracle.bmc.databasemanagement.model.ConsumerGroupPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.CursorCacheStatementCollection;
import com.oracle.bmc.databasemanagement.model.DataAccessContainerCollection;
import com.oracle.bmc.databasemanagement.model.DatabaseFleetHealthMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseHomeMetrics;
import com.oracle.bmc.databasemanagement.model.DatabaseParametersCollection;
import com.oracle.bmc.databasemanagement.model.DataguardPerformanceMetrics;
import com.oracle.bmc.databasemanagement.model.DbManagementPrivateEndpoint;
import com.oracle.bmc.databasemanagement.model.DbManagementPrivateEndpointCollection;
import com.oracle.bmc.databasemanagement.model.ExternalAsm;
import com.oracle.bmc.databasemanagement.model.ExternalAsmCollection;
import com.oracle.bmc.databasemanagement.model.ExternalAsmConfiguration;
import com.oracle.bmc.databasemanagement.model.ExternalAsmDiskGroupCollection;
import com.oracle.bmc.databasemanagement.model.ExternalAsmInstance;
import com.oracle.bmc.databasemanagement.model.ExternalAsmInstanceCollection;
import com.oracle.bmc.databasemanagement.model.ExternalAsmUserCollection;
import com.oracle.bmc.databasemanagement.model.ExternalCluster;
import com.oracle.bmc.databasemanagement.model.ExternalClusterCollection;
import com.oracle.bmc.databasemanagement.model.ExternalClusterInstance;
import com.oracle.bmc.databasemanagement.model.ExternalClusterInstanceCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDbHome;
import com.oracle.bmc.databasemanagement.model.ExternalDbHomeCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDbNode;
import com.oracle.bmc.databasemanagement.model.ExternalDbNodeCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystem;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnector;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectorCollection;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscovery;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryCollection;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructure;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructureCollection;
import com.oracle.bmc.databasemanagement.model.ExternalExadataInfrastructureDiscovery;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageConnector;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageConnectorCollection;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageConnectorStatus;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageGrid;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageServer;
import com.oracle.bmc.databasemanagement.model.ExternalExadataStorageServerCollection;
import com.oracle.bmc.databasemanagement.model.ExternalListener;
import com.oracle.bmc.databasemanagement.model.ExternalListenerCollection;
import com.oracle.bmc.databasemanagement.model.ExternalListenerServiceCollection;
import com.oracle.bmc.databasemanagement.model.HistoricAddmResult;
import com.oracle.bmc.databasemanagement.model.IormPlan;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.JobCollection;
import com.oracle.bmc.databasemanagement.model.JobExecution;
import com.oracle.bmc.databasemanagement.model.JobExecutionCollection;
import com.oracle.bmc.databasemanagement.model.JobExecutionsStatusSummaryCollection;
import com.oracle.bmc.databasemanagement.model.JobRun;
import com.oracle.bmc.databasemanagement.model.JobRunCollection;
import com.oracle.bmc.databasemanagement.model.ManagedDatabase;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseCollection;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroup;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroupCollection;
import com.oracle.bmc.databasemanagement.model.MetricsAggregationRangeCollection;
import com.oracle.bmc.databasemanagement.model.NamedCredential;
import com.oracle.bmc.databasemanagement.model.NamedCredentialCollection;
import com.oracle.bmc.databasemanagement.model.ObjectPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.OpenAlertHistory;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecution;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecutionScript;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsAdvisorExecutionsCollection;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionAggregationsCollection;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionOperation;
import com.oracle.bmc.databasemanagement.model.OptimizerStatisticsCollectionOperationsCollection;
import com.oracle.bmc.databasemanagement.model.PdbMetrics;
import com.oracle.bmc.databasemanagement.model.PeerDatabaseMetrics;
import com.oracle.bmc.databasemanagement.model.PreferredCredential;
import com.oracle.bmc.databasemanagement.model.PreferredCredentialCollection;
import com.oracle.bmc.databasemanagement.model.ProxiedForUserCollection;
import com.oracle.bmc.databasemanagement.model.ProxyUserCollection;
import com.oracle.bmc.databasemanagement.model.RoleCollection;
import com.oracle.bmc.databasemanagement.model.SnapshotDetails;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaseline;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineAggregationCollection;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineCollection;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineConfiguration;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineJob;
import com.oracle.bmc.databasemanagement.model.SqlPlanBaselineJobCollection;
import com.oracle.bmc.databasemanagement.model.SystemPrivilegeCollection;
import com.oracle.bmc.databasemanagement.model.TableStatisticsCollection;
import com.oracle.bmc.databasemanagement.model.Tablespace;
import com.oracle.bmc.databasemanagement.model.TablespaceAdminStatus;
import com.oracle.bmc.databasemanagement.model.TablespaceCollection;
import com.oracle.bmc.databasemanagement.model.TestNamedCredentialStatus;
import com.oracle.bmc.databasemanagement.model.TestPreferredCredentialStatus;
import com.oracle.bmc.databasemanagement.model.TopSqlCpuActivity;
import com.oracle.bmc.databasemanagement.model.UpdateDatabaseParametersResult;
import com.oracle.bmc.databasemanagement.model.User;
import com.oracle.bmc.databasemanagement.model.UserCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequest;
import com.oracle.bmc.databasemanagement.model.WorkRequestCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequestErrorCollection;
import com.oracle.bmc.databasemanagement.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.databasemanagement.requests.AddDataFilesRequest;
import com.oracle.bmc.databasemanagement.requests.AddManagedDatabaseToManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.AddmTasksRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeDbManagementPrivateEndpointCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeExternalDbSystemCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeExternalExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeManagedDatabaseGroupCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeNamedCredentialCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangePlanRetentionRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeSpaceBudgetRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeSqlPlanBaselinesAttributesRequest;
import com.oracle.bmc.databasemanagement.requests.CheckExternalDbSystemConnectorConnectionStatusRequest;
import com.oracle.bmc.databasemanagement.requests.CheckExternalExadataStorageConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.ConfigureAutomaticCaptureFiltersRequest;
import com.oracle.bmc.databasemanagement.requests.ConfigureAutomaticSpmEvolveAdvisorTaskRequest;
import com.oracle.bmc.databasemanagement.requests.CreateDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.CreateExternalDbSystemConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.CreateExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.CreateExternalDbSystemRequest;
import com.oracle.bmc.databasemanagement.requests.CreateExternalExadataInfrastructureRequest;
import com.oracle.bmc.databasemanagement.requests.CreateExternalExadataStorageConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.CreateJobRequest;
import com.oracle.bmc.databasemanagement.requests.CreateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.CreateNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.CreateTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteExternalDbSystemConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteExternalDbSystemRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteExternalExadataInfrastructureRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteExternalExadataStorageConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteJobRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.DeletePreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.DisableAutomaticInitialPlanCaptureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableAutomaticSpmEvolveAdvisorTaskRequest;
import com.oracle.bmc.databasemanagement.requests.DisableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalContainerDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalDbSystemDatabaseManagementRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalDbSystemStackMonitoringRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalExadataInfrastructureManagementRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalNonContainerDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableExternalPluggableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest;
import com.oracle.bmc.databasemanagement.requests.DisablePluggableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.DisableSqlPlanBaselinesUsageRequest;
import com.oracle.bmc.databasemanagement.requests.DiscoverExternalExadataInfrastructureRequest;
import com.oracle.bmc.databasemanagement.requests.DropSqlPlanBaselinesRequest;
import com.oracle.bmc.databasemanagement.requests.DropTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.EnableAutomaticInitialPlanCaptureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableAutomaticSpmEvolveAdvisorTaskRequest;
import com.oracle.bmc.databasemanagement.requests.EnableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalContainerDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalDbSystemDatabaseManagementRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalDbSystemStackMonitoringRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalExadataInfrastructureManagementRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalNonContainerDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableExternalPluggableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest;
import com.oracle.bmc.databasemanagement.requests.EnablePluggableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.EnableSqlPlanBaselinesUsageRequest;
import com.oracle.bmc.databasemanagement.requests.GenerateAwrSnapshotRequest;
import com.oracle.bmc.databasemanagement.requests.GetAwrDbReportRequest;
import com.oracle.bmc.databasemanagement.requests.GetAwrDbSqlReportRequest;
import com.oracle.bmc.databasemanagement.requests.GetClusterCacheMetricRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseFleetHealthMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseHomeMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDataguardPerformanceMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalAsmConfigurationRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalAsmInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalAsmRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalClusterInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalClusterRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbHomeRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbNodeRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalExadataInfrastructureRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalExadataStorageConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalExadataStorageGridRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalExadataStorageServerRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalListenerRequest;
import com.oracle.bmc.databasemanagement.requests.GetIormPlanRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRunRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.GetNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.GetOpenAlertHistoryRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsAdvisorExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsAdvisorExecutionScriptRequest;
import com.oracle.bmc.databasemanagement.requests.GetOptimizerStatisticsCollectionOperationRequest;
import com.oracle.bmc.databasemanagement.requests.GetPdbMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetPeerDatabaseMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetPreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlPlanBaselineConfigurationRequest;
import com.oracle.bmc.databasemanagement.requests.GetSqlPlanBaselineRequest;
import com.oracle.bmc.databasemanagement.requests.GetTablespaceRequest;
import com.oracle.bmc.databasemanagement.requests.GetTopSqlCpuActivityRequest;
import com.oracle.bmc.databasemanagement.requests.GetUserRequest;
import com.oracle.bmc.databasemanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemanagement.requests.ImplementOptimizerStatisticsAdvisorRecommendationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAsmPropertiesRequest;
import com.oracle.bmc.databasemanagement.requests.ListAssociatedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.ListAwrDbSnapshotsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAwrDbsRequest;
import com.oracle.bmc.databasemanagement.requests.ListConsumerGroupPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListCursorCacheStatementsRequest;
import com.oracle.bmc.databasemanagement.requests.ListDataAccessContainersRequest;
import com.oracle.bmc.databasemanagement.requests.ListDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ListDbManagementPrivateEndpointsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalAsmDiskGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalAsmInstancesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalAsmUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalAsmsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalClusterInstancesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalClustersRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDbHomesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDbNodesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDbSystemConnectorsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDbSystemDiscoveriesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalDbSystemsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalExadataInfrastructuresRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalExadataStorageConnectorsRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalExadataStorageServersRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalListenerServicesRequest;
import com.oracle.bmc.databasemanagement.requests.ListExternalListenersRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobRunsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabaseGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.ListNamedCredentialsRequest;
import com.oracle.bmc.databasemanagement.requests.ListObjectPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsAdvisorExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsCollectionAggregationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListOptimizerStatisticsCollectionOperationsRequest;
import com.oracle.bmc.databasemanagement.requests.ListPreferredCredentialsRequest;
import com.oracle.bmc.databasemanagement.requests.ListProxiedForUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListProxyUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListRolesRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlPlanBaselineJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListSqlPlanBaselinesRequest;
import com.oracle.bmc.databasemanagement.requests.ListSystemPrivilegesRequest;
import com.oracle.bmc.databasemanagement.requests.ListTableStatisticsRequest;
import com.oracle.bmc.databasemanagement.requests.ListTablespacesRequest;
import com.oracle.bmc.databasemanagement.requests.ListUsersRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.databasemanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.databasemanagement.requests.LoadSqlPlanBaselinesFromAwrRequest;
import com.oracle.bmc.databasemanagement.requests.LoadSqlPlanBaselinesFromCursorCacheRequest;
import com.oracle.bmc.databasemanagement.requests.ModifyDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.ModifyPluggableDatabaseManagementFeatureRequest;
import com.oracle.bmc.databasemanagement.requests.PatchExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveDataFileRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveManagedDatabaseFromManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.ResetDatabaseParametersRequest;
import com.oracle.bmc.databasemanagement.requests.ResizeDataFileRequest;
import com.oracle.bmc.databasemanagement.requests.RunHistoricAddmRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbCpuUsagesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbParameterChangesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbParametersRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbSnapshotRangesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbSysstatsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbTopWaitEventsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbWaitEventBucketsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAwrDbWaitEventsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeExternalAsmMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeExternalClusterMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeExternalDbNodeMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeExternalDbSystemAvailabilityMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeExternalListenerMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeJobExecutionsStatusesRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeManagedDatabaseAvailabilityMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeSqlPlanBaselinesByLastExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeSqlPlanBaselinesRequest;
import com.oracle.bmc.databasemanagement.requests.TestNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.TestPreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalAsmInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalAsmRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalClusterInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalClusterRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalDbHomeRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalDbNodeRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalDbSystemConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalDbSystemRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalExadataInfrastructureRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalExadataStorageConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalExadataStorageGridRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalExadataStorageServerRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateExternalListenerRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateJobRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateManagedDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.UpdatePreferredCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateTablespaceRequest;
import com.oracle.bmc.databasemanagement.responses.AddDataFilesResponse;
import com.oracle.bmc.databasemanagement.responses.AddManagedDatabaseToManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.AddmTasksResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeDbManagementPrivateEndpointCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeExternalDbSystemCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeExternalExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeManagedDatabaseGroupCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeNamedCredentialCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangePlanRetentionResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeSpaceBudgetResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeSqlPlanBaselinesAttributesResponse;
import com.oracle.bmc.databasemanagement.responses.CheckExternalDbSystemConnectorConnectionStatusResponse;
import com.oracle.bmc.databasemanagement.responses.CheckExternalExadataStorageConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.ConfigureAutomaticCaptureFiltersResponse;
import com.oracle.bmc.databasemanagement.responses.ConfigureAutomaticSpmEvolveAdvisorTaskResponse;
import com.oracle.bmc.databasemanagement.responses.CreateDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.CreateExternalDbSystemConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.CreateExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.CreateExternalDbSystemResponse;
import com.oracle.bmc.databasemanagement.responses.CreateExternalExadataInfrastructureResponse;
import com.oracle.bmc.databasemanagement.responses.CreateExternalExadataStorageConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.CreateJobResponse;
import com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.CreateNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.CreateTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteExternalDbSystemConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteExternalDbSystemResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteExternalExadataInfrastructureResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteExternalExadataStorageConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteJobResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.DeletePreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.DisableAutomaticInitialPlanCaptureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableAutomaticSpmEvolveAdvisorTaskResponse;
import com.oracle.bmc.databasemanagement.responses.DisableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalContainerDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalDbSystemDatabaseManagementResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalDbSystemStackMonitoringResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalExadataInfrastructureManagementResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalNonContainerDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableExternalPluggableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse;
import com.oracle.bmc.databasemanagement.responses.DisablePluggableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.DisableSqlPlanBaselinesUsageResponse;
import com.oracle.bmc.databasemanagement.responses.DiscoverExternalExadataInfrastructureResponse;
import com.oracle.bmc.databasemanagement.responses.DropSqlPlanBaselinesResponse;
import com.oracle.bmc.databasemanagement.responses.DropTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.EnableAutomaticInitialPlanCaptureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableAutomaticSpmEvolveAdvisorTaskResponse;
import com.oracle.bmc.databasemanagement.responses.EnableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalContainerDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalDbSystemDatabaseManagementResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalDbSystemStackMonitoringResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalExadataInfrastructureManagementResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalNonContainerDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableExternalPluggableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse;
import com.oracle.bmc.databasemanagement.responses.EnablePluggableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.EnableSqlPlanBaselinesUsageResponse;
import com.oracle.bmc.databasemanagement.responses.GenerateAwrSnapshotResponse;
import com.oracle.bmc.databasemanagement.responses.GetAwrDbReportResponse;
import com.oracle.bmc.databasemanagement.responses.GetAwrDbSqlReportResponse;
import com.oracle.bmc.databasemanagement.responses.GetClusterCacheMetricResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDataguardPerformanceMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalAsmConfigurationResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalAsmInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalAsmResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalClusterInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalClusterResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbHomeResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbNodeResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalExadataInfrastructureResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalExadataStorageConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalExadataStorageGridResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalExadataStorageServerResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalListenerResponse;
import com.oracle.bmc.databasemanagement.responses.GetIormPlanResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobRunResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.GetNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.GetOpenAlertHistoryResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsAdvisorExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsAdvisorExecutionScriptResponse;
import com.oracle.bmc.databasemanagement.responses.GetOptimizerStatisticsCollectionOperationResponse;
import com.oracle.bmc.databasemanagement.responses.GetPdbMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetPeerDatabaseMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetPreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlPlanBaselineConfigurationResponse;
import com.oracle.bmc.databasemanagement.responses.GetSqlPlanBaselineResponse;
import com.oracle.bmc.databasemanagement.responses.GetTablespaceResponse;
import com.oracle.bmc.databasemanagement.responses.GetTopSqlCpuActivityResponse;
import com.oracle.bmc.databasemanagement.responses.GetUserResponse;
import com.oracle.bmc.databasemanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.databasemanagement.responses.ImplementOptimizerStatisticsAdvisorRecommendationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAsmPropertiesResponse;
import com.oracle.bmc.databasemanagement.responses.ListAssociatedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.ListAwrDbSnapshotsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAwrDbsResponse;
import com.oracle.bmc.databasemanagement.responses.ListConsumerGroupPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListCursorCacheStatementsResponse;
import com.oracle.bmc.databasemanagement.responses.ListDataAccessContainersResponse;
import com.oracle.bmc.databasemanagement.responses.ListDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ListDbManagementPrivateEndpointsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalAsmDiskGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalAsmInstancesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalAsmUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalAsmsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalClusterInstancesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalClustersResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDbHomesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDbNodesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDbSystemConnectorsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDbSystemDiscoveriesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalDbSystemsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalExadataInfrastructuresResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalExadataStorageConnectorsResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalExadataStorageServersResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalListenerServicesResponse;
import com.oracle.bmc.databasemanagement.responses.ListExternalListenersResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobRunsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabaseGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.ListNamedCredentialsResponse;
import com.oracle.bmc.databasemanagement.responses.ListObjectPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsAdvisorExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsCollectionAggregationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListOptimizerStatisticsCollectionOperationsResponse;
import com.oracle.bmc.databasemanagement.responses.ListPreferredCredentialsResponse;
import com.oracle.bmc.databasemanagement.responses.ListProxiedForUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListProxyUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListRolesResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlPlanBaselineJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListSqlPlanBaselinesResponse;
import com.oracle.bmc.databasemanagement.responses.ListSystemPrivilegesResponse;
import com.oracle.bmc.databasemanagement.responses.ListTableStatisticsResponse;
import com.oracle.bmc.databasemanagement.responses.ListTablespacesResponse;
import com.oracle.bmc.databasemanagement.responses.ListUsersResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.databasemanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.databasemanagement.responses.LoadSqlPlanBaselinesFromAwrResponse;
import com.oracle.bmc.databasemanagement.responses.LoadSqlPlanBaselinesFromCursorCacheResponse;
import com.oracle.bmc.databasemanagement.responses.ModifyDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.ModifyPluggableDatabaseManagementFeatureResponse;
import com.oracle.bmc.databasemanagement.responses.PatchExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveDataFileResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.ResetDatabaseParametersResponse;
import com.oracle.bmc.databasemanagement.responses.ResizeDataFileResponse;
import com.oracle.bmc.databasemanagement.responses.RunHistoricAddmResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbCpuUsagesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbParameterChangesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbParametersResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbSnapshotRangesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbSysstatsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbTopWaitEventsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbWaitEventBucketsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAwrDbWaitEventsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeExternalAsmMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeExternalClusterMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeExternalDbNodeMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeExternalDbSystemAvailabilityMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeExternalListenerMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeJobExecutionsStatusesResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeManagedDatabaseAvailabilityMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeSqlPlanBaselinesByLastExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeSqlPlanBaselinesResponse;
import com.oracle.bmc.databasemanagement.responses.TestNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.TestPreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalAsmInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalAsmResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalClusterInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalClusterResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalDbHomeResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalDbNodeResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalDbSystemConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalDbSystemResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalExadataInfrastructureResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalExadataStorageConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalExadataStorageGridResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalExadataStorageServerResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateExternalListenerResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateJobResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateManagedDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.UpdatePreferredCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateTablespaceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbManagementAsyncClient
extends BaseAsyncClient
implements DbManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DbManagementAsyncClient.class);

    DbManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddDataFilesResponse> addDataFiles(AddDataFilesRequest request, AsyncHandler<AddDataFilesRequest, AddDataFilesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDataFilesDetails(), "addDataFilesDetails is required");
        return this.clientCall(request, AddDataFilesResponse::builder).logger(LOG, "addDataFiles").serviceDetails("DbManagement", "AddDataFiles", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/AddDataFiles").method(Method.POST).requestBuilder(AddDataFilesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("addDataFiles").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, AddDataFilesResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", AddDataFilesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AddManagedDatabaseToManagedDatabaseGroupResponse> addManagedDatabaseToManagedDatabaseGroup(AddManagedDatabaseToManagedDatabaseGroupRequest request, AsyncHandler<AddManagedDatabaseToManagedDatabaseGroupRequest, AddManagedDatabaseToManagedDatabaseGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddManagedDatabaseToManagedDatabaseGroupDetails(), "addManagedDatabaseToManagedDatabaseGroupDetails is required");
        return this.clientCall(request, AddManagedDatabaseToManagedDatabaseGroupResponse::builder).logger(LOG, "addManagedDatabaseToManagedDatabaseGroup").serviceDetails("DbManagement", "AddManagedDatabaseToManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/AddManagedDatabaseToManagedDatabaseGroup").method(Method.POST).requestBuilder(AddManagedDatabaseToManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("addManagedDatabase").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", AddManagedDatabaseToManagedDatabaseGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AddmTasksResponse> addmTasks(AddmTasksRequest request, AsyncHandler<AddmTasksRequest, AddmTasksResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTimeStart(), "timeStart is required");
        Objects.requireNonNull(request.getTimeEnd(), "timeEnd is required");
        return this.clientCall(request, AddmTasksResponse::builder).logger(LOG, "addmTasks").serviceDetails("DbManagement", "AddmTasks", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/AddmTasksCollection/AddmTasks").method(Method.GET).requestBuilder(AddmTasksRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("addmTasks").appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AddmTasksCollection.class, AddmTasksResponse.Builder::addmTasksCollection).handleResponseHeaderString("opc-request-id", AddmTasksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", AddmTasksResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ChangeDatabaseParametersResponse> changeDatabaseParameters(ChangeDatabaseParametersRequest request, AsyncHandler<ChangeDatabaseParametersRequest, ChangeDatabaseParametersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatabaseParametersDetails(), "changeDatabaseParametersDetails is required");
        return this.clientCall(request, ChangeDatabaseParametersResponse::builder).logger(LOG, "changeDatabaseParameters").serviceDetails("DbManagement", "ChangeDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ChangeDatabaseParameters").method(Method.POST).requestBuilder(ChangeDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("changeDatabaseParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UpdateDatabaseParametersResult.class, ChangeDatabaseParametersResponse.Builder::updateDatabaseParametersResult).handleResponseHeaderString("opc-request-id", ChangeDatabaseParametersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDbManagementPrivateEndpointCompartmentResponse> changeDbManagementPrivateEndpointCompartment(ChangeDbManagementPrivateEndpointCompartmentRequest request, AsyncHandler<ChangeDbManagementPrivateEndpointCompartmentRequest, ChangeDbManagementPrivateEndpointCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDbManagementPrivateEndpointCompartmentDetails(), "changeDbManagementPrivateEndpointCompartmentDetails is required");
        return this.clientCall(request, ChangeDbManagementPrivateEndpointCompartmentResponse::builder).logger(LOG, "changeDbManagementPrivateEndpointCompartment").serviceDetails("DbManagement", "ChangeDbManagementPrivateEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/ChangeDbManagementPrivateEndpointCompartment").method(Method.POST).requestBuilder(ChangeDbManagementPrivateEndpointCompartmentRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDbManagementPrivateEndpointCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeExternalDbSystemCompartmentResponse> changeExternalDbSystemCompartment(ChangeExternalDbSystemCompartmentRequest request, AsyncHandler<ChangeExternalDbSystemCompartmentRequest, ChangeExternalDbSystemCompartmentResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeExternalDbSystemCompartmentDetails(), "changeExternalDbSystemCompartmentDetails is required");
        return this.clientCall(request, ChangeExternalDbSystemCompartmentResponse::builder).logger(LOG, "changeExternalDbSystemCompartment").serviceDetails("DbManagement", "ChangeExternalDbSystemCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/ChangeExternalDbSystemCompartment").method(Method.POST).requestBuilder(ChangeExternalDbSystemCompartmentRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeExternalDbSystemCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeExternalDbSystemCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeExternalExadataInfrastructureCompartmentResponse> changeExternalExadataInfrastructureCompartment(ChangeExternalExadataInfrastructureCompartmentRequest request, AsyncHandler<ChangeExternalExadataInfrastructureCompartmentRequest, ChangeExternalExadataInfrastructureCompartmentResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeExternalExadataInfrastructureCompartmentDetails(), "changeExternalExadataInfrastructureCompartmentDetails is required");
        return this.clientCall(request, ChangeExternalExadataInfrastructureCompartmentResponse::builder).logger(LOG, "changeExternalExadataInfrastructureCompartment").serviceDetails("DbManagement", "ChangeExternalExadataInfrastructureCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/ChangeExternalExadataInfrastructureCompartment").method(Method.POST).requestBuilder(ChangeExternalExadataInfrastructureCompartmentRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeExternalExadataInfrastructureCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeExternalExadataInfrastructureCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeJobCompartmentResponse> changeJobCompartment(ChangeJobCompartmentRequest request, AsyncHandler<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeJobCompartmentDetails(), "changeJobCompartmentDetails is required");
        return this.clientCall(request, ChangeJobCompartmentResponse::builder).logger(LOG, "changeJobCompartment").serviceDetails("DbManagement", "ChangeJobCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/ChangeJobCompartment").method(Method.POST).requestBuilder(ChangeJobCompartmentRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeJobCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeManagedDatabaseGroupCompartmentResponse> changeManagedDatabaseGroupCompartment(ChangeManagedDatabaseGroupCompartmentRequest request, AsyncHandler<ChangeManagedDatabaseGroupCompartmentRequest, ChangeManagedDatabaseGroupCompartmentResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeManagedDatabaseGroupCompartmentDetails(), "changeManagedDatabaseGroupCompartmentDetails is required");
        return this.clientCall(request, ChangeManagedDatabaseGroupCompartmentResponse::builder).logger(LOG, "changeManagedDatabaseGroupCompartment").serviceDetails("DbManagement", "ChangeManagedDatabaseGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/ChangeManagedDatabaseGroupCompartment").method(Method.POST).requestBuilder(ChangeManagedDatabaseGroupCompartmentRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeManagedDatabaseGroupCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeNamedCredentialCompartmentResponse> changeNamedCredentialCompartment(ChangeNamedCredentialCompartmentRequest request, AsyncHandler<ChangeNamedCredentialCompartmentRequest, ChangeNamedCredentialCompartmentResponse> handler) {
        Validate.notBlank((String)request.getNamedCredentialId(), (String)"namedCredentialId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNamedCredentialCompartmentDetails(), "changeNamedCredentialCompartmentDetails is required");
        return this.clientCall(request, ChangeNamedCredentialCompartmentResponse::builder).logger(LOG, "changeNamedCredentialCompartment").serviceDetails("DbManagement", "ChangeNamedCredentialCompartment", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/ChangeNamedCredentialCompartment").method(Method.POST).requestBuilder(ChangeNamedCredentialCompartmentRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendPathParam(request.getNamedCredentialId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ChangeNamedCredentialCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangePlanRetentionResponse> changePlanRetention(ChangePlanRetentionRequest request, AsyncHandler<ChangePlanRetentionRequest, ChangePlanRetentionResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePlanRetentionDetails(), "changePlanRetentionDetails is required");
        return this.clientCall(request, ChangePlanRetentionResponse::builder).logger(LOG, "changePlanRetention").serviceDetails("DbManagement", "ChangePlanRetention", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ChangePlanRetention").method(Method.POST).requestBuilder(ChangePlanRetentionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("changePlanRetention").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangePlanRetentionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSpaceBudgetResponse> changeSpaceBudget(ChangeSpaceBudgetRequest request, AsyncHandler<ChangeSpaceBudgetRequest, ChangeSpaceBudgetResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSpaceBudgetDetails(), "changeSpaceBudgetDetails is required");
        return this.clientCall(request, ChangeSpaceBudgetResponse::builder).logger(LOG, "changeSpaceBudget").serviceDetails("DbManagement", "ChangeSpaceBudget", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ChangeSpaceBudget").method(Method.POST).requestBuilder(ChangeSpaceBudgetRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("changeSpaceBudget").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSpaceBudgetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeSqlPlanBaselinesAttributesResponse> changeSqlPlanBaselinesAttributes(ChangeSqlPlanBaselinesAttributesRequest request, AsyncHandler<ChangeSqlPlanBaselinesAttributesRequest, ChangeSqlPlanBaselinesAttributesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSqlPlanBaselinesAttributesDetails(), "changeSqlPlanBaselinesAttributesDetails is required");
        return this.clientCall(request, ChangeSqlPlanBaselinesAttributesResponse::builder).logger(LOG, "changeSqlPlanBaselinesAttributes").serviceDetails("DbManagement", "ChangeSqlPlanBaselinesAttributes", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ChangeSqlPlanBaselinesAttributes").method(Method.POST).requestBuilder(ChangeSqlPlanBaselinesAttributesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("changeSqlPlanBaselinesAttributes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeSqlPlanBaselinesAttributesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CheckExternalDbSystemConnectorConnectionStatusResponse> checkExternalDbSystemConnectorConnectionStatus(CheckExternalDbSystemConnectorConnectionStatusRequest request, AsyncHandler<CheckExternalDbSystemConnectorConnectionStatusRequest, CheckExternalDbSystemConnectorConnectionStatusResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemConnectorId(), (String)"externalDbSystemConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CheckExternalDbSystemConnectorConnectionStatusResponse::builder).logger(LOG, "checkExternalDbSystemConnectorConnectionStatus").serviceDetails("DbManagement", "CheckExternalDbSystemConnectorConnectionStatus", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/CheckExternalDbSystemConnectorConnectionStatus").method(Method.POST).requestBuilder(CheckExternalDbSystemConnectorConnectionStatusRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").appendPathParam(request.getExternalDbSystemConnectorId()).appendPathParam("actions").appendPathParam("checkConnectionStatus").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(ExternalDbSystemConnector.class, CheckExternalDbSystemConnectorConnectionStatusResponse.Builder::externalDbSystemConnector).handleResponseHeaderString("opc-request-id", CheckExternalDbSystemConnectorConnectionStatusResponse.Builder::opcRequestId).handleResponseHeaderString("content-location", CheckExternalDbSystemConnectorConnectionStatusResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<CheckExternalExadataStorageConnectorResponse> checkExternalExadataStorageConnector(CheckExternalExadataStorageConnectorRequest request, AsyncHandler<CheckExternalExadataStorageConnectorRequest, CheckExternalExadataStorageConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageConnectorId(), (String)"externalExadataStorageConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CheckExternalExadataStorageConnectorResponse::builder).logger(LOG, "checkExternalExadataStorageConnector").serviceDetails("DbManagement", "CheckExternalExadataStorageConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/CheckExternalExadataStorageConnector").method(Method.POST).requestBuilder(CheckExternalExadataStorageConnectorRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").appendPathParam(request.getExternalExadataStorageConnectorId()).appendPathParam("actions").appendPathParam("checkStatus").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(ExternalExadataStorageConnectorStatus.class, CheckExternalExadataStorageConnectorResponse.Builder::externalExadataStorageConnectorStatus).handleResponseHeaderString("etag", CheckExternalExadataStorageConnectorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CheckExternalExadataStorageConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ConfigureAutomaticCaptureFiltersResponse> configureAutomaticCaptureFilters(ConfigureAutomaticCaptureFiltersRequest request, AsyncHandler<ConfigureAutomaticCaptureFiltersRequest, ConfigureAutomaticCaptureFiltersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConfigureAutomaticCaptureFiltersDetails(), "configureAutomaticCaptureFiltersDetails is required");
        return this.clientCall(request, ConfigureAutomaticCaptureFiltersResponse::builder).logger(LOG, "configureAutomaticCaptureFilters").serviceDetails("DbManagement", "ConfigureAutomaticCaptureFilters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ConfigureAutomaticCaptureFilters").method(Method.POST).requestBuilder(ConfigureAutomaticCaptureFiltersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("configureAutomaticCaptureFilters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ConfigureAutomaticCaptureFiltersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ConfigureAutomaticSpmEvolveAdvisorTaskResponse> configureAutomaticSpmEvolveAdvisorTask(ConfigureAutomaticSpmEvolveAdvisorTaskRequest request, AsyncHandler<ConfigureAutomaticSpmEvolveAdvisorTaskRequest, ConfigureAutomaticSpmEvolveAdvisorTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getConfigureAutomaticSpmEvolveAdvisorTaskDetails(), "configureAutomaticSpmEvolveAdvisorTaskDetails is required");
        return this.clientCall(request, ConfigureAutomaticSpmEvolveAdvisorTaskResponse::builder).logger(LOG, "configureAutomaticSpmEvolveAdvisorTask").serviceDetails("DbManagement", "ConfigureAutomaticSpmEvolveAdvisorTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ConfigureAutomaticSpmEvolveAdvisorTask").method(Method.POST).requestBuilder(ConfigureAutomaticSpmEvolveAdvisorTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("configureAutomaticSpmEvolveAdvisorTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ConfigureAutomaticSpmEvolveAdvisorTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDbManagementPrivateEndpointResponse> createDbManagementPrivateEndpoint(CreateDbManagementPrivateEndpointRequest request, AsyncHandler<CreateDbManagementPrivateEndpointRequest, CreateDbManagementPrivateEndpointResponse> handler) {
        Objects.requireNonNull(request.getCreateDbManagementPrivateEndpointDetails(), "createDbManagementPrivateEndpointDetails is required");
        return this.clientCall(request, CreateDbManagementPrivateEndpointResponse::builder).logger(LOG, "createDbManagementPrivateEndpoint").serviceDetails("DbManagement", "CreateDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/CreateDbManagementPrivateEndpoint").method(Method.POST).requestBuilder(CreateDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DbManagementPrivateEndpoint.class, CreateDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("etag", CreateDbManagementPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDbManagementPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDbManagementPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateDbManagementPrivateEndpointResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateExternalDbSystemResponse> createExternalDbSystem(CreateExternalDbSystemRequest request, AsyncHandler<CreateExternalDbSystemRequest, CreateExternalDbSystemResponse> handler) {
        Objects.requireNonNull(request.getCreateExternalDbSystemDetails(), "createExternalDbSystemDetails is required");
        return this.clientCall(request, CreateExternalDbSystemResponse::builder).logger(LOG, "createExternalDbSystem").serviceDetails("DbManagement", "CreateExternalDbSystem", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/CreateExternalDbSystem").method(Method.POST).requestBuilder(CreateExternalDbSystemRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalDbSystem.class, CreateExternalDbSystemResponse.Builder::externalDbSystem).handleResponseHeaderString("etag", CreateExternalDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExternalDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateExternalDbSystemResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateExternalDbSystemResponse.Builder::location).handleResponseHeaderString("content-location", CreateExternalDbSystemResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<CreateExternalDbSystemConnectorResponse> createExternalDbSystemConnector(CreateExternalDbSystemConnectorRequest request, AsyncHandler<CreateExternalDbSystemConnectorRequest, CreateExternalDbSystemConnectorResponse> handler) {
        Objects.requireNonNull(request.getCreateExternalDbSystemConnectorDetails(), "createExternalDbSystemConnectorDetails is required");
        return this.clientCall(request, CreateExternalDbSystemConnectorResponse::builder).logger(LOG, "createExternalDbSystemConnector").serviceDetails("DbManagement", "CreateExternalDbSystemConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/CreateExternalDbSystemConnector").method(Method.POST).requestBuilder(CreateExternalDbSystemConnectorRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalDbSystemConnector.class, CreateExternalDbSystemConnectorResponse.Builder::externalDbSystemConnector).handleResponseHeaderString("opc-request-id", CreateExternalDbSystemConnectorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateExternalDbSystemConnectorResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateExternalDbSystemDiscoveryResponse> createExternalDbSystemDiscovery(CreateExternalDbSystemDiscoveryRequest request, AsyncHandler<CreateExternalDbSystemDiscoveryRequest, CreateExternalDbSystemDiscoveryResponse> handler) {
        Objects.requireNonNull(request.getCreateExternalDbSystemDiscoveryDetails(), "createExternalDbSystemDiscoveryDetails is required");
        return this.clientCall(request, CreateExternalDbSystemDiscoveryResponse::builder).logger(LOG, "createExternalDbSystemDiscovery").serviceDetails("DbManagement", "CreateExternalDbSystemDiscovery", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/CreateExternalDbSystemDiscovery").method(Method.POST).requestBuilder(CreateExternalDbSystemDiscoveryRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalDbSystemDiscovery.class, CreateExternalDbSystemDiscoveryResponse.Builder::externalDbSystemDiscovery).handleResponseHeaderString("etag", CreateExternalDbSystemDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateExternalDbSystemDiscoveryResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateExternalDbSystemDiscoveryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateExternalDbSystemDiscoveryResponse.Builder::location).handleResponseHeaderString("content-location", CreateExternalDbSystemDiscoveryResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<CreateExternalExadataInfrastructureResponse> createExternalExadataInfrastructure(CreateExternalExadataInfrastructureRequest request, AsyncHandler<CreateExternalExadataInfrastructureRequest, CreateExternalExadataInfrastructureResponse> handler) {
        Objects.requireNonNull(request.getCreateExternalExadataInfrastructureDetails(), "createExternalExadataInfrastructureDetails is required");
        return this.clientCall(request, CreateExternalExadataInfrastructureResponse::builder).logger(LOG, "createExternalExadataInfrastructure").serviceDetails("DbManagement", "CreateExternalExadataInfrastructure", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/CreateExternalExadataInfrastructure").method(Method.POST).requestBuilder(CreateExternalExadataInfrastructureRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalExadataInfrastructure.class, CreateExternalExadataInfrastructureResponse.Builder::externalExadataInfrastructure).handleResponseHeaderString("opc-request-id", CreateExternalExadataInfrastructureResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateExternalExadataInfrastructureResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateExternalExadataStorageConnectorResponse> createExternalExadataStorageConnector(CreateExternalExadataStorageConnectorRequest request, AsyncHandler<CreateExternalExadataStorageConnectorRequest, CreateExternalExadataStorageConnectorResponse> handler) {
        Objects.requireNonNull(request.getCreateExternalExadataStorageConnectorDetails(), "createExternalExadataStorageConnectorDetails is required");
        return this.clientCall(request, CreateExternalExadataStorageConnectorResponse::builder).logger(LOG, "createExternalExadataStorageConnector").serviceDetails("DbManagement", "CreateExternalExadataStorageConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/CreateExternalExadataStorageConnector").method(Method.POST).requestBuilder(CreateExternalExadataStorageConnectorRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalExadataStorageConnector.class, CreateExternalExadataStorageConnectorResponse.Builder::externalExadataStorageConnector).handleResponseHeaderString("opc-request-id", CreateExternalExadataStorageConnectorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateExternalExadataStorageConnectorResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        Objects.requireNonNull(request.getCreateJobDetails(), "createJobDetails is required");
        return this.clientCall(request, CreateJobResponse::builder).logger(LOG, "createJob").serviceDetails("DbManagement", "CreateJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/CreateJob").method(Method.POST).requestBuilder(CreateJobRequest::builder).basePath("/20201101").appendPathParam("jobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Job.class, CreateJobResponse.Builder::job).handleResponseHeaderString("location", CreateJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateManagedDatabaseGroupResponse> createManagedDatabaseGroup(CreateManagedDatabaseGroupRequest request, AsyncHandler<CreateManagedDatabaseGroupRequest, CreateManagedDatabaseGroupResponse> handler) {
        Objects.requireNonNull(request.getCreateManagedDatabaseGroupDetails(), "createManagedDatabaseGroupDetails is required");
        return this.clientCall(request, CreateManagedDatabaseGroupResponse::builder).logger(LOG, "createManagedDatabaseGroup").serviceDetails("DbManagement", "CreateManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/CreateManagedDatabaseGroup").method(Method.POST).requestBuilder(CreateManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ManagedDatabaseGroup.class, CreateManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("location", CreateManagedDatabaseGroupResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateManagedDatabaseGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateNamedCredentialResponse> createNamedCredential(CreateNamedCredentialRequest request, AsyncHandler<CreateNamedCredentialRequest, CreateNamedCredentialResponse> handler) {
        Objects.requireNonNull(request.getCreateNamedCredentialDetails(), "createNamedCredentialDetails is required");
        return this.clientCall(request, CreateNamedCredentialResponse::builder).logger(LOG, "createNamedCredential").serviceDetails("DbManagement", "CreateNamedCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/CreateNamedCredential").method(Method.POST).requestBuilder(CreateNamedCredentialRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NamedCredential.class, CreateNamedCredentialResponse.Builder::namedCredential).handleResponseHeaderString("opc-request-id", CreateNamedCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateNamedCredentialResponse.Builder::etag).handleResponseHeaderString("location", CreateNamedCredentialResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateTablespaceResponse> createTablespace(CreateTablespaceRequest request, AsyncHandler<CreateTablespaceRequest, CreateTablespaceResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateTablespaceDetails(), "createTablespaceDetails is required");
        return this.clientCall(request, CreateTablespaceResponse::builder).logger(LOG, "createTablespace").serviceDetails("DbManagement", "CreateTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/CreateTablespace").method(Method.POST).requestBuilder(CreateTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Tablespace.class, CreateTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", CreateTablespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDbManagementPrivateEndpointResponse> deleteDbManagementPrivateEndpoint(DeleteDbManagementPrivateEndpointRequest request, AsyncHandler<DeleteDbManagementPrivateEndpointRequest, DeleteDbManagementPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDbManagementPrivateEndpointResponse::builder).logger(LOG, "deleteDbManagementPrivateEndpoint").serviceDetails("DbManagement", "DeleteDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/DeleteDbManagementPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteDbManagementPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDbManagementPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalDbSystemResponse> deleteExternalDbSystem(DeleteExternalDbSystemRequest request, AsyncHandler<DeleteExternalDbSystemRequest, DeleteExternalDbSystemResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalDbSystemResponse::builder).logger(LOG, "deleteExternalDbSystem").serviceDetails("DbManagement", "DeleteExternalDbSystem", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/DeleteExternalDbSystem").method(Method.DELETE).requestBuilder(DeleteExternalDbSystemRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteExternalDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteExternalDbSystemResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalDbSystemConnectorResponse> deleteExternalDbSystemConnector(DeleteExternalDbSystemConnectorRequest request, AsyncHandler<DeleteExternalDbSystemConnectorRequest, DeleteExternalDbSystemConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemConnectorId(), (String)"externalDbSystemConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalDbSystemConnectorResponse::builder).logger(LOG, "deleteExternalDbSystemConnector").serviceDetails("DbManagement", "DeleteExternalDbSystemConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/DeleteExternalDbSystemConnector").method(Method.DELETE).requestBuilder(DeleteExternalDbSystemConnectorRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").appendPathParam(request.getExternalDbSystemConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteExternalDbSystemConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalDbSystemDiscoveryResponse> deleteExternalDbSystemDiscovery(DeleteExternalDbSystemDiscoveryRequest request, AsyncHandler<DeleteExternalDbSystemDiscoveryRequest, DeleteExternalDbSystemDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemDiscoveryId(), (String)"externalDbSystemDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalDbSystemDiscoveryResponse::builder).logger(LOG, "deleteExternalDbSystemDiscovery").serviceDetails("DbManagement", "DeleteExternalDbSystemDiscovery", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/DeleteExternalDbSystemDiscovery").method(Method.DELETE).requestBuilder(DeleteExternalDbSystemDiscoveryRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").appendPathParam(request.getExternalDbSystemDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteExternalDbSystemDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalExadataInfrastructureResponse> deleteExternalExadataInfrastructure(DeleteExternalExadataInfrastructureRequest request, AsyncHandler<DeleteExternalExadataInfrastructureRequest, DeleteExternalExadataInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalExadataInfrastructureResponse::builder).logger(LOG, "deleteExternalExadataInfrastructure").serviceDetails("DbManagement", "DeleteExternalExadataInfrastructure", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/DeleteExternalExadataInfrastructure").method(Method.DELETE).requestBuilder(DeleteExternalExadataInfrastructureRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteExternalExadataInfrastructureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteExternalExadataInfrastructureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteExternalExadataStorageConnectorResponse> deleteExternalExadataStorageConnector(DeleteExternalExadataStorageConnectorRequest request, AsyncHandler<DeleteExternalExadataStorageConnectorRequest, DeleteExternalExadataStorageConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageConnectorId(), (String)"externalExadataStorageConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteExternalExadataStorageConnectorResponse::builder).logger(LOG, "deleteExternalExadataStorageConnector").serviceDetails("DbManagement", "DeleteExternalExadataStorageConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/DeleteExternalExadataStorageConnector").method(Method.DELETE).requestBuilder(DeleteExternalExadataStorageConnectorRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").appendPathParam(request.getExternalExadataStorageConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteExternalExadataStorageConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteJobResponse> deleteJob(DeleteJobRequest request, AsyncHandler<DeleteJobRequest, DeleteJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DbManagement", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteManagedDatabaseGroupResponse> deleteManagedDatabaseGroup(DeleteManagedDatabaseGroupRequest request, AsyncHandler<DeleteManagedDatabaseGroupRequest, DeleteManagedDatabaseGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteManagedDatabaseGroupResponse::builder).logger(LOG, "deleteManagedDatabaseGroup").serviceDetails("DbManagement", "DeleteManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/DeleteManagedDatabaseGroup").method(Method.DELETE).requestBuilder(DeleteManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteManagedDatabaseGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNamedCredentialResponse> deleteNamedCredential(DeleteNamedCredentialRequest request, AsyncHandler<DeleteNamedCredentialRequest, DeleteNamedCredentialResponse> handler) {
        Validate.notBlank((String)request.getNamedCredentialId(), (String)"namedCredentialId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNamedCredentialResponse::builder).logger(LOG, "deleteNamedCredential").serviceDetails("DbManagement", "DeleteNamedCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/DeleteNamedCredential").method(Method.DELETE).requestBuilder(DeleteNamedCredentialRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendPathParam(request.getNamedCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteNamedCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePreferredCredentialResponse> deletePreferredCredential(DeletePreferredCredentialRequest request, AsyncHandler<DeletePreferredCredentialRequest, DeletePreferredCredentialResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePreferredCredentialResponse::builder).logger(LOG, "deletePreferredCredential").serviceDetails("DbManagement", "DeletePreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/DeletePreferredCredential").method(Method.DELETE).requestBuilder(DeletePreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeletePreferredCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableAutomaticInitialPlanCaptureResponse> disableAutomaticInitialPlanCapture(DisableAutomaticInitialPlanCaptureRequest request, AsyncHandler<DisableAutomaticInitialPlanCaptureRequest, DisableAutomaticInitialPlanCaptureResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableAutomaticInitialPlanCaptureDetails(), "disableAutomaticInitialPlanCaptureDetails is required");
        return this.clientCall(request, DisableAutomaticInitialPlanCaptureResponse::builder).logger(LOG, "disableAutomaticInitialPlanCapture").serviceDetails("DbManagement", "DisableAutomaticInitialPlanCapture", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableAutomaticInitialPlanCapture").method(Method.POST).requestBuilder(DisableAutomaticInitialPlanCaptureRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("disableAutomaticInitialPlanCapture").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DisableAutomaticInitialPlanCaptureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableAutomaticSpmEvolveAdvisorTaskResponse> disableAutomaticSpmEvolveAdvisorTask(DisableAutomaticSpmEvolveAdvisorTaskRequest request, AsyncHandler<DisableAutomaticSpmEvolveAdvisorTaskRequest, DisableAutomaticSpmEvolveAdvisorTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableAutomaticSpmEvolveAdvisorTaskDetails(), "disableAutomaticSpmEvolveAdvisorTaskDetails is required");
        return this.clientCall(request, DisableAutomaticSpmEvolveAdvisorTaskResponse::builder).logger(LOG, "disableAutomaticSpmEvolveAdvisorTask").serviceDetails("DbManagement", "DisableAutomaticSpmEvolveAdvisorTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableAutomaticSpmEvolveAdvisorTask").method(Method.POST).requestBuilder(DisableAutomaticSpmEvolveAdvisorTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("disableAutomaticSpmEvolveAdvisorTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DisableAutomaticSpmEvolveAdvisorTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableDatabaseManagementFeatureResponse> disableDatabaseManagementFeature(DisableDatabaseManagementFeatureRequest request, AsyncHandler<DisableDatabaseManagementFeatureRequest, DisableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getDatabaseId(), (String)"databaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableDatabaseManagementFeatureDetails(), "disableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, DisableDatabaseManagementFeatureResponse::builder).logger(LOG, "disableDatabaseManagementFeature").serviceDetails("DbManagement", "DisableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableDatabaseManagementFeature").method(Method.POST).requestBuilder(DisableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("databases").appendPathParam(request.getDatabaseId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalContainerDatabaseManagementFeatureResponse> disableExternalContainerDatabaseManagementFeature(DisableExternalContainerDatabaseManagementFeatureRequest request, AsyncHandler<DisableExternalContainerDatabaseManagementFeatureRequest, DisableExternalContainerDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalContainerDatabaseId(), (String)"externalContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableExternalContainerDatabaseManagementFeatureDetails(), "disableExternalContainerDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, DisableExternalContainerDatabaseManagementFeatureResponse::builder).logger(LOG, "disableExternalContainerDatabaseManagementFeature").serviceDetails("DbManagement", "DisableExternalContainerDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableExternalContainerDatabaseManagementFeature").method(Method.POST).requestBuilder(DisableExternalContainerDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalcontainerdatabases").appendPathParam(request.getExternalContainerDatabaseId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisableExternalContainerDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalContainerDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalDbSystemDatabaseManagementResponse> disableExternalDbSystemDatabaseManagement(DisableExternalDbSystemDatabaseManagementRequest request, AsyncHandler<DisableExternalDbSystemDatabaseManagementRequest, DisableExternalDbSystemDatabaseManagementResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DisableExternalDbSystemDatabaseManagementResponse::builder).logger(LOG, "disableExternalDbSystemDatabaseManagement").serviceDetails("DbManagement", "DisableExternalDbSystemDatabaseManagement", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/DisableExternalDbSystemDatabaseManagement").method(Method.POST).requestBuilder(DisableExternalDbSystemDatabaseManagementRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DisableExternalDbSystemDatabaseManagementResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalDbSystemDatabaseManagementResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalDbSystemStackMonitoringResponse> disableExternalDbSystemStackMonitoring(DisableExternalDbSystemStackMonitoringRequest request, AsyncHandler<DisableExternalDbSystemStackMonitoringRequest, DisableExternalDbSystemStackMonitoringResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DisableExternalDbSystemStackMonitoringResponse::builder).logger(LOG, "disableExternalDbSystemStackMonitoring").serviceDetails("DbManagement", "DisableExternalDbSystemStackMonitoring", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/DisableExternalDbSystemStackMonitoring").method(Method.POST).requestBuilder(DisableExternalDbSystemStackMonitoringRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("actions").appendPathParam("disableStackMonitoring").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DisableExternalDbSystemStackMonitoringResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalDbSystemStackMonitoringResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalExadataInfrastructureManagementResponse> disableExternalExadataInfrastructureManagement(DisableExternalExadataInfrastructureManagementRequest request, AsyncHandler<DisableExternalExadataInfrastructureManagementRequest, DisableExternalExadataInfrastructureManagementResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DisableExternalExadataInfrastructureManagementResponse::builder).logger(LOG, "disableExternalExadataInfrastructureManagement").serviceDetails("DbManagement", "DisableExternalExadataInfrastructureManagement", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/DisableExternalExadataInfrastructureManagement").method(Method.POST).requestBuilder(DisableExternalExadataInfrastructureManagementRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DisableExternalExadataInfrastructureManagementResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalExadataInfrastructureManagementResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalNonContainerDatabaseManagementFeatureResponse> disableExternalNonContainerDatabaseManagementFeature(DisableExternalNonContainerDatabaseManagementFeatureRequest request, AsyncHandler<DisableExternalNonContainerDatabaseManagementFeatureRequest, DisableExternalNonContainerDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalNonContainerDatabaseId(), (String)"externalNonContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableExternalNonContainerDatabaseManagementFeatureDetails(), "disableExternalNonContainerDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, DisableExternalNonContainerDatabaseManagementFeatureResponse::builder).logger(LOG, "disableExternalNonContainerDatabaseManagementFeature").serviceDetails("DbManagement", "DisableExternalNonContainerDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableExternalNonContainerDatabaseManagementFeature").method(Method.POST).requestBuilder(DisableExternalNonContainerDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalnoncontainerdatabases").appendPathParam(request.getExternalNonContainerDatabaseId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisableExternalNonContainerDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalNonContainerDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableExternalPluggableDatabaseManagementFeatureResponse> disableExternalPluggableDatabaseManagementFeature(DisableExternalPluggableDatabaseManagementFeatureRequest request, AsyncHandler<DisableExternalPluggableDatabaseManagementFeatureRequest, DisableExternalPluggableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalPluggableDatabaseId(), (String)"externalPluggableDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableExternalPluggableDatabaseManagementFeatureDetails(), "disableExternalPluggableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, DisableExternalPluggableDatabaseManagementFeatureResponse::builder).logger(LOG, "disableExternalPluggableDatabaseManagementFeature").serviceDetails("DbManagement", "DisableExternalPluggableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableExternalPluggableDatabaseManagementFeature").method(Method.POST).requestBuilder(DisableExternalPluggableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalpluggabledatabases").appendPathParam(request.getExternalPluggableDatabaseId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisableExternalPluggableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisableExternalPluggableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse> disableHighFrequencyAutomaticSpmEvolveAdvisorTask(DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest request, AsyncHandler<DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest, DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableHighFrequencyAutomaticSpmEvolveAdvisorTaskDetails(), "disableHighFrequencyAutomaticSpmEvolveAdvisorTaskDetails is required");
        return this.clientCall(request, DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse::builder).logger(LOG, "disableHighFrequencyAutomaticSpmEvolveAdvisorTask").serviceDetails("DbManagement", "DisableHighFrequencyAutomaticSpmEvolveAdvisorTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableHighFrequencyAutomaticSpmEvolveAdvisorTask").method(Method.POST).requestBuilder(DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("disableHighFrequencyAutomaticSpmEvolveAdvisorTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DisableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisablePluggableDatabaseManagementFeatureResponse> disablePluggableDatabaseManagementFeature(DisablePluggableDatabaseManagementFeatureRequest request, AsyncHandler<DisablePluggableDatabaseManagementFeatureRequest, DisablePluggableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getPluggableDatabaseId(), (String)"pluggableDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisablePluggableDatabaseManagementFeatureDetails(), "disablePluggableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, DisablePluggableDatabaseManagementFeatureResponse::builder).logger(LOG, "disablePluggableDatabaseManagementFeature").serviceDetails("DbManagement", "DisablePluggableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisablePluggableDatabaseManagementFeature").method(Method.POST).requestBuilder(DisablePluggableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("pluggabledatabases").appendPathParam(request.getPluggableDatabaseId()).appendPathParam("actions").appendPathParam("disableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", DisablePluggableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DisablePluggableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableSqlPlanBaselinesUsageResponse> disableSqlPlanBaselinesUsage(DisableSqlPlanBaselinesUsageRequest request, AsyncHandler<DisableSqlPlanBaselinesUsageRequest, DisableSqlPlanBaselinesUsageResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableSqlPlanBaselinesUsageDetails(), "disableSqlPlanBaselinesUsageDetails is required");
        return this.clientCall(request, DisableSqlPlanBaselinesUsageResponse::builder).logger(LOG, "disableSqlPlanBaselinesUsage").serviceDetails("DbManagement", "DisableSqlPlanBaselinesUsage", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DisableSqlPlanBaselinesUsage").method(Method.POST).requestBuilder(DisableSqlPlanBaselinesUsageRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("disableSqlPlanBaselinesUsage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DisableSqlPlanBaselinesUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DiscoverExternalExadataInfrastructureResponse> discoverExternalExadataInfrastructure(DiscoverExternalExadataInfrastructureRequest request, AsyncHandler<DiscoverExternalExadataInfrastructureRequest, DiscoverExternalExadataInfrastructureResponse> handler) {
        Objects.requireNonNull(request.getDiscoverExternalExadataInfrastructureDetails(), "discoverExternalExadataInfrastructureDetails is required");
        return this.clientCall(request, DiscoverExternalExadataInfrastructureResponse::builder).logger(LOG, "discoverExternalExadataInfrastructure").serviceDetails("DbManagement", "DiscoverExternalExadataInfrastructure", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/DiscoverExternalExadataInfrastructure").method(Method.POST).requestBuilder(DiscoverExternalExadataInfrastructureRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam("actions").appendPathParam("discoverExadataInfrastructure").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalExadataInfrastructureDiscovery.class, DiscoverExternalExadataInfrastructureResponse.Builder::externalExadataInfrastructureDiscovery).handleResponseHeaderString("etag", DiscoverExternalExadataInfrastructureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DiscoverExternalExadataInfrastructureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DropSqlPlanBaselinesResponse> dropSqlPlanBaselines(DropSqlPlanBaselinesRequest request, AsyncHandler<DropSqlPlanBaselinesRequest, DropSqlPlanBaselinesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropSqlPlanBaselinesDetails(), "dropSqlPlanBaselinesDetails is required");
        return this.clientCall(request, DropSqlPlanBaselinesResponse::builder).logger(LOG, "dropSqlPlanBaselines").serviceDetails("DbManagement", "DropSqlPlanBaselines", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/DropSqlPlanBaselines").method(Method.POST).requestBuilder(DropSqlPlanBaselinesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("dropSqlPlanBaselines").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", DropSqlPlanBaselinesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DropTablespaceResponse> dropTablespace(DropTablespaceRequest request, AsyncHandler<DropTablespaceRequest, DropTablespaceResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDropTablespaceDetails(), "dropTablespaceDetails is required");
        return this.clientCall(request, DropTablespaceResponse::builder).logger(LOG, "dropTablespace").serviceDetails("DbManagement", "DropTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/DropTablespace").method(Method.POST).requestBuilder(DropTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("dropTablespace").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, DropTablespaceResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", DropTablespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableAutomaticInitialPlanCaptureResponse> enableAutomaticInitialPlanCapture(EnableAutomaticInitialPlanCaptureRequest request, AsyncHandler<EnableAutomaticInitialPlanCaptureRequest, EnableAutomaticInitialPlanCaptureResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableAutomaticInitialPlanCaptureDetails(), "enableAutomaticInitialPlanCaptureDetails is required");
        return this.clientCall(request, EnableAutomaticInitialPlanCaptureResponse::builder).logger(LOG, "enableAutomaticInitialPlanCapture").serviceDetails("DbManagement", "EnableAutomaticInitialPlanCapture", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableAutomaticInitialPlanCapture").method(Method.POST).requestBuilder(EnableAutomaticInitialPlanCaptureRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("enableAutomaticInitialPlanCapture").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", EnableAutomaticInitialPlanCaptureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableAutomaticSpmEvolveAdvisorTaskResponse> enableAutomaticSpmEvolveAdvisorTask(EnableAutomaticSpmEvolveAdvisorTaskRequest request, AsyncHandler<EnableAutomaticSpmEvolveAdvisorTaskRequest, EnableAutomaticSpmEvolveAdvisorTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableAutomaticSpmEvolveAdvisorTaskDetails(), "enableAutomaticSpmEvolveAdvisorTaskDetails is required");
        return this.clientCall(request, EnableAutomaticSpmEvolveAdvisorTaskResponse::builder).logger(LOG, "enableAutomaticSpmEvolveAdvisorTask").serviceDetails("DbManagement", "EnableAutomaticSpmEvolveAdvisorTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableAutomaticSpmEvolveAdvisorTask").method(Method.POST).requestBuilder(EnableAutomaticSpmEvolveAdvisorTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("enableAutomaticSpmEvolveAdvisorTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", EnableAutomaticSpmEvolveAdvisorTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableDatabaseManagementFeatureResponse> enableDatabaseManagementFeature(EnableDatabaseManagementFeatureRequest request, AsyncHandler<EnableDatabaseManagementFeatureRequest, EnableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getDatabaseId(), (String)"databaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableDatabaseManagementFeatureDetails(), "enableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, EnableDatabaseManagementFeatureResponse::builder).logger(LOG, "enableDatabaseManagementFeature").serviceDetails("DbManagement", "EnableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableDatabaseManagementFeature").method(Method.POST).requestBuilder(EnableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("databases").appendPathParam(request.getDatabaseId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalContainerDatabaseManagementFeatureResponse> enableExternalContainerDatabaseManagementFeature(EnableExternalContainerDatabaseManagementFeatureRequest request, AsyncHandler<EnableExternalContainerDatabaseManagementFeatureRequest, EnableExternalContainerDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalContainerDatabaseId(), (String)"externalContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalContainerDatabaseManagementFeatureDetails(), "enableExternalContainerDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, EnableExternalContainerDatabaseManagementFeatureResponse::builder).logger(LOG, "enableExternalContainerDatabaseManagementFeature").serviceDetails("DbManagement", "EnableExternalContainerDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableExternalContainerDatabaseManagementFeature").method(Method.POST).requestBuilder(EnableExternalContainerDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalcontainerdatabases").appendPathParam(request.getExternalContainerDatabaseId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalContainerDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalContainerDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalDbSystemDatabaseManagementResponse> enableExternalDbSystemDatabaseManagement(EnableExternalDbSystemDatabaseManagementRequest request, AsyncHandler<EnableExternalDbSystemDatabaseManagementRequest, EnableExternalDbSystemDatabaseManagementResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalDbSystemDatabaseManagementDetails(), "enableExternalDbSystemDatabaseManagementDetails is required");
        return this.clientCall(request, EnableExternalDbSystemDatabaseManagementResponse::builder).logger(LOG, "enableExternalDbSystemDatabaseManagement").serviceDetails("DbManagement", "EnableExternalDbSystemDatabaseManagement", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/EnableExternalDbSystemDatabaseManagement").method(Method.POST).requestBuilder(EnableExternalDbSystemDatabaseManagementRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalDbSystemDatabaseManagementResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalDbSystemDatabaseManagementResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalDbSystemStackMonitoringResponse> enableExternalDbSystemStackMonitoring(EnableExternalDbSystemStackMonitoringRequest request, AsyncHandler<EnableExternalDbSystemStackMonitoringRequest, EnableExternalDbSystemStackMonitoringResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalDbSystemStackMonitoringDetails(), "enableExternalDbSystemStackMonitoringDetails is required");
        return this.clientCall(request, EnableExternalDbSystemStackMonitoringResponse::builder).logger(LOG, "enableExternalDbSystemStackMonitoring").serviceDetails("DbManagement", "EnableExternalDbSystemStackMonitoring", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/EnableExternalDbSystemStackMonitoring").method(Method.POST).requestBuilder(EnableExternalDbSystemStackMonitoringRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("actions").appendPathParam("enableStackMonitoring").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalDbSystemStackMonitoringResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalDbSystemStackMonitoringResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalExadataInfrastructureManagementResponse> enableExternalExadataInfrastructureManagement(EnableExternalExadataInfrastructureManagementRequest request, AsyncHandler<EnableExternalExadataInfrastructureManagementRequest, EnableExternalExadataInfrastructureManagementResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalExadataInfrastructureManagementDetails(), "enableExternalExadataInfrastructureManagementDetails is required");
        return this.clientCall(request, EnableExternalExadataInfrastructureManagementResponse::builder).logger(LOG, "enableExternalExadataInfrastructureManagement").serviceDetails("DbManagement", "EnableExternalExadataInfrastructureManagement", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/EnableExternalExadataInfrastructureManagement").method(Method.POST).requestBuilder(EnableExternalExadataInfrastructureManagementRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalExadataInfrastructureManagementResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalExadataInfrastructureManagementResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalNonContainerDatabaseManagementFeatureResponse> enableExternalNonContainerDatabaseManagementFeature(EnableExternalNonContainerDatabaseManagementFeatureRequest request, AsyncHandler<EnableExternalNonContainerDatabaseManagementFeatureRequest, EnableExternalNonContainerDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalNonContainerDatabaseId(), (String)"externalNonContainerDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalNonContainerDatabaseManagementFeatureDetails(), "enableExternalNonContainerDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, EnableExternalNonContainerDatabaseManagementFeatureResponse::builder).logger(LOG, "enableExternalNonContainerDatabaseManagementFeature").serviceDetails("DbManagement", "EnableExternalNonContainerDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableExternalNonContainerDatabaseManagementFeature").method(Method.POST).requestBuilder(EnableExternalNonContainerDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalnoncontainerdatabases").appendPathParam(request.getExternalNonContainerDatabaseId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalNonContainerDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalNonContainerDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableExternalPluggableDatabaseManagementFeatureResponse> enableExternalPluggableDatabaseManagementFeature(EnableExternalPluggableDatabaseManagementFeatureRequest request, AsyncHandler<EnableExternalPluggableDatabaseManagementFeatureRequest, EnableExternalPluggableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getExternalPluggableDatabaseId(), (String)"externalPluggableDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableExternalPluggableDatabaseManagementFeatureDetails(), "enableExternalPluggableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, EnableExternalPluggableDatabaseManagementFeatureResponse::builder).logger(LOG, "enableExternalPluggableDatabaseManagementFeature").serviceDetails("DbManagement", "EnableExternalPluggableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableExternalPluggableDatabaseManagementFeature").method(Method.POST).requestBuilder(EnableExternalPluggableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("externalpluggabledatabases").appendPathParam(request.getExternalPluggableDatabaseId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnableExternalPluggableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnableExternalPluggableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse> enableHighFrequencyAutomaticSpmEvolveAdvisorTask(EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest request, AsyncHandler<EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest, EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableHighFrequencyAutomaticSpmEvolveAdvisorTaskDetails(), "enableHighFrequencyAutomaticSpmEvolveAdvisorTaskDetails is required");
        return this.clientCall(request, EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse::builder).logger(LOG, "enableHighFrequencyAutomaticSpmEvolveAdvisorTask").serviceDetails("DbManagement", "EnableHighFrequencyAutomaticSpmEvolveAdvisorTask", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableHighFrequencyAutomaticSpmEvolveAdvisorTask").method(Method.POST).requestBuilder(EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("enableHighFrequencyAutomaticSpmEvolveAdvisorTask").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", EnableHighFrequencyAutomaticSpmEvolveAdvisorTaskResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnablePluggableDatabaseManagementFeatureResponse> enablePluggableDatabaseManagementFeature(EnablePluggableDatabaseManagementFeatureRequest request, AsyncHandler<EnablePluggableDatabaseManagementFeatureRequest, EnablePluggableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getPluggableDatabaseId(), (String)"pluggableDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnablePluggableDatabaseManagementFeatureDetails(), "enablePluggableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, EnablePluggableDatabaseManagementFeatureResponse::builder).logger(LOG, "enablePluggableDatabaseManagementFeature").serviceDetails("DbManagement", "EnablePluggableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnablePluggableDatabaseManagementFeature").method(Method.POST).requestBuilder(EnablePluggableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("pluggabledatabases").appendPathParam(request.getPluggableDatabaseId()).appendPathParam("actions").appendPathParam("enableDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", EnablePluggableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", EnablePluggableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableSqlPlanBaselinesUsageResponse> enableSqlPlanBaselinesUsage(EnableSqlPlanBaselinesUsageRequest request, AsyncHandler<EnableSqlPlanBaselinesUsageRequest, EnableSqlPlanBaselinesUsageResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableSqlPlanBaselinesUsageDetails(), "enableSqlPlanBaselinesUsageDetails is required");
        return this.clientCall(request, EnableSqlPlanBaselinesUsageResponse::builder).logger(LOG, "enableSqlPlanBaselinesUsage").serviceDetails("DbManagement", "EnableSqlPlanBaselinesUsage", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/EnableSqlPlanBaselinesUsage").method(Method.POST).requestBuilder(EnableSqlPlanBaselinesUsageRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("enableSqlPlanBaselinesUsage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", EnableSqlPlanBaselinesUsageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateAwrSnapshotResponse> generateAwrSnapshot(GenerateAwrSnapshotRequest request, AsyncHandler<GenerateAwrSnapshotRequest, GenerateAwrSnapshotResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GenerateAwrSnapshotResponse::builder).logger(LOG, "generateAwrSnapshot").serviceDetails("DbManagement", "GenerateAwrSnapshot", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/SnapshotDetails/GenerateAwrSnapshot").method(Method.POST).requestBuilder(GenerateAwrSnapshotRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("generateAwrSnapshot").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SnapshotDetails.class, GenerateAwrSnapshotResponse.Builder::snapshotDetails).handleResponseHeaderString("opc-request-id", GenerateAwrSnapshotResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAwrDbReportResponse> getAwrDbReport(GetAwrDbReportRequest request, AsyncHandler<GetAwrDbReportRequest, GetAwrDbReportResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAwrDbReportResponse::builder).logger(LOG, "getAwrDbReport").serviceDetails("DbManagement", "GetAwrDbReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetAwrDbReport").method(Method.GET).requestBuilder(GetAwrDbReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbReport").appendListQueryParam("instNums", request.getInstNums(), CollectionFormatType.CommaSeparated).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("reportType", (BmcEnum)request.getReportType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbReport.class, GetAwrDbReportResponse.Builder::awrDbReport).handleResponseHeaderString("opc-request-id", GetAwrDbReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAwrDbSqlReportResponse> getAwrDbSqlReport(GetAwrDbSqlReportRequest request, AsyncHandler<GetAwrDbSqlReportRequest, GetAwrDbSqlReportResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSqlId(), "sqlId is required");
        return this.clientCall(request, GetAwrDbSqlReportResponse::builder).logger(LOG, "getAwrDbSqlReport").serviceDetails("DbManagement", "GetAwrDbSqlReport", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetAwrDbSqlReport").method(Method.GET).requestBuilder(GetAwrDbSqlReportRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSqlReport").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("sqlId", (Object)request.getSqlId()).appendEnumQueryParam("reportFormat", (BmcEnum)request.getReportFormat()).appendQueryParam("containerId", (Object)request.getContainerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbSqlReport.class, GetAwrDbSqlReportResponse.Builder::awrDbSqlReport).handleResponseHeaderString("opc-request-id", GetAwrDbSqlReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterCacheMetricResponse> getClusterCacheMetric(GetClusterCacheMetricRequest request, AsyncHandler<GetClusterCacheMetricRequest, GetClusterCacheMetricResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetClusterCacheMetricResponse::builder).logger(LOG, "getClusterCacheMetric").serviceDetails("DbManagement", "GetClusterCacheMetric", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ClusterCacheMetric/GetClusterCacheMetric").method(Method.GET).requestBuilder(GetClusterCacheMetricRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("clusterCacheMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterCacheMetric.class, GetClusterCacheMetricResponse.Builder::clusterCacheMetric).handleResponseHeaderString("opc-request-id", GetClusterCacheMetricResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseFleetHealthMetricsResponse> getDatabaseFleetHealthMetrics(GetDatabaseFleetHealthMetricsRequest request, AsyncHandler<GetDatabaseFleetHealthMetricsRequest, GetDatabaseFleetHealthMetricsResponse> handler) {
        Objects.requireNonNull(request.getCompareBaselineTime(), "compareBaselineTime is required");
        Objects.requireNonNull(request.getCompareTargetTime(), "compareTargetTime is required");
        return this.clientCall(request, GetDatabaseFleetHealthMetricsResponse::builder).logger(LOG, "getDatabaseFleetHealthMetrics").serviceDetails("DbManagement", "GetDatabaseFleetHealthMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DatabaseFleetHealthMetrics/GetDatabaseFleetHealthMetrics").method(Method.GET).requestBuilder(GetDatabaseFleetHealthMetricsRequest::builder).basePath("/20201101").appendPathParam("fleetMetrics").appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compareBaselineTime", (Object)request.getCompareBaselineTime()).appendQueryParam("compareTargetTime", (Object)request.getCompareTargetTime()).appendEnumQueryParam("compareType", (BmcEnum)request.getCompareType()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).appendQueryParam("filterByDatabaseType", (Object)request.getFilterByDatabaseType()).appendQueryParam("filterByDatabaseSubType", (Object)request.getFilterByDatabaseSubType()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("filterByDatabaseDeploymentType", (Object)request.getFilterByDatabaseDeploymentType()).appendQueryParam("filterByDatabaseVersion", (Object)request.getFilterByDatabaseVersion()).appendListQueryParam("definedTagEquals", request.getDefinedTagEquals(), CollectionFormatType.Multi).appendListQueryParam("freeformTagEquals", request.getFreeformTagEquals(), CollectionFormatType.Multi).appendListQueryParam("definedTagExists", request.getDefinedTagExists(), CollectionFormatType.Multi).appendListQueryParam("freeformTagExists", request.getFreeformTagExists(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseFleetHealthMetrics.class, GetDatabaseFleetHealthMetricsResponse.Builder::databaseFleetHealthMetrics).handleResponseHeaderString("opc-request-id", GetDatabaseFleetHealthMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", GetDatabaseFleetHealthMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<GetDatabaseHomeMetricsResponse> getDatabaseHomeMetrics(GetDatabaseHomeMetricsRequest request, AsyncHandler<GetDatabaseHomeMetricsRequest, GetDatabaseHomeMetricsResponse> handler) {
        Objects.requireNonNull(request.getManagedDatabaseId(), "managedDatabaseId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetDatabaseHomeMetricsResponse::builder).logger(LOG, "getDatabaseHomeMetrics").serviceDetails("DbManagement", "GetDatabaseHomeMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DatabaseHomeMetrics/GetDatabaseHomeMetrics").method(Method.GET).requestBuilder(GetDatabaseHomeMetricsRequest::builder).basePath("/20201101").appendPathParam("databaseHomeMetrics").appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatabaseHomeMetrics.class, GetDatabaseHomeMetricsResponse.Builder::databaseHomeMetrics).handleResponseHeaderString("opc-request-id", GetDatabaseHomeMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDataguardPerformanceMetricsResponse> getDataguardPerformanceMetrics(GetDataguardPerformanceMetricsRequest request, AsyncHandler<GetDataguardPerformanceMetricsRequest, GetDataguardPerformanceMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetDataguardPerformanceMetricsResponse::builder).logger(LOG, "getDataguardPerformanceMetrics").serviceDetails("DbManagement", "GetDataguardPerformanceMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DataguardPerformanceMetrics/GetDataguardPerformanceMetrics").method(Method.GET).requestBuilder(GetDataguardPerformanceMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("dataguardPerformanceMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("peerDatabaseCompartmentId", (Object)request.getPeerDatabaseCompartmentId()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DataguardPerformanceMetrics.class, GetDataguardPerformanceMetricsResponse.Builder::dataguardPerformanceMetrics).handleResponseHeaderString("opc-request-id", GetDataguardPerformanceMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDbManagementPrivateEndpointResponse> getDbManagementPrivateEndpoint(GetDbManagementPrivateEndpointRequest request, AsyncHandler<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDbManagementPrivateEndpointResponse::builder).logger(LOG, "getDbManagementPrivateEndpoint").serviceDetails("DbManagement", "GetDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/GetDbManagementPrivateEndpoint").method(Method.GET).requestBuilder(GetDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbManagementPrivateEndpoint.class, GetDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("etag", GetDbManagementPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDbManagementPrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalAsmResponse> getExternalAsm(GetExternalAsmRequest request, AsyncHandler<GetExternalAsmRequest, GetExternalAsmResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalAsmResponse::builder).logger(LOG, "getExternalAsm").serviceDetails("DbManagement", "GetExternalAsm", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/GetExternalAsm").method(Method.GET).requestBuilder(GetExternalAsmRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalAsm.class, GetExternalAsmResponse.Builder::externalAsm).handleResponseHeaderString("etag", GetExternalAsmResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalAsmResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalAsmConfigurationResponse> getExternalAsmConfiguration(GetExternalAsmConfigurationRequest request, AsyncHandler<GetExternalAsmConfigurationRequest, GetExternalAsmConfigurationResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalAsmConfigurationResponse::builder).logger(LOG, "getExternalAsmConfiguration").serviceDetails("DbManagement", "GetExternalAsmConfiguration", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/GetExternalAsmConfiguration").method(Method.GET).requestBuilder(GetExternalAsmConfigurationRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).appendPathParam("configuration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ExternalAsmConfiguration.class, GetExternalAsmConfigurationResponse.Builder::externalAsmConfiguration).handleResponseHeaderString("opc-request-id", GetExternalAsmConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalAsmInstanceResponse> getExternalAsmInstance(GetExternalAsmInstanceRequest request, AsyncHandler<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmInstanceId(), (String)"externalAsmInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalAsmInstanceResponse::builder).logger(LOG, "getExternalAsmInstance").serviceDetails("DbManagement", "GetExternalAsmInstance", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsmInstance/GetExternalAsmInstance").method(Method.GET).requestBuilder(GetExternalAsmInstanceRequest::builder).basePath("/20201101").appendPathParam("externalAsmInstances").appendPathParam(request.getExternalAsmInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalAsmInstance.class, GetExternalAsmInstanceResponse.Builder::externalAsmInstance).handleResponseHeaderString("etag", GetExternalAsmInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalAsmInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalClusterResponse> getExternalCluster(GetExternalClusterRequest request, AsyncHandler<GetExternalClusterRequest, GetExternalClusterResponse> handler) {
        Validate.notBlank((String)request.getExternalClusterId(), (String)"externalClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalClusterResponse::builder).logger(LOG, "getExternalCluster").serviceDetails("DbManagement", "GetExternalCluster", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalCluster/GetExternalCluster").method(Method.GET).requestBuilder(GetExternalClusterRequest::builder).basePath("/20201101").appendPathParam("externalClusters").appendPathParam(request.getExternalClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalCluster.class, GetExternalClusterResponse.Builder::externalCluster).handleResponseHeaderString("etag", GetExternalClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalClusterInstanceResponse> getExternalClusterInstance(GetExternalClusterInstanceRequest request, AsyncHandler<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse> handler) {
        Validate.notBlank((String)request.getExternalClusterInstanceId(), (String)"externalClusterInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalClusterInstanceResponse::builder).logger(LOG, "getExternalClusterInstance").serviceDetails("DbManagement", "GetExternalClusterInstance", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalClusterInstance/GetExternalClusterInstance").method(Method.GET).requestBuilder(GetExternalClusterInstanceRequest::builder).basePath("/20201101").appendPathParam("externalClusterInstances").appendPathParam(request.getExternalClusterInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalClusterInstance.class, GetExternalClusterInstanceResponse.Builder::externalClusterInstance).handleResponseHeaderString("etag", GetExternalClusterInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalClusterInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalDbHomeResponse> getExternalDbHome(GetExternalDbHomeRequest request, AsyncHandler<GetExternalDbHomeRequest, GetExternalDbHomeResponse> handler) {
        Validate.notBlank((String)request.getExternalDbHomeId(), (String)"externalDbHomeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalDbHomeResponse::builder).logger(LOG, "getExternalDbHome").serviceDetails("DbManagement", "GetExternalDbHome", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbHome/GetExternalDbHome").method(Method.GET).requestBuilder(GetExternalDbHomeRequest::builder).basePath("/20201101").appendPathParam("externalDbHomes").appendPathParam(request.getExternalDbHomeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbHome.class, GetExternalDbHomeResponse.Builder::externalDbHome).handleResponseHeaderString("etag", GetExternalDbHomeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalDbHomeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalDbNodeResponse> getExternalDbNode(GetExternalDbNodeRequest request, AsyncHandler<GetExternalDbNodeRequest, GetExternalDbNodeResponse> handler) {
        Validate.notBlank((String)request.getExternalDbNodeId(), (String)"externalDbNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalDbNodeResponse::builder).logger(LOG, "getExternalDbNode").serviceDetails("DbManagement", "GetExternalDbNode", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbNode/GetExternalDbNode").method(Method.GET).requestBuilder(GetExternalDbNodeRequest::builder).basePath("/20201101").appendPathParam("externalDbNodes").appendPathParam(request.getExternalDbNodeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbNode.class, GetExternalDbNodeResponse.Builder::externalDbNode).handleResponseHeaderString("etag", GetExternalDbNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalDbNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalDbSystemResponse> getExternalDbSystem(GetExternalDbSystemRequest request, AsyncHandler<GetExternalDbSystemRequest, GetExternalDbSystemResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalDbSystemResponse::builder).logger(LOG, "getExternalDbSystem").serviceDetails("DbManagement", "GetExternalDbSystem", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/GetExternalDbSystem").method(Method.GET).requestBuilder(GetExternalDbSystemRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystem.class, GetExternalDbSystemResponse.Builder::externalDbSystem).handleResponseHeaderString("etag", GetExternalDbSystemResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalDbSystemResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalDbSystemConnectorResponse> getExternalDbSystemConnector(GetExternalDbSystemConnectorRequest request, AsyncHandler<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemConnectorId(), (String)"externalDbSystemConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalDbSystemConnectorResponse::builder).logger(LOG, "getExternalDbSystemConnector").serviceDetails("DbManagement", "GetExternalDbSystemConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/GetExternalDbSystemConnector").method(Method.GET).requestBuilder(GetExternalDbSystemConnectorRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").appendPathParam(request.getExternalDbSystemConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystemConnector.class, GetExternalDbSystemConnectorResponse.Builder::externalDbSystemConnector).handleResponseHeaderString("etag", GetExternalDbSystemConnectorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalDbSystemConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalDbSystemDiscoveryResponse> getExternalDbSystemDiscovery(GetExternalDbSystemDiscoveryRequest request, AsyncHandler<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemDiscoveryId(), (String)"externalDbSystemDiscoveryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalDbSystemDiscoveryResponse::builder).logger(LOG, "getExternalDbSystemDiscovery").serviceDetails("DbManagement", "GetExternalDbSystemDiscovery", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/GetExternalDbSystemDiscovery").method(Method.GET).requestBuilder(GetExternalDbSystemDiscoveryRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").appendPathParam(request.getExternalDbSystemDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystemDiscovery.class, GetExternalDbSystemDiscoveryResponse.Builder::externalDbSystemDiscovery).handleResponseHeaderString("etag", GetExternalDbSystemDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalDbSystemDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalExadataInfrastructureResponse> getExternalExadataInfrastructure(GetExternalExadataInfrastructureRequest request, AsyncHandler<GetExternalExadataInfrastructureRequest, GetExternalExadataInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalExadataInfrastructureResponse::builder).logger(LOG, "getExternalExadataInfrastructure").serviceDetails("DbManagement", "GetExternalExadataInfrastructure", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/GetExternalExadataInfrastructure").method(Method.GET).requestBuilder(GetExternalExadataInfrastructureRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataInfrastructure.class, GetExternalExadataInfrastructureResponse.Builder::externalExadataInfrastructure).handleResponseHeaderString("opc-request-id", GetExternalExadataInfrastructureResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetExternalExadataInfrastructureResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetExternalExadataStorageConnectorResponse> getExternalExadataStorageConnector(GetExternalExadataStorageConnectorRequest request, AsyncHandler<GetExternalExadataStorageConnectorRequest, GetExternalExadataStorageConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageConnectorId(), (String)"externalExadataStorageConnectorId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalExadataStorageConnectorResponse::builder).logger(LOG, "getExternalExadataStorageConnector").serviceDetails("DbManagement", "GetExternalExadataStorageConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/GetExternalExadataStorageConnector").method(Method.GET).requestBuilder(GetExternalExadataStorageConnectorRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").appendPathParam(request.getExternalExadataStorageConnectorId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataStorageConnector.class, GetExternalExadataStorageConnectorResponse.Builder::externalExadataStorageConnector).handleResponseHeaderString("etag", GetExternalExadataStorageConnectorResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalExadataStorageConnectorResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalExadataStorageGridResponse> getExternalExadataStorageGrid(GetExternalExadataStorageGridRequest request, AsyncHandler<GetExternalExadataStorageGridRequest, GetExternalExadataStorageGridResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageGridId(), (String)"externalExadataStorageGridId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalExadataStorageGridResponse::builder).logger(LOG, "getExternalExadataStorageGrid").serviceDetails("DbManagement", "GetExternalExadataStorageGrid", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageGrid/GetExternalExadataStorageGrid").method(Method.GET).requestBuilder(GetExternalExadataStorageGridRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageGrids").appendPathParam(request.getExternalExadataStorageGridId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataStorageGrid.class, GetExternalExadataStorageGridResponse.Builder::externalExadataStorageGrid).handleResponseHeaderString("etag", GetExternalExadataStorageGridResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalExadataStorageGridResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalExadataStorageServerResponse> getExternalExadataStorageServer(GetExternalExadataStorageServerRequest request, AsyncHandler<GetExternalExadataStorageServerRequest, GetExternalExadataStorageServerResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageServerId(), (String)"externalExadataStorageServerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalExadataStorageServerResponse::builder).logger(LOG, "getExternalExadataStorageServer").serviceDetails("DbManagement", "GetExternalExadataStorageServer", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/GetExternalExadataStorageServer").method(Method.GET).requestBuilder(GetExternalExadataStorageServerRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendPathParam(request.getExternalExadataStorageServerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataStorageServer.class, GetExternalExadataStorageServerResponse.Builder::externalExadataStorageServer).handleResponseHeaderString("etag", GetExternalExadataStorageServerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalExadataStorageServerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetExternalListenerResponse> getExternalListener(GetExternalListenerRequest request, AsyncHandler<GetExternalListenerRequest, GetExternalListenerResponse> handler) {
        Validate.notBlank((String)request.getExternalListenerId(), (String)"externalListenerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetExternalListenerResponse::builder).logger(LOG, "getExternalListener").serviceDetails("DbManagement", "GetExternalListener", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalListener/GetExternalListener").method(Method.GET).requestBuilder(GetExternalListenerRequest::builder).basePath("/20201101").appendPathParam("externalListeners").appendPathParam(request.getExternalListenerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalListener.class, GetExternalListenerResponse.Builder::externalListener).handleResponseHeaderString("etag", GetExternalListenerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExternalListenerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIormPlanResponse> getIormPlan(GetIormPlanRequest request, AsyncHandler<GetIormPlanRequest, GetIormPlanResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageServerId(), (String)"externalExadataStorageServerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIormPlanResponse::builder).logger(LOG, "getIormPlan").serviceDetails("DbManagement", "GetIormPlan", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/GetIormPlan").method(Method.GET).requestBuilder(GetIormPlanRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendPathParam(request.getExternalExadataStorageServerId()).appendPathParam("iormPlan").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IormPlan.class, GetIormPlanResponse.Builder::iormPlan).handleResponseHeaderString("opc-request-id", GetIormPlanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DbManagement", "GetJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("location", GetJobResponse.Builder::location).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetJobExecutionResponse> getJobExecution(GetJobExecutionRequest request, AsyncHandler<GetJobExecutionRequest, GetJobExecutionResponse> handler) {
        Validate.notBlank((String)request.getJobExecutionId(), (String)"jobExecutionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobExecutionResponse::builder).logger(LOG, "getJobExecution").serviceDetails("DbManagement", "GetJobExecution", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecution/GetJobExecution").method(Method.GET).requestBuilder(GetJobExecutionRequest::builder).basePath("/20201101").appendPathParam("jobExecutions").appendPathParam(request.getJobExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecution.class, GetJobExecutionResponse.Builder::jobExecution).handleResponseHeaderString("opc-request-id", GetJobExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetJobRunResponse> getJobRun(GetJobRunRequest request, AsyncHandler<GetJobRunRequest, GetJobRunResponse> handler) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetJobRunResponse::builder).logger(LOG, "getJobRun").serviceDetails("DbManagement", "GetJobRun", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobRun/GetJobRun").method(Method.GET).requestBuilder(GetJobRunRequest::builder).basePath("/20201101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobRun.class, GetJobRunResponse.Builder::jobRun).handleResponseHeaderString("opc-request-id", GetJobRunResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetManagedDatabaseResponse> getManagedDatabase(GetManagedDatabaseRequest request, AsyncHandler<GetManagedDatabaseRequest, GetManagedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedDatabaseResponse::builder).logger(LOG, "getManagedDatabase").serviceDetails("DbManagement", "GetManagedDatabase", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetManagedDatabase").method(Method.GET).requestBuilder(GetManagedDatabaseRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabase.class, GetManagedDatabaseResponse.Builder::managedDatabase).handleResponseHeaderString("opc-request-id", GetManagedDatabaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetManagedDatabaseResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetManagedDatabaseGroupResponse> getManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, AsyncHandler<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetManagedDatabaseGroupResponse::builder).logger(LOG, "getManagedDatabaseGroup").serviceDetails("DbManagement", "GetManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/GetManagedDatabaseGroup").method(Method.GET).requestBuilder(GetManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseGroup.class, GetManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("opc-request-id", GetManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetManagedDatabaseGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetNamedCredentialResponse> getNamedCredential(GetNamedCredentialRequest request, AsyncHandler<GetNamedCredentialRequest, GetNamedCredentialResponse> handler) {
        Validate.notBlank((String)request.getNamedCredentialId(), (String)"namedCredentialId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNamedCredentialResponse::builder).logger(LOG, "getNamedCredential").serviceDetails("DbManagement", "GetNamedCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/GetNamedCredential").method(Method.GET).requestBuilder(GetNamedCredentialRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendPathParam(request.getNamedCredentialId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamedCredential.class, GetNamedCredentialResponse.Builder::namedCredential).handleResponseHeaderString("opc-request-id", GetNamedCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetNamedCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetOpenAlertHistoryResponse> getOpenAlertHistory(GetOpenAlertHistoryRequest request, AsyncHandler<GetOpenAlertHistoryRequest, GetOpenAlertHistoryResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageServerId(), (String)"externalExadataStorageServerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOpenAlertHistoryResponse::builder).logger(LOG, "getOpenAlertHistory").serviceDetails("DbManagement", "GetOpenAlertHistory", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/GetOpenAlertHistory").method(Method.GET).requestBuilder(GetOpenAlertHistoryRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendPathParam(request.getExternalExadataStorageServerId()).appendPathParam("openAlertHistory").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OpenAlertHistory.class, GetOpenAlertHistoryResponse.Builder::openAlertHistory).handleResponseHeaderString("opc-request-id", GetOpenAlertHistoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOptimizerStatisticsAdvisorExecutionResponse> getOptimizerStatisticsAdvisorExecution(GetOptimizerStatisticsAdvisorExecutionRequest request, AsyncHandler<GetOptimizerStatisticsAdvisorExecutionRequest, GetOptimizerStatisticsAdvisorExecutionResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTaskName(), "taskName is required");
        return this.clientCall(request, GetOptimizerStatisticsAdvisorExecutionResponse::builder).logger(LOG, "getOptimizerStatisticsAdvisorExecution").serviceDetails("DbManagement", "GetOptimizerStatisticsAdvisorExecution", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsAdvisorExecution").method(Method.GET).requestBuilder(GetOptimizerStatisticsAdvisorExecutionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendQueryParam("taskName", (Object)request.getTaskName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsAdvisorExecution.class, GetOptimizerStatisticsAdvisorExecutionResponse.Builder::optimizerStatisticsAdvisorExecution).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsAdvisorExecutionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOptimizerStatisticsAdvisorExecutionScriptResponse> getOptimizerStatisticsAdvisorExecutionScript(GetOptimizerStatisticsAdvisorExecutionScriptRequest request, AsyncHandler<GetOptimizerStatisticsAdvisorExecutionScriptRequest, GetOptimizerStatisticsAdvisorExecutionScriptResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTaskName(), "taskName is required");
        return this.clientCall(request, GetOptimizerStatisticsAdvisorExecutionScriptResponse::builder).logger(LOG, "getOptimizerStatisticsAdvisorExecutionScript").serviceDetails("DbManagement", "GetOptimizerStatisticsAdvisorExecutionScript", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsAdvisorExecutionScript").method(Method.GET).requestBuilder(GetOptimizerStatisticsAdvisorExecutionScriptRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendPathParam("script").appendQueryParam("taskName", (Object)request.getTaskName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsAdvisorExecutionScript.class, GetOptimizerStatisticsAdvisorExecutionScriptResponse.Builder::optimizerStatisticsAdvisorExecutionScript).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsAdvisorExecutionScriptResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOptimizerStatisticsCollectionOperationResponse> getOptimizerStatisticsCollectionOperation(GetOptimizerStatisticsCollectionOperationRequest request, AsyncHandler<GetOptimizerStatisticsCollectionOperationRequest, GetOptimizerStatisticsCollectionOperationResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOptimizerStatisticsCollectionOperationResponse::builder).logger(LOG, "getOptimizerStatisticsCollectionOperation").serviceDetails("DbManagement", "GetOptimizerStatisticsCollectionOperation", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetOptimizerStatisticsCollectionOperation").method(Method.GET).requestBuilder(GetOptimizerStatisticsCollectionOperationRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionOperations").appendPathParam((Number)request.getOptimizerStatisticsCollectionOperationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsCollectionOperation.class, GetOptimizerStatisticsCollectionOperationResponse.Builder::optimizerStatisticsCollectionOperation).handleResponseHeaderString("opc-request-id", GetOptimizerStatisticsCollectionOperationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPdbMetricsResponse> getPdbMetrics(GetPdbMetricsRequest request, AsyncHandler<GetPdbMetricsRequest, GetPdbMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetPdbMetricsResponse::builder).logger(LOG, "getPdbMetrics").serviceDetails("DbManagement", "GetPdbMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PdbMetrics/GetPdbMetrics").method(Method.GET).requestBuilder(GetPdbMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("pdbMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("compareType", (BmcEnum)request.getCompareType()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PdbMetrics.class, GetPdbMetricsResponse.Builder::pdbMetrics).handleResponseHeaderString("opc-request-id", GetPdbMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPeerDatabaseMetricsResponse> getPeerDatabaseMetrics(GetPeerDatabaseMetricsRequest request, AsyncHandler<GetPeerDatabaseMetricsRequest, GetPeerDatabaseMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, GetPeerDatabaseMetricsResponse::builder).logger(LOG, "getPeerDatabaseMetrics").serviceDetails("DbManagement", "GetPeerDatabaseMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PeerDatabaseMetrics/GetPeerDatabaseMetrics").method(Method.GET).requestBuilder(GetPeerDatabaseMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("peerDatabaseMetrics").appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("peerDatabaseCompartmentId", (Object)request.getPeerDatabaseCompartmentId()).appendEnumQueryParam("compareType", (BmcEnum)request.getCompareType()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PeerDatabaseMetrics.class, GetPeerDatabaseMetricsResponse.Builder::peerDatabaseMetrics).handleResponseHeaderString("opc-request-id", GetPeerDatabaseMetricsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPreferredCredentialResponse> getPreferredCredential(GetPreferredCredentialRequest request, AsyncHandler<GetPreferredCredentialRequest, GetPreferredCredentialResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPreferredCredentialResponse::builder).logger(LOG, "getPreferredCredential").serviceDetails("DbManagement", "GetPreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/GetPreferredCredential").method(Method.GET).requestBuilder(GetPreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PreferredCredential.class, GetPreferredCredentialResponse.Builder::preferredCredential).handleResponseHeaderString("opc-request-id", GetPreferredCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetPreferredCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetSqlPlanBaselineResponse> getSqlPlanBaseline(GetSqlPlanBaselineRequest request, AsyncHandler<GetSqlPlanBaselineRequest, GetSqlPlanBaselineResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPlanName(), (String)"planName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSqlPlanBaselineResponse::builder).logger(LOG, "getSqlPlanBaseline").serviceDetails("DbManagement", "GetSqlPlanBaseline", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlPlanBaseline").method(Method.GET).requestBuilder(GetSqlPlanBaselineRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam(request.getPlanName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaseline.class, GetSqlPlanBaselineResponse.Builder::sqlPlanBaseline).handleResponseHeaderString("opc-request-id", GetSqlPlanBaselineResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetSqlPlanBaselineConfigurationResponse> getSqlPlanBaselineConfiguration(GetSqlPlanBaselineConfigurationRequest request, AsyncHandler<GetSqlPlanBaselineConfigurationRequest, GetSqlPlanBaselineConfigurationResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSqlPlanBaselineConfigurationResponse::builder).logger(LOG, "getSqlPlanBaselineConfiguration").serviceDetails("DbManagement", "GetSqlPlanBaselineConfiguration", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetSqlPlanBaselineConfiguration").method(Method.GET).requestBuilder(GetSqlPlanBaselineConfigurationRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselineConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaselineConfiguration.class, GetSqlPlanBaselineConfigurationResponse.Builder::sqlPlanBaselineConfiguration).handleResponseHeaderString("opc-request-id", GetSqlPlanBaselineConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTablespaceResponse> getTablespace(GetTablespaceRequest request, AsyncHandler<GetTablespaceRequest, GetTablespaceResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTablespaceResponse::builder).logger(LOG, "getTablespace").serviceDetails("DbManagement", "GetTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/GetTablespace").method(Method.GET).requestBuilder(GetTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(Tablespace.class, GetTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", GetTablespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetTopSqlCpuActivityResponse> getTopSqlCpuActivity(GetTopSqlCpuActivityRequest request, AsyncHandler<GetTopSqlCpuActivityRequest, GetTopSqlCpuActivityResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageServerId(), (String)"externalExadataStorageServerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetTopSqlCpuActivityResponse::builder).logger(LOG, "getTopSqlCpuActivity").serviceDetails("DbManagement", "GetTopSqlCpuActivity", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/GetTopSqlCpuActivity").method(Method.GET).requestBuilder(GetTopSqlCpuActivityRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendPathParam(request.getExternalExadataStorageServerId()).appendPathParam("topSqlCpuActivity").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(TopSqlCpuActivity.class, GetTopSqlCpuActivityResponse.Builder::topSqlCpuActivity).handleResponseHeaderString("opc-request-id", GetTopSqlCpuActivityResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetUserResponse> getUser(GetUserRequest request, AsyncHandler<GetUserRequest, GetUserResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUserResponse::builder).logger(LOG, "getUser").serviceDetails("DbManagement", "GetUser", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/GetUser").method(Method.GET).requestBuilder(GetUserRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(User.class, GetUserResponse.Builder::user).handleResponseHeaderString("opc-request-id", GetUserResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DbManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ImplementOptimizerStatisticsAdvisorRecommendationsResponse> implementOptimizerStatisticsAdvisorRecommendations(ImplementOptimizerStatisticsAdvisorRecommendationsRequest request, AsyncHandler<ImplementOptimizerStatisticsAdvisorRecommendationsRequest, ImplementOptimizerStatisticsAdvisorRecommendationsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getExecutionName(), (String)"executionName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImplementOptimizerStatisticsAdvisorRecommendationsDetails(), "implementOptimizerStatisticsAdvisorRecommendationsDetails is required");
        return this.clientCall(request, ImplementOptimizerStatisticsAdvisorRecommendationsResponse::builder).logger(LOG, "implementOptimizerStatisticsAdvisorRecommendations").serviceDetails("DbManagement", "ImplementOptimizerStatisticsAdvisorRecommendations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ImplementOptimizerStatisticsAdvisorRecommendations").method(Method.POST).requestBuilder(ImplementOptimizerStatisticsAdvisorRecommendationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendPathParam(request.getExecutionName()).appendPathParam("actions").appendPathParam("implementRecommendations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Job.class, ImplementOptimizerStatisticsAdvisorRecommendationsResponse.Builder::job).handleResponseHeaderString("opc-request-id", ImplementOptimizerStatisticsAdvisorRecommendationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAsmPropertiesResponse> listAsmProperties(ListAsmPropertiesRequest request, AsyncHandler<ListAsmPropertiesRequest, ListAsmPropertiesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAsmPropertiesResponse::builder).logger(LOG, "listAsmProperties").serviceDetails("DbManagement", "ListAsmProperties", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAsmProperties").method(Method.GET).requestBuilder(ListAsmPropertiesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("asmProperties").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AsmPropertyCollection.class, ListAsmPropertiesResponse.Builder::asmPropertyCollection).handleResponseHeaderString("opc-request-id", ListAsmPropertiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAsmPropertiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAssociatedDatabasesResponse> listAssociatedDatabases(ListAssociatedDatabasesRequest request, AsyncHandler<ListAssociatedDatabasesRequest, ListAssociatedDatabasesResponse> handler) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAssociatedDatabasesResponse::builder).logger(LOG, "listAssociatedDatabases").serviceDetails("DbManagement", "ListAssociatedDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/AssociatedDatabaseSummary/ListAssociatedDatabases").method(Method.GET).requestBuilder(ListAssociatedDatabasesRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).appendPathParam("associatedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssociatedDatabaseCollection.class, ListAssociatedDatabasesResponse.Builder::associatedDatabaseCollection).handleResponseHeaderString("opc-next-page", ListAssociatedDatabasesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssociatedDatabasesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAwrDbSnapshotsResponse> listAwrDbSnapshots(ListAwrDbSnapshotsRequest request, AsyncHandler<ListAwrDbSnapshotsRequest, ListAwrDbSnapshotsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAwrDbSnapshotsResponse::builder).logger(LOG, "listAwrDbSnapshots").serviceDetails("DbManagement", "ListAwrDbSnapshots", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAwrDbSnapshots").method(Method.GET).requestBuilder(ListAwrDbSnapshotsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSnapshots").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbSnapshotCollection.class, ListAwrDbSnapshotsResponse.Builder::awrDbSnapshotCollection).handleResponseHeaderString("opc-request-id", ListAwrDbSnapshotsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAwrDbSnapshotsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAwrDbsResponse> listAwrDbs(ListAwrDbsRequest request, AsyncHandler<ListAwrDbsRequest, ListAwrDbsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAwrDbsResponse::builder).logger(LOG, "listAwrDbs").serviceDetails("DbManagement", "ListAwrDbs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListAwrDbs").method(Method.GET).requestBuilder(ListAwrDbsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendQueryParam("name", (Object)request.getName()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbCollection.class, ListAwrDbsResponse.Builder::awrDbCollection).handleResponseHeaderString("opc-request-id", ListAwrDbsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAwrDbsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListConsumerGroupPrivilegesResponse> listConsumerGroupPrivileges(ListConsumerGroupPrivilegesRequest request, AsyncHandler<ListConsumerGroupPrivilegesRequest, ListConsumerGroupPrivilegesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListConsumerGroupPrivilegesResponse::builder).logger(LOG, "listConsumerGroupPrivileges").serviceDetails("DbManagement", "ListConsumerGroupPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListConsumerGroupPrivileges").method(Method.GET).requestBuilder(ListConsumerGroupPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("consumerGroupPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ConsumerGroupPrivilegeCollection.class, ListConsumerGroupPrivilegesResponse.Builder::consumerGroupPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListConsumerGroupPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListConsumerGroupPrivilegesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListCursorCacheStatementsResponse> listCursorCacheStatements(ListCursorCacheStatementsRequest request, AsyncHandler<ListCursorCacheStatementsRequest, ListCursorCacheStatementsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListCursorCacheStatementsResponse::builder).logger(LOG, "listCursorCacheStatements").serviceDetails("DbManagement", "ListCursorCacheStatements", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListCursorCacheStatements").method(Method.GET).requestBuilder(ListCursorCacheStatementsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("cursorCacheStatements").appendQueryParam("sqlText", (Object)request.getSqlText()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(CursorCacheStatementCollection.class, ListCursorCacheStatementsResponse.Builder::cursorCacheStatementCollection).handleResponseHeaderString("opc-request-id", ListCursorCacheStatementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCursorCacheStatementsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDataAccessContainersResponse> listDataAccessContainers(ListDataAccessContainersRequest request, AsyncHandler<ListDataAccessContainersRequest, ListDataAccessContainersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDataAccessContainersResponse::builder).logger(LOG, "listDataAccessContainers").serviceDetails("DbManagement", "ListDataAccessContainers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListDataAccessContainers").method(Method.GET).requestBuilder(ListDataAccessContainersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("dataAccessContainers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(DataAccessContainerCollection.class, ListDataAccessContainersResponse.Builder::dataAccessContainerCollection).handleResponseHeaderString("opc-next-page", ListDataAccessContainersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDataAccessContainersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDatabaseParametersResponse> listDatabaseParameters(ListDatabaseParametersRequest request, AsyncHandler<ListDatabaseParametersRequest, ListDatabaseParametersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDatabaseParametersResponse::builder).logger(LOG, "listDatabaseParameters").serviceDetails("DbManagement", "ListDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListDatabaseParameters").method(Method.GET).requestBuilder(ListDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("databaseParameters").appendEnumQueryParam("source", (BmcEnum)request.getSource()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("isAllowedValuesIncluded", (Object)request.getIsAllowedValuesIncluded()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(DatabaseParametersCollection.class, ListDatabaseParametersResponse.Builder::databaseParametersCollection).handleResponseHeaderString("opc-request-id", ListDatabaseParametersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDbManagementPrivateEndpointsResponse> listDbManagementPrivateEndpoints(ListDbManagementPrivateEndpointsRequest request, AsyncHandler<ListDbManagementPrivateEndpointsRequest, ListDbManagementPrivateEndpointsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDbManagementPrivateEndpointsResponse::builder).logger(LOG, "listDbManagementPrivateEndpoints").serviceDetails("DbManagement", "ListDbManagementPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/ListDbManagementPrivateEndpoints").method(Method.GET).requestBuilder(ListDbManagementPrivateEndpointsRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("isCluster", (Object)request.getIsCluster()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DbManagementPrivateEndpointCollection.class, ListDbManagementPrivateEndpointsResponse.Builder::dbManagementPrivateEndpointCollection).handleResponseHeaderString("opc-request-id", ListDbManagementPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDbManagementPrivateEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalAsmDiskGroupsResponse> listExternalAsmDiskGroups(ListExternalAsmDiskGroupsRequest request, AsyncHandler<ListExternalAsmDiskGroupsRequest, ListExternalAsmDiskGroupsResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExternalAsmDiskGroupsResponse::builder).logger(LOG, "listExternalAsmDiskGroups").serviceDetails("DbManagement", "ListExternalAsmDiskGroups", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/ListExternalAsmDiskGroups").method(Method.GET).requestBuilder(ListExternalAsmDiskGroupsRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).appendPathParam("diskGroups").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ExternalAsmDiskGroupCollection.class, ListExternalAsmDiskGroupsResponse.Builder::externalAsmDiskGroupCollection).handleResponseHeaderString("opc-request-id", ListExternalAsmDiskGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalAsmDiskGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalAsmInstancesResponse> listExternalAsmInstances(ListExternalAsmInstancesRequest request, AsyncHandler<ListExternalAsmInstancesRequest, ListExternalAsmInstancesResponse> handler) {
        return this.clientCall(request, ListExternalAsmInstancesResponse::builder).logger(LOG, "listExternalAsmInstances").serviceDetails("DbManagement", "ListExternalAsmInstances", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsmInstance/ListExternalAsmInstances").method(Method.GET).requestBuilder(ListExternalAsmInstancesRequest::builder).basePath("/20201101").appendPathParam("externalAsmInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalAsmId", (Object)request.getExternalAsmId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalAsmInstanceCollection.class, ListExternalAsmInstancesResponse.Builder::externalAsmInstanceCollection).handleResponseHeaderString("opc-request-id", ListExternalAsmInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalAsmInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalAsmUsersResponse> listExternalAsmUsers(ListExternalAsmUsersRequest request, AsyncHandler<ListExternalAsmUsersRequest, ListExternalAsmUsersResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListExternalAsmUsersResponse::builder).logger(LOG, "listExternalAsmUsers").serviceDetails("DbManagement", "ListExternalAsmUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/ListExternalAsmUsers").method(Method.GET).requestBuilder(ListExternalAsmUsersRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).appendPathParam("users").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ExternalAsmUserCollection.class, ListExternalAsmUsersResponse.Builder::externalAsmUserCollection).handleResponseHeaderString("opc-request-id", ListExternalAsmUsersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalAsmUsersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalAsmsResponse> listExternalAsms(ListExternalAsmsRequest request, AsyncHandler<ListExternalAsmsRequest, ListExternalAsmsResponse> handler) {
        return this.clientCall(request, ListExternalAsmsResponse::builder).logger(LOG, "listExternalAsms").serviceDetails("DbManagement", "ListExternalAsms", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/ListExternalAsms").method(Method.GET).requestBuilder(ListExternalAsmsRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalAsmCollection.class, ListExternalAsmsResponse.Builder::externalAsmCollection).handleResponseHeaderString("opc-request-id", ListExternalAsmsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalAsmsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalClusterInstancesResponse> listExternalClusterInstances(ListExternalClusterInstancesRequest request, AsyncHandler<ListExternalClusterInstancesRequest, ListExternalClusterInstancesResponse> handler) {
        return this.clientCall(request, ListExternalClusterInstancesResponse::builder).logger(LOG, "listExternalClusterInstances").serviceDetails("DbManagement", "ListExternalClusterInstances", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalClusterInstance/ListExternalClusterInstances").method(Method.GET).requestBuilder(ListExternalClusterInstancesRequest::builder).basePath("/20201101").appendPathParam("externalClusterInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalClusterId", (Object)request.getExternalClusterId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalClusterInstanceCollection.class, ListExternalClusterInstancesResponse.Builder::externalClusterInstanceCollection).handleResponseHeaderString("opc-request-id", ListExternalClusterInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalClusterInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalClustersResponse> listExternalClusters(ListExternalClustersRequest request, AsyncHandler<ListExternalClustersRequest, ListExternalClustersResponse> handler) {
        return this.clientCall(request, ListExternalClustersResponse::builder).logger(LOG, "listExternalClusters").serviceDetails("DbManagement", "ListExternalClusters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalCluster/ListExternalClusters").method(Method.GET).requestBuilder(ListExternalClustersRequest::builder).basePath("/20201101").appendPathParam("externalClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalClusterCollection.class, ListExternalClustersResponse.Builder::externalClusterCollection).handleResponseHeaderString("opc-request-id", ListExternalClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalClustersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDatabasesResponse> listExternalDatabases(ListExternalDatabasesRequest request, AsyncHandler<ListExternalDatabasesRequest, ListExternalDatabasesResponse> handler) {
        return this.clientCall(request, ListExternalDatabasesResponse::builder).logger(LOG, "listExternalDatabases").serviceDetails("DbManagement", "ListExternalDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDatabaseCollection/ListExternalDatabases").method(Method.GET).requestBuilder(ListExternalDatabasesRequest::builder).basePath("/20201101").appendPathParam("externalDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("externalDatabaseId", (Object)request.getExternalDatabaseId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDatabaseCollection.class, ListExternalDatabasesResponse.Builder::externalDatabaseCollection).handleResponseHeaderString("opc-request-id", ListExternalDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDatabasesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDbHomesResponse> listExternalDbHomes(ListExternalDbHomesRequest request, AsyncHandler<ListExternalDbHomesRequest, ListExternalDbHomesResponse> handler) {
        return this.clientCall(request, ListExternalDbHomesResponse::builder).logger(LOG, "listExternalDbHomes").serviceDetails("DbManagement", "ListExternalDbHomes", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbHome/ListExternalDbHomes").method(Method.GET).requestBuilder(ListExternalDbHomesRequest::builder).basePath("/20201101").appendPathParam("externalDbHomes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbHomeCollection.class, ListExternalDbHomesResponse.Builder::externalDbHomeCollection).handleResponseHeaderString("opc-request-id", ListExternalDbHomesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDbHomesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDbNodesResponse> listExternalDbNodes(ListExternalDbNodesRequest request, AsyncHandler<ListExternalDbNodesRequest, ListExternalDbNodesResponse> handler) {
        return this.clientCall(request, ListExternalDbNodesResponse::builder).logger(LOG, "listExternalDbNodes").serviceDetails("DbManagement", "ListExternalDbNodes", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbNode/ListExternalDbNodes").method(Method.GET).requestBuilder(ListExternalDbNodesRequest::builder).basePath("/20201101").appendPathParam("externalDbNodes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbNodeCollection.class, ListExternalDbNodesResponse.Builder::externalDbNodeCollection).handleResponseHeaderString("opc-request-id", ListExternalDbNodesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDbNodesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDbSystemConnectorsResponse> listExternalDbSystemConnectors(ListExternalDbSystemConnectorsRequest request, AsyncHandler<ListExternalDbSystemConnectorsRequest, ListExternalDbSystemConnectorsResponse> handler) {
        return this.clientCall(request, ListExternalDbSystemConnectorsResponse::builder).logger(LOG, "listExternalDbSystemConnectors").serviceDetails("DbManagement", "ListExternalDbSystemConnectors", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/ListExternalDbSystemConnectors").method(Method.GET).requestBuilder(ListExternalDbSystemConnectorsRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystemConnectorCollection.class, ListExternalDbSystemConnectorsResponse.Builder::externalDbSystemConnectorCollection).handleResponseHeaderString("opc-request-id", ListExternalDbSystemConnectorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDbSystemConnectorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDbSystemDiscoveriesResponse> listExternalDbSystemDiscoveries(ListExternalDbSystemDiscoveriesRequest request, AsyncHandler<ListExternalDbSystemDiscoveriesRequest, ListExternalDbSystemDiscoveriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListExternalDbSystemDiscoveriesResponse::builder).logger(LOG, "listExternalDbSystemDiscoveries").serviceDetails("DbManagement", "ListExternalDbSystemDiscoveries", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/ListExternalDbSystemDiscoveries").method(Method.GET).requestBuilder(ListExternalDbSystemDiscoveriesRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystemDiscoveryCollection.class, ListExternalDbSystemDiscoveriesResponse.Builder::externalDbSystemDiscoveryCollection).handleResponseHeaderString("opc-request-id", ListExternalDbSystemDiscoveriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDbSystemDiscoveriesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalDbSystemsResponse> listExternalDbSystems(ListExternalDbSystemsRequest request, AsyncHandler<ListExternalDbSystemsRequest, ListExternalDbSystemsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListExternalDbSystemsResponse::builder).logger(LOG, "listExternalDbSystems").serviceDetails("DbManagement", "ListExternalDbSystems", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/ListExternalDbSystems").method(Method.GET).requestBuilder(ListExternalDbSystemsRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalDbSystemCollection.class, ListExternalDbSystemsResponse.Builder::externalDbSystemCollection).handleResponseHeaderString("opc-request-id", ListExternalDbSystemsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalDbSystemsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalExadataInfrastructuresResponse> listExternalExadataInfrastructures(ListExternalExadataInfrastructuresRequest request, AsyncHandler<ListExternalExadataInfrastructuresRequest, ListExternalExadataInfrastructuresResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListExternalExadataInfrastructuresResponse::builder).logger(LOG, "listExternalExadataInfrastructures").serviceDetails("DbManagement", "ListExternalExadataInfrastructures", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/ListExternalExadataInfrastructures").method(Method.GET).requestBuilder(ListExternalExadataInfrastructuresRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataInfrastructureCollection.class, ListExternalExadataInfrastructuresResponse.Builder::externalExadataInfrastructureCollection).handleResponseHeaderString("opc-request-id", ListExternalExadataInfrastructuresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalExadataInfrastructuresResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalExadataStorageConnectorsResponse> listExternalExadataStorageConnectors(ListExternalExadataStorageConnectorsRequest request, AsyncHandler<ListExternalExadataStorageConnectorsRequest, ListExternalExadataStorageConnectorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getExternalExadataInfrastructureId(), "externalExadataInfrastructureId is required");
        return this.clientCall(request, ListExternalExadataStorageConnectorsResponse::builder).logger(LOG, "listExternalExadataStorageConnectors").serviceDetails("DbManagement", "ListExternalExadataStorageConnectors", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/ListExternalExadataStorageConnectors").method(Method.GET).requestBuilder(ListExternalExadataStorageConnectorsRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalExadataInfrastructureId", (Object)request.getExternalExadataInfrastructureId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataStorageConnectorCollection.class, ListExternalExadataStorageConnectorsResponse.Builder::externalExadataStorageConnectorCollection).handleResponseHeaderString("opc-request-id", ListExternalExadataStorageConnectorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalExadataStorageConnectorsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalExadataStorageServersResponse> listExternalExadataStorageServers(ListExternalExadataStorageServersRequest request, AsyncHandler<ListExternalExadataStorageServersRequest, ListExternalExadataStorageServersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getExternalExadataInfrastructureId(), "externalExadataInfrastructureId is required");
        return this.clientCall(request, ListExternalExadataStorageServersResponse::builder).logger(LOG, "listExternalExadataStorageServers").serviceDetails("DbManagement", "ListExternalExadataStorageServers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/ListExternalExadataStorageServers").method(Method.GET).requestBuilder(ListExternalExadataStorageServersRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalExadataInfrastructureId", (Object)request.getExternalExadataInfrastructureId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalExadataStorageServerCollection.class, ListExternalExadataStorageServersResponse.Builder::externalExadataStorageServerCollection).handleResponseHeaderString("opc-request-id", ListExternalExadataStorageServersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalExadataStorageServersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalListenerServicesResponse> listExternalListenerServices(ListExternalListenerServicesRequest request, AsyncHandler<ListExternalListenerServicesRequest, ListExternalListenerServicesResponse> handler) {
        Validate.notBlank((String)request.getExternalListenerId(), (String)"externalListenerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getManagedDatabaseId(), "managedDatabaseId is required");
        return this.clientCall(request, ListExternalListenerServicesResponse::builder).logger(LOG, "listExternalListenerServices").serviceDetails("DbManagement", "ListExternalListenerServices", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalListener/ListExternalListenerServices").method(Method.GET).requestBuilder(ListExternalListenerServicesRequest::builder).basePath("/20201101").appendPathParam("externalListeners").appendPathParam(request.getExternalListenerId()).appendPathParam("services").appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ExternalListenerServiceCollection.class, ListExternalListenerServicesResponse.Builder::externalListenerServiceCollection).handleResponseHeaderString("opc-request-id", ListExternalListenerServicesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalListenerServicesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListExternalListenersResponse> listExternalListeners(ListExternalListenersRequest request, AsyncHandler<ListExternalListenersRequest, ListExternalListenersResponse> handler) {
        return this.clientCall(request, ListExternalListenersResponse::builder).logger(LOG, "listExternalListeners").serviceDetails("DbManagement", "ListExternalListeners", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalListener/ListExternalListeners").method(Method.GET).requestBuilder(ListExternalListenersRequest::builder).basePath("/20201101").appendPathParam("externalListeners").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("externalDbSystemId", (Object)request.getExternalDbSystemId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ExternalListenerCollection.class, ListExternalListenersResponse.Builder::externalListenerCollection).handleResponseHeaderString("opc-request-id", ListExternalListenersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListExternalListenersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListJobExecutionsResponse> listJobExecutions(ListJobExecutionsRequest request, AsyncHandler<ListJobExecutionsRequest, ListJobExecutionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListJobExecutionsResponse::builder).logger(LOG, "listJobExecutions").serviceDetails("DbManagement", "ListJobExecutions", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecution/ListJobExecutions").method(Method.GET).requestBuilder(ListJobExecutionsRequest::builder).basePath("/20201101").appendPathParam("jobExecutions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("jobId", (Object)request.getJobId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("status", (Object)request.getStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("jobRunId", (Object)request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecutionCollection.class, ListJobExecutionsResponse.Builder::jobExecutionCollection).handleResponseHeaderString("opc-request-id", ListJobExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobExecutionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListJobRunsResponse> listJobRuns(ListJobRunsRequest request, AsyncHandler<ListJobRunsRequest, ListJobRunsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListJobRunsResponse::builder).logger(LOG, "listJobRuns").serviceDetails("DbManagement", "ListJobRuns", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobRun/ListJobRuns").method(Method.GET).requestBuilder(ListJobRunsRequest::builder).basePath("/20201101").appendPathParam("jobRuns").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("jobId", (Object)request.getJobId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("runStatus", (Object)request.getRunStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobRunCollection.class, ListJobRunsResponse.Builder::jobRunCollection).handleResponseHeaderString("opc-request-id", ListJobRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobRunsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DbManagement", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20201101").appendPathParam("jobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobCollection.class, ListJobsResponse.Builder::jobCollection).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedDatabaseGroupsResponse> listManagedDatabaseGroups(ListManagedDatabaseGroupsRequest request, AsyncHandler<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagedDatabaseGroupsResponse::builder).logger(LOG, "listManagedDatabaseGroups").serviceDetails("DbManagement", "ListManagedDatabaseGroups", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/ListManagedDatabaseGroups").method(Method.GET).requestBuilder(ListManagedDatabaseGroupsRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseGroupCollection.class, ListManagedDatabaseGroupsResponse.Builder::managedDatabaseGroupCollection).handleResponseHeaderString("opc-request-id", ListManagedDatabaseGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedDatabaseGroupsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListManagedDatabasesResponse> listManagedDatabases(ListManagedDatabasesRequest request, AsyncHandler<ListManagedDatabasesRequest, ListManagedDatabasesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListManagedDatabasesResponse::builder).logger(LOG, "listManagedDatabases").serviceDetails("DbManagement", "ListManagedDatabases", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListManagedDatabases").method(Method.GET).requestBuilder(ListManagedDatabasesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("managementOption", (BmcEnum)request.getManagementOption()).appendEnumQueryParam("deploymentType", (BmcEnum)request.getDeploymentType()).appendQueryParam("externalExadataInfrastructureId", (Object)request.getExternalExadataInfrastructureId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ManagedDatabaseCollection.class, ListManagedDatabasesResponse.Builder::managedDatabaseCollection).handleResponseHeaderString("opc-request-id", ListManagedDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListManagedDatabasesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListNamedCredentialsResponse> listNamedCredentials(ListNamedCredentialsRequest request, AsyncHandler<ListNamedCredentialsRequest, ListNamedCredentialsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNamedCredentialsResponse::builder).logger(LOG, "listNamedCredentials").serviceDetails("DbManagement", "ListNamedCredentials", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/ListNamedCredentials").method(Method.GET).requestBuilder(ListNamedCredentialsRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("associatedResource", (Object)request.getAssociatedResource()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("scope", (BmcEnum)request.getScope()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NamedCredentialCollection.class, ListNamedCredentialsResponse.Builder::namedCredentialCollection).handleResponseHeaderString("opc-request-id", ListNamedCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNamedCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListObjectPrivilegesResponse> listObjectPrivileges(ListObjectPrivilegesRequest request, AsyncHandler<ListObjectPrivilegesRequest, ListObjectPrivilegesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListObjectPrivilegesResponse::builder).logger(LOG, "listObjectPrivileges").serviceDetails("DbManagement", "ListObjectPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListObjectPrivileges").method(Method.GET).requestBuilder(ListObjectPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("objectPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ObjectPrivilegeCollection.class, ListObjectPrivilegesResponse.Builder::objectPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListObjectPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListObjectPrivilegesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOptimizerStatisticsAdvisorExecutionsResponse> listOptimizerStatisticsAdvisorExecutions(ListOptimizerStatisticsAdvisorExecutionsRequest request, AsyncHandler<ListOptimizerStatisticsAdvisorExecutionsRequest, ListOptimizerStatisticsAdvisorExecutionsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOptimizerStatisticsAdvisorExecutionsResponse::builder).logger(LOG, "listOptimizerStatisticsAdvisorExecutions").serviceDetails("DbManagement", "ListOptimizerStatisticsAdvisorExecutions", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsAdvisorExecutions").method(Method.GET).requestBuilder(ListOptimizerStatisticsAdvisorExecutionsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsAdvisorExecutions").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsAdvisorExecutionsCollection.class, ListOptimizerStatisticsAdvisorExecutionsResponse.Builder::optimizerStatisticsAdvisorExecutionsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsAdvisorExecutionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOptimizerStatisticsCollectionAggregationsResponse> listOptimizerStatisticsCollectionAggregations(ListOptimizerStatisticsCollectionAggregationsRequest request, AsyncHandler<ListOptimizerStatisticsCollectionAggregationsRequest, ListOptimizerStatisticsCollectionAggregationsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGroupType(), "groupType is required");
        return this.clientCall(request, ListOptimizerStatisticsCollectionAggregationsResponse::builder).logger(LOG, "listOptimizerStatisticsCollectionAggregations").serviceDetails("DbManagement", "ListOptimizerStatisticsCollectionAggregations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsCollectionAggregations").method(Method.GET).requestBuilder(ListOptimizerStatisticsCollectionAggregationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionAggregations").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).appendEnumQueryParam("taskType", (BmcEnum)request.getTaskType()).appendEnumQueryParam("groupType", (BmcEnum)request.getGroupType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsCollectionAggregationsCollection.class, ListOptimizerStatisticsCollectionAggregationsResponse.Builder::optimizerStatisticsCollectionAggregationsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsCollectionAggregationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOptimizerStatisticsCollectionAggregationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListOptimizerStatisticsCollectionOperationsResponse> listOptimizerStatisticsCollectionOperations(ListOptimizerStatisticsCollectionOperationsRequest request, AsyncHandler<ListOptimizerStatisticsCollectionOperationsRequest, ListOptimizerStatisticsCollectionOperationsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOptimizerStatisticsCollectionOperationsResponse::builder).logger(LOG, "listOptimizerStatisticsCollectionOperations").serviceDetails("DbManagement", "ListOptimizerStatisticsCollectionOperations", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListOptimizerStatisticsCollectionOperations").method(Method.GET).requestBuilder(ListOptimizerStatisticsCollectionOperationsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("optimizerStatisticsCollectionOperations").appendQueryParam("startTimeGreaterThanOrEqualTo", (Object)request.getStartTimeGreaterThanOrEqualTo()).appendQueryParam("endTimeLessThanOrEqualTo", (Object)request.getEndTimeLessThanOrEqualTo()).appendEnumQueryParam("taskType", (BmcEnum)request.getTaskType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("filterBy", (Object)request.getFilterBy()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(OptimizerStatisticsCollectionOperationsCollection.class, ListOptimizerStatisticsCollectionOperationsResponse.Builder::optimizerStatisticsCollectionOperationsCollection).handleResponseHeaderString("opc-request-id", ListOptimizerStatisticsCollectionOperationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOptimizerStatisticsCollectionOperationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPreferredCredentialsResponse> listPreferredCredentials(ListPreferredCredentialsRequest request, AsyncHandler<ListPreferredCredentialsRequest, ListPreferredCredentialsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPreferredCredentialsResponse::builder).logger(LOG, "listPreferredCredentials").serviceDetails("DbManagement", "ListPreferredCredentials", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/ListPreferredCredentials").method(Method.GET).requestBuilder(ListPreferredCredentialsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(PreferredCredentialCollection.class, ListPreferredCredentialsResponse.Builder::preferredCredentialCollection).handleResponseHeaderString("opc-request-id", ListPreferredCredentialsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPreferredCredentialsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProxiedForUsersResponse> listProxiedForUsers(ListProxiedForUsersRequest request, AsyncHandler<ListProxiedForUsersRequest, ListProxiedForUsersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListProxiedForUsersResponse::builder).logger(LOG, "listProxiedForUsers").serviceDetails("DbManagement", "ListProxiedForUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListProxiedForUsers").method(Method.GET).requestBuilder(ListProxiedForUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("proxiedForUsers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ProxiedForUserCollection.class, ListProxiedForUsersResponse.Builder::proxiedForUserCollection).handleResponseHeaderString("opc-next-page", ListProxiedForUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProxiedForUsersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListProxyUsersResponse> listProxyUsers(ListProxyUsersRequest request, AsyncHandler<ListProxyUsersRequest, ListProxyUsersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListProxyUsersResponse::builder).logger(LOG, "listProxyUsers").serviceDetails("DbManagement", "ListProxyUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListProxyUsers").method(Method.GET).requestBuilder(ListProxyUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("proxyUsers").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(ProxyUserCollection.class, ListProxyUsersResponse.Builder::proxyUserCollection).handleResponseHeaderString("opc-next-page", ListProxyUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListProxyUsersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRolesResponse> listRoles(ListRolesRequest request, AsyncHandler<ListRolesRequest, ListRolesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListRolesResponse::builder).logger(LOG, "listRoles").serviceDetails("DbManagement", "ListRoles", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListRoles").method(Method.GET).requestBuilder(ListRolesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("roles").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(RoleCollection.class, ListRolesResponse.Builder::roleCollection).handleResponseHeaderString("opc-next-page", ListRolesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRolesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSqlPlanBaselineJobsResponse> listSqlPlanBaselineJobs(ListSqlPlanBaselineJobsRequest request, AsyncHandler<ListSqlPlanBaselineJobsRequest, ListSqlPlanBaselineJobsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSqlPlanBaselineJobsResponse::builder).logger(LOG, "listSqlPlanBaselineJobs").serviceDetails("DbManagement", "ListSqlPlanBaselineJobs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlPlanBaselineJobs").method(Method.GET).requestBuilder(ListSqlPlanBaselineJobsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselineJobs").appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaselineJobCollection.class, ListSqlPlanBaselineJobsResponse.Builder::sqlPlanBaselineJobCollection).handleResponseHeaderString("opc-request-id", ListSqlPlanBaselineJobsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlPlanBaselineJobsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSqlPlanBaselinesResponse> listSqlPlanBaselines(ListSqlPlanBaselinesRequest request, AsyncHandler<ListSqlPlanBaselinesRequest, ListSqlPlanBaselinesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSqlPlanBaselinesResponse::builder).logger(LOG, "listSqlPlanBaselines").serviceDetails("DbManagement", "ListSqlPlanBaselines", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSqlPlanBaselines").method(Method.GET).requestBuilder(ListSqlPlanBaselinesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendQueryParam("planName", (Object)request.getPlanName()).appendQueryParam("sqlHandle", (Object)request.getSqlHandle()).appendQueryParam("sqlText", (Object)request.getSqlText()).appendQueryParam("isEnabled", (Object)request.getIsEnabled()).appendQueryParam("isAccepted", (Object)request.getIsAccepted()).appendQueryParam("isReproduced", (Object)request.getIsReproduced()).appendQueryParam("isFixed", (Object)request.getIsFixed()).appendQueryParam("isAdaptive", (Object)request.getIsAdaptive()).appendEnumQueryParam("origin", (BmcEnum)request.getOrigin()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("isAutoPurged", (Object)request.getIsAutoPurged()).appendQueryParam("timeLastExecutedGreaterThan", (Object)request.getTimeLastExecutedGreaterThan()).appendQueryParam("timeLastExecutedLessThan", (Object)request.getTimeLastExecutedLessThan()).appendQueryParam("isNeverExecuted", (Object)request.getIsNeverExecuted()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaselineCollection.class, ListSqlPlanBaselinesResponse.Builder::sqlPlanBaselineCollection).handleResponseHeaderString("opc-request-id", ListSqlPlanBaselinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSqlPlanBaselinesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListSystemPrivilegesResponse> listSystemPrivileges(ListSystemPrivilegesRequest request, AsyncHandler<ListSystemPrivilegesRequest, ListSystemPrivilegesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getUserName(), (String)"userName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListSystemPrivilegesResponse::builder).logger(LOG, "listSystemPrivileges").serviceDetails("DbManagement", "ListSystemPrivileges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListSystemPrivileges").method(Method.GET).requestBuilder(ListSystemPrivilegesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendPathParam(request.getUserName()).appendPathParam("systemPrivileges").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SystemPrivilegeCollection.class, ListSystemPrivilegesResponse.Builder::systemPrivilegeCollection).handleResponseHeaderString("opc-next-page", ListSystemPrivilegesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSystemPrivilegesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListTableStatisticsResponse> listTableStatistics(ListTableStatisticsRequest request, AsyncHandler<ListTableStatisticsRequest, ListTableStatisticsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTableStatisticsResponse::builder).logger(LOG, "listTableStatistics").serviceDetails("DbManagement", "ListTableStatistics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListTableStatistics").method(Method.GET).requestBuilder(ListTableStatisticsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tableStatistics").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(TableStatisticsCollection.class, ListTableStatisticsResponse.Builder::tableStatisticsCollection).handleResponseHeaderString("opc-request-id", ListTableStatisticsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListTablespacesResponse> listTablespaces(ListTablespacesRequest request, AsyncHandler<ListTablespacesRequest, ListTablespacesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListTablespacesResponse::builder).logger(LOG, "listTablespaces").serviceDetails("DbManagement", "ListTablespaces", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/ListTablespaces").method(Method.GET).requestBuilder(ListTablespacesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(TablespaceCollection.class, ListTablespacesResponse.Builder::tablespaceCollection).handleResponseHeaderString("opc-request-id", ListTablespacesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTablespacesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListUsersResponse> listUsers(ListUsersRequest request, AsyncHandler<ListUsersRequest, ListUsersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListUsersResponse::builder).logger(LOG, "listUsers").serviceDetails("DbManagement", "ListUsers", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ListUsers").method(Method.GET).requestBuilder(ListUsersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("users").appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(UserCollection.class, ListUsersResponse.Builder::userCollection).handleResponseHeaderString("opc-next-page", ListUsersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListUsersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DbManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DbManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DbManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20201101").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<LoadSqlPlanBaselinesFromAwrResponse> loadSqlPlanBaselinesFromAwr(LoadSqlPlanBaselinesFromAwrRequest request, AsyncHandler<LoadSqlPlanBaselinesFromAwrRequest, LoadSqlPlanBaselinesFromAwrResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLoadSqlPlanBaselinesFromAwrDetails(), "loadSqlPlanBaselinesFromAwrDetails is required");
        return this.clientCall(request, LoadSqlPlanBaselinesFromAwrResponse::builder).logger(LOG, "loadSqlPlanBaselinesFromAwr").serviceDetails("DbManagement", "LoadSqlPlanBaselinesFromAwr", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/LoadSqlPlanBaselinesFromAwr").method(Method.POST).requestBuilder(LoadSqlPlanBaselinesFromAwrRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("loadSqlPlanBaselinesFromAwr").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SqlPlanBaselineJob.class, LoadSqlPlanBaselinesFromAwrResponse.Builder::sqlPlanBaselineJob).handleResponseHeaderString("opc-request-id", LoadSqlPlanBaselinesFromAwrResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<LoadSqlPlanBaselinesFromCursorCacheResponse> loadSqlPlanBaselinesFromCursorCache(LoadSqlPlanBaselinesFromCursorCacheRequest request, AsyncHandler<LoadSqlPlanBaselinesFromCursorCacheRequest, LoadSqlPlanBaselinesFromCursorCacheResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getLoadSqlPlanBaselinesFromCursorCacheDetails(), "loadSqlPlanBaselinesFromCursorCacheDetails is required");
        return this.clientCall(request, LoadSqlPlanBaselinesFromCursorCacheResponse::builder).logger(LOG, "loadSqlPlanBaselinesFromCursorCache").serviceDetails("DbManagement", "LoadSqlPlanBaselinesFromCursorCache", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/LoadSqlPlanBaselinesFromCursorCache").method(Method.POST).requestBuilder(LoadSqlPlanBaselinesFromCursorCacheRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselines").appendPathParam("actions").appendPathParam("loadSqlPlanBaselinesFromCursorCache").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SqlPlanBaselineJob.class, LoadSqlPlanBaselinesFromCursorCacheResponse.Builder::sqlPlanBaselineJob).handleResponseHeaderString("opc-request-id", LoadSqlPlanBaselinesFromCursorCacheResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ModifyDatabaseManagementFeatureResponse> modifyDatabaseManagementFeature(ModifyDatabaseManagementFeatureRequest request, AsyncHandler<ModifyDatabaseManagementFeatureRequest, ModifyDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getDatabaseId(), (String)"databaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModifyDatabaseManagementFeatureDetails(), "modifyDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, ModifyDatabaseManagementFeatureResponse::builder).logger(LOG, "modifyDatabaseManagementFeature").serviceDetails("DbManagement", "ModifyDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ModifyDatabaseManagementFeature").method(Method.POST).requestBuilder(ModifyDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("databases").appendPathParam(request.getDatabaseId()).appendPathParam("actions").appendPathParam("modifyDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ModifyDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ModifyDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ModifyPluggableDatabaseManagementFeatureResponse> modifyPluggableDatabaseManagementFeature(ModifyPluggableDatabaseManagementFeatureRequest request, AsyncHandler<ModifyPluggableDatabaseManagementFeatureRequest, ModifyPluggableDatabaseManagementFeatureResponse> handler) {
        Validate.notBlank((String)request.getPluggableDatabaseId(), (String)"pluggableDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModifyPluggableDatabaseManagementFeatureDetails(), "modifyPluggableDatabaseManagementFeatureDetails is required");
        return this.clientCall(request, ModifyPluggableDatabaseManagementFeatureResponse::builder).logger(LOG, "modifyPluggableDatabaseManagementFeature").serviceDetails("DbManagement", "ModifyPluggableDatabaseManagementFeature", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ModifyPluggableDatabaseManagementFeature").method(Method.POST).requestBuilder(ModifyPluggableDatabaseManagementFeatureRequest::builder).basePath("/20201101").appendPathParam("pluggabledatabases").appendPathParam(request.getPluggableDatabaseId()).appendPathParam("actions").appendPathParam("modifyDatabaseManagement").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ModifyPluggableDatabaseManagementFeatureResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ModifyPluggableDatabaseManagementFeatureResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<PatchExternalDbSystemDiscoveryResponse> patchExternalDbSystemDiscovery(PatchExternalDbSystemDiscoveryRequest request, AsyncHandler<PatchExternalDbSystemDiscoveryRequest, PatchExternalDbSystemDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemDiscoveryId(), (String)"externalDbSystemDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchExternalDbSystemDiscoveryDetails(), "patchExternalDbSystemDiscoveryDetails is required");
        return this.clientCall(request, PatchExternalDbSystemDiscoveryResponse::builder).logger(LOG, "patchExternalDbSystemDiscovery").serviceDetails("DbManagement", "PatchExternalDbSystemDiscovery", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/PatchExternalDbSystemDiscovery").method(Method.PATCH).requestBuilder(PatchExternalDbSystemDiscoveryRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").appendPathParam(request.getExternalDbSystemDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalDbSystemDiscovery.class, PatchExternalDbSystemDiscoveryResponse.Builder::externalDbSystemDiscovery).handleResponseHeaderString("etag", PatchExternalDbSystemDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PatchExternalDbSystemDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveDataFileResponse> removeDataFile(RemoveDataFileRequest request, AsyncHandler<RemoveDataFileRequest, RemoveDataFileResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDataFileDetails(), "removeDataFileDetails is required");
        return this.clientCall(request, RemoveDataFileResponse::builder).logger(LOG, "removeDataFile").serviceDetails("DbManagement", "RemoveDataFile", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/RemoveDataFile").method(Method.POST).requestBuilder(RemoveDataFileRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("removeDataFile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, RemoveDataFileResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", RemoveDataFileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveManagedDatabaseFromManagedDatabaseGroupResponse> removeManagedDatabaseFromManagedDatabaseGroup(RemoveManagedDatabaseFromManagedDatabaseGroupRequest request, AsyncHandler<RemoveManagedDatabaseFromManagedDatabaseGroupRequest, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveManagedDatabaseFromManagedDatabaseGroupDetails(), "removeManagedDatabaseFromManagedDatabaseGroupDetails is required");
        return this.clientCall(request, RemoveManagedDatabaseFromManagedDatabaseGroupResponse::builder).logger(LOG, "removeManagedDatabaseFromManagedDatabaseGroup").serviceDetails("DbManagement", "RemoveManagedDatabaseFromManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/RemoveManagedDatabaseFromManagedDatabaseGroup").method(Method.POST).requestBuilder(RemoveManagedDatabaseFromManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).appendPathParam("actions").appendPathParam("removeManagedDatabase").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", RemoveManagedDatabaseFromManagedDatabaseGroupResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResetDatabaseParametersResponse> resetDatabaseParameters(ResetDatabaseParametersRequest request, AsyncHandler<ResetDatabaseParametersRequest, ResetDatabaseParametersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResetDatabaseParametersDetails(), "resetDatabaseParametersDetails is required");
        return this.clientCall(request, ResetDatabaseParametersResponse::builder).logger(LOG, "resetDatabaseParameters").serviceDetails("DbManagement", "ResetDatabaseParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/ResetDatabaseParameters").method(Method.POST).requestBuilder(ResetDatabaseParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("resetDatabaseParameters").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(UpdateDatabaseParametersResult.class, ResetDatabaseParametersResponse.Builder::updateDatabaseParametersResult).handleResponseHeaderString("opc-request-id", ResetDatabaseParametersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResizeDataFileResponse> resizeDataFile(ResizeDataFileRequest request, AsyncHandler<ResizeDataFileRequest, ResizeDataFileResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getResizeDataFileDetails(), "resizeDataFileDetails is required");
        return this.clientCall(request, ResizeDataFileResponse::builder).logger(LOG, "resizeDataFile").serviceDetails("DbManagement", "ResizeDataFile", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/ResizeDataFile").method(Method.POST).requestBuilder(ResizeDataFileRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).appendPathParam("actions").appendPathParam("resizeDataFile").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(TablespaceAdminStatus.class, ResizeDataFileResponse.Builder::tablespaceAdminStatus).handleResponseHeaderString("opc-request-id", ResizeDataFileResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RunHistoricAddmResponse> runHistoricAddm(RunHistoricAddmRequest request, AsyncHandler<RunHistoricAddmRequest, RunHistoricAddmResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRunHistoricAddmDetails(), "runHistoricAddmDetails is required");
        return this.clientCall(request, RunHistoricAddmResponse::builder).logger(LOG, "runHistoricAddm").serviceDetails("DbManagement", "RunHistoricAddm", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/HistoricAddmResult/RunHistoricAddm").method(Method.POST).requestBuilder(RunHistoricAddmRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("actions").appendPathParam("runHistoricAddm").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).hasBody().handleBody(HistoricAddmResult.class, RunHistoricAddmResponse.Builder::historicAddmResult).handleResponseHeaderString("opc-request-id", RunHistoricAddmResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbCpuUsagesResponse> summarizeAwrDbCpuUsages(SummarizeAwrDbCpuUsagesRequest request, AsyncHandler<SummarizeAwrDbCpuUsagesRequest, SummarizeAwrDbCpuUsagesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeAwrDbCpuUsagesResponse::builder).logger(LOG, "summarizeAwrDbCpuUsages").serviceDetails("DbManagement", "SummarizeAwrDbCpuUsages", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbCpuUsages").method(Method.GET).requestBuilder(SummarizeAwrDbCpuUsagesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbCpuUsages").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbCpuUsageCollection.class, SummarizeAwrDbCpuUsagesResponse.Builder::awrDbCpuUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbCpuUsagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbCpuUsagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbMetricsResponse> summarizeAwrDbMetrics(SummarizeAwrDbMetricsRequest request, AsyncHandler<SummarizeAwrDbMetricsRequest, SummarizeAwrDbMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return this.clientCall(request, SummarizeAwrDbMetricsResponse::builder).logger(LOG, "summarizeAwrDbMetrics").serviceDetails("DbManagement", "SummarizeAwrDbMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbMetrics").method(Method.GET).requestBuilder(SummarizeAwrDbMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbMetrics").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbMetricCollection.class, SummarizeAwrDbMetricsResponse.Builder::awrDbMetricCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbParameterChangesResponse> summarizeAwrDbParameterChanges(SummarizeAwrDbParameterChangesRequest request, AsyncHandler<SummarizeAwrDbParameterChangesRequest, SummarizeAwrDbParameterChangesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return this.clientCall(request, SummarizeAwrDbParameterChangesResponse::builder).logger(LOG, "summarizeAwrDbParameterChanges").serviceDetails("DbManagement", "SummarizeAwrDbParameterChanges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbParameterChanges").method(Method.GET).requestBuilder(SummarizeAwrDbParameterChangesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbParameterChanges").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbParameterChangeCollection.class, SummarizeAwrDbParameterChangesResponse.Builder::awrDbParameterChangeCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbParameterChangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbParameterChangesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbParametersResponse> summarizeAwrDbParameters(SummarizeAwrDbParametersRequest request, AsyncHandler<SummarizeAwrDbParametersRequest, SummarizeAwrDbParametersResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeAwrDbParametersResponse::builder).logger(LOG, "summarizeAwrDbParameters").serviceDetails("DbManagement", "SummarizeAwrDbParameters", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbParameters").method(Method.GET).requestBuilder(SummarizeAwrDbParametersRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbParameters").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("containerId", (Object)request.getContainerId()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("nameContains", (Object)request.getNameContains()).appendEnumQueryParam("valueChanged", (BmcEnum)request.getValueChanged()).appendEnumQueryParam("valueDefault", (BmcEnum)request.getValueDefault()).appendEnumQueryParam("valueModified", (BmcEnum)request.getValueModified()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbParameterCollection.class, SummarizeAwrDbParametersResponse.Builder::awrDbParameterCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbParametersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbParametersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbSnapshotRangesResponse> summarizeAwrDbSnapshotRanges(SummarizeAwrDbSnapshotRangesRequest request, AsyncHandler<SummarizeAwrDbSnapshotRangesRequest, SummarizeAwrDbSnapshotRangesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeAwrDbSnapshotRangesResponse::builder).logger(LOG, "summarizeAwrDbSnapshotRanges").serviceDetails("DbManagement", "SummarizeAwrDbSnapshotRanges", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbSnapshotRanges").method(Method.GET).requestBuilder(SummarizeAwrDbSnapshotRangesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbSnapshotRanges").appendQueryParam("name", (Object)request.getName()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbSnapshotRangeCollection.class, SummarizeAwrDbSnapshotRangesResponse.Builder::awrDbSnapshotRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbSnapshotRangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbSnapshotRangesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbSysstatsResponse> summarizeAwrDbSysstats(SummarizeAwrDbSysstatsRequest request, AsyncHandler<SummarizeAwrDbSysstatsRequest, SummarizeAwrDbSysstatsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return this.clientCall(request, SummarizeAwrDbSysstatsResponse::builder).logger(LOG, "summarizeAwrDbSysstats").serviceDetails("DbManagement", "SummarizeAwrDbSysstats", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbSysstats").method(Method.GET).requestBuilder(SummarizeAwrDbSysstatsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbSysstats").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbSysstatCollection.class, SummarizeAwrDbSysstatsResponse.Builder::awrDbSysstatCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbSysstatsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbSysstatsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbTopWaitEventsResponse> summarizeAwrDbTopWaitEvents(SummarizeAwrDbTopWaitEventsRequest request, AsyncHandler<SummarizeAwrDbTopWaitEventsRequest, SummarizeAwrDbTopWaitEventsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeAwrDbTopWaitEventsResponse::builder).logger(LOG, "summarizeAwrDbTopWaitEvents").serviceDetails("DbManagement", "SummarizeAwrDbTopWaitEvents", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbTopWaitEvents").method(Method.GET).requestBuilder(SummarizeAwrDbTopWaitEventsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbTopWaitEvents").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("topN", (Object)request.getTopN()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbTopWaitEventCollection.class, SummarizeAwrDbTopWaitEventsResponse.Builder::awrDbTopWaitEventCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbTopWaitEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbTopWaitEventsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbWaitEventBucketsResponse> summarizeAwrDbWaitEventBuckets(SummarizeAwrDbWaitEventBucketsRequest request, AsyncHandler<SummarizeAwrDbWaitEventBucketsRequest, SummarizeAwrDbWaitEventBucketsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getName(), "name is required");
        return this.clientCall(request, SummarizeAwrDbWaitEventBucketsResponse::builder).logger(LOG, "summarizeAwrDbWaitEventBuckets").serviceDetails("DbManagement", "SummarizeAwrDbWaitEventBuckets", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbWaitEventBuckets").method(Method.GET).requestBuilder(SummarizeAwrDbWaitEventBucketsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbWaitEventBuckets").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("numBucket", (Object)request.getNumBucket()).appendQueryParam("minValue", (Object)request.getMinValue()).appendQueryParam("maxValue", (Object)request.getMaxValue()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbWaitEventBucketCollection.class, SummarizeAwrDbWaitEventBucketsResponse.Builder::awrDbWaitEventBucketCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbWaitEventBucketsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbWaitEventBucketsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAwrDbWaitEventsResponse> summarizeAwrDbWaitEvents(SummarizeAwrDbWaitEventsRequest request, AsyncHandler<SummarizeAwrDbWaitEventsRequest, SummarizeAwrDbWaitEventsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAwrDbId(), (String)"awrDbId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeAwrDbWaitEventsResponse::builder).logger(LOG, "summarizeAwrDbWaitEvents").serviceDetails("DbManagement", "SummarizeAwrDbWaitEvents", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeAwrDbWaitEvents").method(Method.GET).requestBuilder(SummarizeAwrDbWaitEventsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("awrDbs").appendPathParam(request.getAwrDbId()).appendPathParam("awrDbWaitEvents").appendQueryParam("instNum", (Object)request.getInstNum()).appendQueryParam("beginSnIdGreaterThanOrEqualTo", (Object)request.getBeginSnIdGreaterThanOrEqualTo()).appendQueryParam("endSnIdLessThanOrEqualTo", (Object)request.getEndSnIdLessThanOrEqualTo()).appendQueryParam("timeGreaterThanOrEqualTo", (Object)request.getTimeGreaterThanOrEqualTo()).appendQueryParam("timeLessThanOrEqualTo", (Object)request.getTimeLessThanOrEqualTo()).appendListQueryParam("name", request.getName(), CollectionFormatType.Multi).appendEnumQueryParam("sessionType", (BmcEnum)request.getSessionType()).appendQueryParam("containerId", (Object)request.getContainerId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(AwrDbWaitEventCollection.class, SummarizeAwrDbWaitEventsResponse.Builder::awrDbWaitEventCollection).handleResponseHeaderString("opc-request-id", SummarizeAwrDbWaitEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAwrDbWaitEventsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeExternalAsmMetricsResponse> summarizeExternalAsmMetrics(SummarizeExternalAsmMetricsRequest request, AsyncHandler<SummarizeExternalAsmMetricsRequest, SummarizeExternalAsmMetricsResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeExternalAsmMetricsResponse::builder).logger(LOG, "summarizeExternalAsmMetrics").serviceDetails("DbManagement", "SummarizeExternalAsmMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/SummarizeExternalAsmMetrics").method(Method.GET).requestBuilder(SummarizeExternalAsmMetricsRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).appendPathParam("metrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeExternalAsmMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeExternalAsmMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeExternalAsmMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeExternalClusterMetricsResponse> summarizeExternalClusterMetrics(SummarizeExternalClusterMetricsRequest request, AsyncHandler<SummarizeExternalClusterMetricsRequest, SummarizeExternalClusterMetricsResponse> handler) {
        Validate.notBlank((String)request.getExternalClusterId(), (String)"externalClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeExternalClusterMetricsResponse::builder).logger(LOG, "summarizeExternalClusterMetrics").serviceDetails("DbManagement", "SummarizeExternalClusterMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalCluster/SummarizeExternalClusterMetrics").method(Method.GET).requestBuilder(SummarizeExternalClusterMetricsRequest::builder).basePath("/20201101").appendPathParam("externalClusters").appendPathParam(request.getExternalClusterId()).appendPathParam("metrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeExternalClusterMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeExternalClusterMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeExternalClusterMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeExternalDbNodeMetricsResponse> summarizeExternalDbNodeMetrics(SummarizeExternalDbNodeMetricsRequest request, AsyncHandler<SummarizeExternalDbNodeMetricsRequest, SummarizeExternalDbNodeMetricsResponse> handler) {
        Validate.notBlank((String)request.getExternalDbNodeId(), (String)"externalDbNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeExternalDbNodeMetricsResponse::builder).logger(LOG, "summarizeExternalDbNodeMetrics").serviceDetails("DbManagement", "SummarizeExternalDbNodeMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbNode/SummarizeExternalDbNodeMetrics").method(Method.GET).requestBuilder(SummarizeExternalDbNodeMetricsRequest::builder).basePath("/20201101").appendPathParam("externalDbNodes").appendPathParam(request.getExternalDbNodeId()).appendPathParam("metrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeExternalDbNodeMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeExternalDbNodeMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeExternalDbNodeMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeExternalDbSystemAvailabilityMetricsResponse> summarizeExternalDbSystemAvailabilityMetrics(SummarizeExternalDbSystemAvailabilityMetricsRequest request, AsyncHandler<SummarizeExternalDbSystemAvailabilityMetricsRequest, SummarizeExternalDbSystemAvailabilityMetricsResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeExternalDbSystemAvailabilityMetricsResponse::builder).logger(LOG, "summarizeExternalDbSystemAvailabilityMetrics").serviceDetails("DbManagement", "SummarizeExternalDbSystemAvailabilityMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/SummarizeExternalDbSystemAvailabilityMetrics").method(Method.GET).requestBuilder(SummarizeExternalDbSystemAvailabilityMetricsRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).appendPathParam("availabilityMetrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("filterByComponentTypes", (Object)request.getFilterByComponentTypes()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeExternalDbSystemAvailabilityMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeExternalDbSystemAvailabilityMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeExternalDbSystemAvailabilityMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeExternalListenerMetricsResponse> summarizeExternalListenerMetrics(SummarizeExternalListenerMetricsRequest request, AsyncHandler<SummarizeExternalListenerMetricsRequest, SummarizeExternalListenerMetricsResponse> handler) {
        Validate.notBlank((String)request.getExternalListenerId(), (String)"externalListenerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeExternalListenerMetricsResponse::builder).logger(LOG, "summarizeExternalListenerMetrics").serviceDetails("DbManagement", "SummarizeExternalListenerMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalListener/SummarizeExternalListenerMetrics").method(Method.GET).requestBuilder(SummarizeExternalListenerMetricsRequest::builder).basePath("/20201101").appendPathParam("externalListeners").appendPathParam(request.getExternalListenerId()).appendPathParam("metrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("filterByMetricNames", (Object)request.getFilterByMetricNames()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeExternalListenerMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeExternalListenerMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeExternalListenerMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeJobExecutionsStatusesResponse> summarizeJobExecutionsStatuses(SummarizeJobExecutionsStatusesRequest request, AsyncHandler<SummarizeJobExecutionsStatusesRequest, SummarizeJobExecutionsStatusesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeJobExecutionsStatusesResponse::builder).logger(LOG, "summarizeJobExecutionsStatuses").serviceDetails("DbManagement", "SummarizeJobExecutionsStatuses", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/JobExecutionsStatusSummaryCollection/SummarizeJobExecutionsStatuses").method(Method.GET).requestBuilder(SummarizeJobExecutionsStatusesRequest::builder).basePath("/20201101").appendPathParam("jobExecutionsStatus").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("managedDatabaseGroupId", (Object)request.getManagedDatabaseGroupId()).appendQueryParam("managedDatabaseId", (Object)request.getManagedDatabaseId()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobExecutionsStatusSummaryCollection.class, SummarizeJobExecutionsStatusesResponse.Builder::jobExecutionsStatusSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeJobExecutionsStatusesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SummarizeManagedDatabaseAvailabilityMetricsResponse> summarizeManagedDatabaseAvailabilityMetrics(SummarizeManagedDatabaseAvailabilityMetricsRequest request, AsyncHandler<SummarizeManagedDatabaseAvailabilityMetricsRequest, SummarizeManagedDatabaseAvailabilityMetricsResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartTime(), "startTime is required");
        Objects.requireNonNull(request.getEndTime(), "endTime is required");
        return this.clientCall(request, SummarizeManagedDatabaseAvailabilityMetricsResponse::builder).logger(LOG, "summarizeManagedDatabaseAvailabilityMetrics").serviceDetails("DbManagement", "SummarizeManagedDatabaseAvailabilityMetrics", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeManagedDatabaseAvailabilityMetrics").method(Method.GET).requestBuilder(SummarizeManagedDatabaseAvailabilityMetricsRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("availabilityMetrics").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("startTime", (Object)request.getStartTime()).appendQueryParam("endTime", (Object)request.getEndTime()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MetricsAggregationRangeCollection.class, SummarizeManagedDatabaseAvailabilityMetricsResponse.Builder::metricsAggregationRangeCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedDatabaseAvailabilityMetricsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedDatabaseAvailabilityMetricsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeSqlPlanBaselinesResponse> summarizeSqlPlanBaselines(SummarizeSqlPlanBaselinesRequest request, AsyncHandler<SummarizeSqlPlanBaselinesRequest, SummarizeSqlPlanBaselinesResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeSqlPlanBaselinesResponse::builder).logger(LOG, "summarizeSqlPlanBaselines").serviceDetails("DbManagement", "SummarizeSqlPlanBaselines", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeSqlPlanBaselines").method(Method.GET).requestBuilder(SummarizeSqlPlanBaselinesRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselineStats").appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaselineAggregationCollection.class, SummarizeSqlPlanBaselinesResponse.Builder::sqlPlanBaselineAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeSqlPlanBaselinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeSqlPlanBaselinesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeSqlPlanBaselinesByLastExecutionResponse> summarizeSqlPlanBaselinesByLastExecution(SummarizeSqlPlanBaselinesByLastExecutionRequest request, AsyncHandler<SummarizeSqlPlanBaselinesByLastExecutionRequest, SummarizeSqlPlanBaselinesByLastExecutionResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SummarizeSqlPlanBaselinesByLastExecutionResponse::builder).logger(LOG, "summarizeSqlPlanBaselinesByLastExecution").serviceDetails("DbManagement", "SummarizeSqlPlanBaselinesByLastExecution", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/SummarizeSqlPlanBaselinesByLastExecution").method(Method.GET).requestBuilder(SummarizeSqlPlanBaselinesByLastExecutionRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("sqlPlanBaselineExecutionStats").appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-named-credential-id", request.getOpcNamedCredentialId()).handleBody(SqlPlanBaselineAggregationCollection.class, SummarizeSqlPlanBaselinesByLastExecutionResponse.Builder::sqlPlanBaselineAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeSqlPlanBaselinesByLastExecutionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeSqlPlanBaselinesByLastExecutionResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<TestNamedCredentialResponse> testNamedCredential(TestNamedCredentialRequest request, AsyncHandler<TestNamedCredentialRequest, TestNamedCredentialResponse> handler) {
        Validate.notBlank((String)request.getNamedCredentialId(), (String)"namedCredentialId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTestNamedCredentialDetails(), "testNamedCredentialDetails is required");
        return this.clientCall(request, TestNamedCredentialResponse::builder).logger(LOG, "testNamedCredential").serviceDetails("DbManagement", "TestNamedCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/TestNamedCredential").method(Method.POST).requestBuilder(TestNamedCredentialRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendPathParam(request.getNamedCredentialId()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TestNamedCredentialStatus.class, TestNamedCredentialResponse.Builder::testNamedCredentialStatus).handleResponseHeaderString("opc-request-id", TestNamedCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<TestPreferredCredentialResponse> testPreferredCredential(TestPreferredCredentialRequest request, AsyncHandler<TestPreferredCredentialRequest, TestPreferredCredentialResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, TestPreferredCredentialResponse::builder).logger(LOG, "testPreferredCredential").serviceDetails("DbManagement", "TestPreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/TestPreferredCredential").method(Method.POST).requestBuilder(TestPreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).appendPathParam("actions").appendPathParam("test").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(TestPreferredCredentialStatus.class, TestPreferredCredentialResponse.Builder::testPreferredCredentialStatus).handleResponseHeaderString("opc-request-id", TestPreferredCredentialResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDbManagementPrivateEndpointResponse> updateDbManagementPrivateEndpoint(UpdateDbManagementPrivateEndpointRequest request, AsyncHandler<UpdateDbManagementPrivateEndpointRequest, UpdateDbManagementPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getDbManagementPrivateEndpointId(), (String)"dbManagementPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDbManagementPrivateEndpointDetails(), "updateDbManagementPrivateEndpointDetails is required");
        return this.clientCall(request, UpdateDbManagementPrivateEndpointResponse::builder).logger(LOG, "updateDbManagementPrivateEndpoint").serviceDetails("DbManagement", "UpdateDbManagementPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/DbManagementPrivateEndpoint/UpdateDbManagementPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateDbManagementPrivateEndpointRequest::builder).basePath("/20201101").appendPathParam("dbManagementPrivateEndpoints").appendPathParam(request.getDbManagementPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(DbManagementPrivateEndpoint.class, UpdateDbManagementPrivateEndpointResponse.Builder::dbManagementPrivateEndpoint).handleResponseHeaderString("opc-request-id", UpdateDbManagementPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDbManagementPrivateEndpointResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalAsmResponse> updateExternalAsm(UpdateExternalAsmRequest request, AsyncHandler<UpdateExternalAsmRequest, UpdateExternalAsmResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmId(), (String)"externalAsmId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalAsmDetails(), "updateExternalAsmDetails is required");
        return this.clientCall(request, UpdateExternalAsmResponse::builder).logger(LOG, "updateExternalAsm").serviceDetails("DbManagement", "UpdateExternalAsm", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsm/UpdateExternalAsm").method(Method.PUT).requestBuilder(UpdateExternalAsmRequest::builder).basePath("/20201101").appendPathParam("externalAsms").appendPathParam(request.getExternalAsmId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalAsmResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalAsmResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalAsmInstanceResponse> updateExternalAsmInstance(UpdateExternalAsmInstanceRequest request, AsyncHandler<UpdateExternalAsmInstanceRequest, UpdateExternalAsmInstanceResponse> handler) {
        Validate.notBlank((String)request.getExternalAsmInstanceId(), (String)"externalAsmInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalAsmInstanceDetails(), "updateExternalAsmInstanceDetails is required");
        return this.clientCall(request, UpdateExternalAsmInstanceResponse::builder).logger(LOG, "updateExternalAsmInstance").serviceDetails("DbManagement", "UpdateExternalAsmInstance", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalAsmInstance/UpdateExternalAsmInstance").method(Method.PUT).requestBuilder(UpdateExternalAsmInstanceRequest::builder).basePath("/20201101").appendPathParam("externalAsmInstances").appendPathParam(request.getExternalAsmInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalAsmInstance.class, UpdateExternalAsmInstanceResponse.Builder::externalAsmInstance).handleResponseHeaderString("opc-request-id", UpdateExternalAsmInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateExternalAsmInstanceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalClusterResponse> updateExternalCluster(UpdateExternalClusterRequest request, AsyncHandler<UpdateExternalClusterRequest, UpdateExternalClusterResponse> handler) {
        Validate.notBlank((String)request.getExternalClusterId(), (String)"externalClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalClusterDetails(), "updateExternalClusterDetails is required");
        return this.clientCall(request, UpdateExternalClusterResponse::builder).logger(LOG, "updateExternalCluster").serviceDetails("DbManagement", "UpdateExternalCluster", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalCluster/UpdateExternalCluster").method(Method.PUT).requestBuilder(UpdateExternalClusterRequest::builder).basePath("/20201101").appendPathParam("externalClusters").appendPathParam(request.getExternalClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalClusterResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalClusterResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalClusterInstanceResponse> updateExternalClusterInstance(UpdateExternalClusterInstanceRequest request, AsyncHandler<UpdateExternalClusterInstanceRequest, UpdateExternalClusterInstanceResponse> handler) {
        Validate.notBlank((String)request.getExternalClusterInstanceId(), (String)"externalClusterInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalClusterInstanceDetails(), "updateExternalClusterInstanceDetails is required");
        return this.clientCall(request, UpdateExternalClusterInstanceResponse::builder).logger(LOG, "updateExternalClusterInstance").serviceDetails("DbManagement", "UpdateExternalClusterInstance", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalClusterInstance/UpdateExternalClusterInstance").method(Method.PUT).requestBuilder(UpdateExternalClusterInstanceRequest::builder).basePath("/20201101").appendPathParam("externalClusterInstances").appendPathParam(request.getExternalClusterInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalClusterInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalClusterInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalDbHomeResponse> updateExternalDbHome(UpdateExternalDbHomeRequest request, AsyncHandler<UpdateExternalDbHomeRequest, UpdateExternalDbHomeResponse> handler) {
        Validate.notBlank((String)request.getExternalDbHomeId(), (String)"externalDbHomeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalDbHomeDetails(), "updateExternalDbHomeDetails is required");
        return this.clientCall(request, UpdateExternalDbHomeResponse::builder).logger(LOG, "updateExternalDbHome").serviceDetails("DbManagement", "UpdateExternalDbHome", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbHome/UpdateExternalDbHome").method(Method.PUT).requestBuilder(UpdateExternalDbHomeRequest::builder).basePath("/20201101").appendPathParam("externalDbHomes").appendPathParam(request.getExternalDbHomeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalDbHome.class, UpdateExternalDbHomeResponse.Builder::externalDbHome).handleResponseHeaderString("opc-request-id", UpdateExternalDbHomeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateExternalDbHomeResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalDbNodeResponse> updateExternalDbNode(UpdateExternalDbNodeRequest request, AsyncHandler<UpdateExternalDbNodeRequest, UpdateExternalDbNodeResponse> handler) {
        Validate.notBlank((String)request.getExternalDbNodeId(), (String)"externalDbNodeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalDbNodeDetails(), "updateExternalDbNodeDetails is required");
        return this.clientCall(request, UpdateExternalDbNodeResponse::builder).logger(LOG, "updateExternalDbNode").serviceDetails("DbManagement", "UpdateExternalDbNode", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbNode/UpdateExternalDbNode").method(Method.PUT).requestBuilder(UpdateExternalDbNodeRequest::builder).basePath("/20201101").appendPathParam("externalDbNodes").appendPathParam(request.getExternalDbNodeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalDbNodeResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalDbNodeResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalDbSystemResponse> updateExternalDbSystem(UpdateExternalDbSystemRequest request, AsyncHandler<UpdateExternalDbSystemRequest, UpdateExternalDbSystemResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemId(), (String)"externalDbSystemId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalDbSystemDetails(), "updateExternalDbSystemDetails is required");
        return this.clientCall(request, UpdateExternalDbSystemResponse::builder).logger(LOG, "updateExternalDbSystem").serviceDetails("DbManagement", "UpdateExternalDbSystem", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystem/UpdateExternalDbSystem").method(Method.PUT).requestBuilder(UpdateExternalDbSystemRequest::builder).basePath("/20201101").appendPathParam("externalDbSystems").appendPathParam(request.getExternalDbSystemId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalDbSystem.class, UpdateExternalDbSystemResponse.Builder::externalDbSystem).handleResponseHeaderString("opc-request-id", UpdateExternalDbSystemResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateExternalDbSystemResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalDbSystemConnectorResponse> updateExternalDbSystemConnector(UpdateExternalDbSystemConnectorRequest request, AsyncHandler<UpdateExternalDbSystemConnectorRequest, UpdateExternalDbSystemConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemConnectorId(), (String)"externalDbSystemConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalDbSystemConnectorDetails(), "updateExternalDbSystemConnectorDetails is required");
        return this.clientCall(request, UpdateExternalDbSystemConnectorResponse::builder).logger(LOG, "updateExternalDbSystemConnector").serviceDetails("DbManagement", "UpdateExternalDbSystemConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemConnector/UpdateExternalDbSystemConnector").method(Method.PUT).requestBuilder(UpdateExternalDbSystemConnectorRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemConnectors").appendPathParam(request.getExternalDbSystemConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalDbSystemConnectorResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalDbSystemConnectorResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalDbSystemDiscoveryResponse> updateExternalDbSystemDiscovery(UpdateExternalDbSystemDiscoveryRequest request, AsyncHandler<UpdateExternalDbSystemDiscoveryRequest, UpdateExternalDbSystemDiscoveryResponse> handler) {
        Validate.notBlank((String)request.getExternalDbSystemDiscoveryId(), (String)"externalDbSystemDiscoveryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalDbSystemDiscoveryDetails(), "updateExternalDbSystemDiscoveryDetails is required");
        return this.clientCall(request, UpdateExternalDbSystemDiscoveryResponse::builder).logger(LOG, "updateExternalDbSystemDiscovery").serviceDetails("DbManagement", "UpdateExternalDbSystemDiscovery", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalDbSystemDiscovery/UpdateExternalDbSystemDiscovery").method(Method.PUT).requestBuilder(UpdateExternalDbSystemDiscoveryRequest::builder).basePath("/20201101").appendPathParam("externalDbSystemDiscoveries").appendPathParam(request.getExternalDbSystemDiscoveryId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalDbSystemDiscovery.class, UpdateExternalDbSystemDiscoveryResponse.Builder::externalDbSystemDiscovery).handleResponseHeaderString("etag", UpdateExternalDbSystemDiscoveryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExternalDbSystemDiscoveryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalExadataInfrastructureResponse> updateExternalExadataInfrastructure(UpdateExternalExadataInfrastructureRequest request, AsyncHandler<UpdateExternalExadataInfrastructureRequest, UpdateExternalExadataInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataInfrastructureId(), (String)"externalExadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalExadataInfrastructureDetails(), "updateExternalExadataInfrastructureDetails is required");
        return this.clientCall(request, UpdateExternalExadataInfrastructureResponse::builder).logger(LOG, "updateExternalExadataInfrastructure").serviceDetails("DbManagement", "UpdateExternalExadataInfrastructure", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataInfrastructure/UpdateExternalExadataInfrastructure").method(Method.PUT).requestBuilder(UpdateExternalExadataInfrastructureRequest::builder).basePath("/20201101").appendPathParam("externalExadataInfrastructures").appendPathParam(request.getExternalExadataInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ExternalExadataInfrastructure.class, UpdateExternalExadataInfrastructureResponse.Builder::externalExadataInfrastructure).handleResponseHeaderString("opc-request-id", UpdateExternalExadataInfrastructureResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateExternalExadataInfrastructureResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalExadataStorageConnectorResponse> updateExternalExadataStorageConnector(UpdateExternalExadataStorageConnectorRequest request, AsyncHandler<UpdateExternalExadataStorageConnectorRequest, UpdateExternalExadataStorageConnectorResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageConnectorId(), (String)"externalExadataStorageConnectorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalExadataStorageConnectorDetails(), "updateExternalExadataStorageConnectorDetails is required");
        return this.clientCall(request, UpdateExternalExadataStorageConnectorResponse::builder).logger(LOG, "updateExternalExadataStorageConnector").serviceDetails("DbManagement", "UpdateExternalExadataStorageConnector", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageConnector/UpdateExternalExadataStorageConnector").method(Method.PUT).requestBuilder(UpdateExternalExadataStorageConnectorRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageConnectors").appendPathParam(request.getExternalExadataStorageConnectorId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ExternalExadataStorageConnector.class, UpdateExternalExadataStorageConnectorResponse.Builder::externalExadataStorageConnector).handleResponseHeaderString("opc-request-id", UpdateExternalExadataStorageConnectorResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateExternalExadataStorageConnectorResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalExadataStorageGridResponse> updateExternalExadataStorageGrid(UpdateExternalExadataStorageGridRequest request, AsyncHandler<UpdateExternalExadataStorageGridRequest, UpdateExternalExadataStorageGridResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageGridId(), (String)"externalExadataStorageGridId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalExadataStorageGridDetails(), "updateExternalExadataStorageGridDetails is required");
        return this.clientCall(request, UpdateExternalExadataStorageGridResponse::builder).logger(LOG, "updateExternalExadataStorageGrid").serviceDetails("DbManagement", "UpdateExternalExadataStorageGrid", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageGrid/UpdateExternalExadataStorageGrid").method(Method.PUT).requestBuilder(UpdateExternalExadataStorageGridRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageGrids").appendPathParam(request.getExternalExadataStorageGridId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalExadataStorageGrid.class, UpdateExternalExadataStorageGridResponse.Builder::externalExadataStorageGrid).handleResponseHeaderString("etag", UpdateExternalExadataStorageGridResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExternalExadataStorageGridResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalExadataStorageServerResponse> updateExternalExadataStorageServer(UpdateExternalExadataStorageServerRequest request, AsyncHandler<UpdateExternalExadataStorageServerRequest, UpdateExternalExadataStorageServerResponse> handler) {
        Validate.notBlank((String)request.getExternalExadataStorageServerId(), (String)"externalExadataStorageServerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalExadataStorageServerDetails(), "updateExternalExadataStorageServerDetails is required");
        return this.clientCall(request, UpdateExternalExadataStorageServerResponse::builder).logger(LOG, "updateExternalExadataStorageServer").serviceDetails("DbManagement", "UpdateExternalExadataStorageServer", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalExadataStorageServer/UpdateExternalExadataStorageServer").method(Method.PUT).requestBuilder(UpdateExternalExadataStorageServerRequest::builder).basePath("/20201101").appendPathParam("externalExadataStorageServers").appendPathParam(request.getExternalExadataStorageServerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ExternalExadataStorageServer.class, UpdateExternalExadataStorageServerResponse.Builder::externalExadataStorageServer).handleResponseHeaderString("etag", UpdateExternalExadataStorageServerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExternalExadataStorageServerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateExternalListenerResponse> updateExternalListener(UpdateExternalListenerRequest request, AsyncHandler<UpdateExternalListenerRequest, UpdateExternalListenerResponse> handler) {
        Validate.notBlank((String)request.getExternalListenerId(), (String)"externalListenerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExternalListenerDetails(), "updateExternalListenerDetails is required");
        return this.clientCall(request, UpdateExternalListenerResponse::builder).logger(LOG, "updateExternalListener").serviceDetails("DbManagement", "UpdateExternalListener", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ExternalListener/UpdateExternalListener").method(Method.PUT).requestBuilder(UpdateExternalListenerRequest::builder).basePath("/20201101").appendPathParam("externalListeners").appendPathParam(request.getExternalListenerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateExternalListenerResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateExternalListenerResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateJobResponse> updateJob(UpdateJobRequest request, AsyncHandler<UpdateJobRequest, UpdateJobResponse> handler) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DbManagement", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20201101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateManagedDatabaseResponse> updateManagedDatabase(UpdateManagedDatabaseRequest request, AsyncHandler<UpdateManagedDatabaseRequest, UpdateManagedDatabaseResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedDatabaseDetails(), "updateManagedDatabaseDetails is required");
        return this.clientCall(request, UpdateManagedDatabaseResponse::builder).logger(LOG, "updateManagedDatabase").serviceDetails("DbManagement", "UpdateManagedDatabase", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabase/UpdateManagedDatabase").method(Method.PUT).requestBuilder(UpdateManagedDatabaseRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ManagedDatabase.class, UpdateManagedDatabaseResponse.Builder::managedDatabase).handleResponseHeaderString("opc-request-id", UpdateManagedDatabaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateManagedDatabaseResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateManagedDatabaseGroupResponse> updateManagedDatabaseGroup(UpdateManagedDatabaseGroupRequest request, AsyncHandler<UpdateManagedDatabaseGroupRequest, UpdateManagedDatabaseGroupResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateManagedDatabaseGroupDetails(), "updateManagedDatabaseGroupDetails is required");
        return this.clientCall(request, UpdateManagedDatabaseGroupResponse::builder).logger(LOG, "updateManagedDatabaseGroup").serviceDetails("DbManagement", "UpdateManagedDatabaseGroup", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/ManagedDatabaseGroup/UpdateManagedDatabaseGroup").method(Method.PUT).requestBuilder(UpdateManagedDatabaseGroupRequest::builder).basePath("/20201101").appendPathParam("managedDatabaseGroups").appendPathParam(request.getManagedDatabaseGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ManagedDatabaseGroup.class, UpdateManagedDatabaseGroupResponse.Builder::managedDatabaseGroup).handleResponseHeaderString("opc-request-id", UpdateManagedDatabaseGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateManagedDatabaseGroupResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateNamedCredentialResponse> updateNamedCredential(UpdateNamedCredentialRequest request, AsyncHandler<UpdateNamedCredentialRequest, UpdateNamedCredentialResponse> handler) {
        Validate.notBlank((String)request.getNamedCredentialId(), (String)"namedCredentialId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNamedCredentialDetails(), "updateNamedCredentialDetails is required");
        return this.clientCall(request, UpdateNamedCredentialResponse::builder).logger(LOG, "updateNamedCredential").serviceDetails("DbManagement", "UpdateNamedCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/NamedCredential/UpdateNamedCredential").method(Method.PUT).requestBuilder(UpdateNamedCredentialRequest::builder).basePath("/20201101").appendPathParam("namedCredentials").appendPathParam(request.getNamedCredentialId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NamedCredential.class, UpdateNamedCredentialResponse.Builder::namedCredential).handleResponseHeaderString("opc-request-id", UpdateNamedCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateNamedCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdatePreferredCredentialResponse> updatePreferredCredential(UpdatePreferredCredentialRequest request, AsyncHandler<UpdatePreferredCredentialRequest, UpdatePreferredCredentialResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCredentialName(), (String)"credentialName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePreferredCredentialDetails(), "updatePreferredCredentialDetails is required");
        return this.clientCall(request, UpdatePreferredCredentialResponse::builder).logger(LOG, "updatePreferredCredential").serviceDetails("DbManagement", "UpdatePreferredCredential", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/PreferredCredential/UpdatePreferredCredential").method(Method.PUT).requestBuilder(UpdatePreferredCredentialRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("preferredCredentials").appendPathParam(request.getCredentialName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(PreferredCredential.class, UpdatePreferredCredentialResponse.Builder::preferredCredential).handleResponseHeaderString("opc-request-id", UpdatePreferredCredentialResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdatePreferredCredentialResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateTablespaceResponse> updateTablespace(UpdateTablespaceRequest request, AsyncHandler<UpdateTablespaceRequest, UpdateTablespaceResponse> handler) {
        Validate.notBlank((String)request.getManagedDatabaseId(), (String)"managedDatabaseId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTablespaceName(), (String)"tablespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTablespaceDetails(), "updateTablespaceDetails is required");
        return this.clientCall(request, UpdateTablespaceResponse::builder).logger(LOG, "updateTablespace").serviceDetails("DbManagement", "UpdateTablespace", "https://docs.oracle.com/iaas/api/#/en/database-management/20201101/Tablespace/UpdateTablespace").method(Method.PUT).requestBuilder(UpdateTablespaceRequest::builder).basePath("/20201101").appendPathParam("managedDatabases").appendPathParam(request.getManagedDatabaseId()).appendPathParam("tablespaces").appendPathParam(request.getTablespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Tablespace.class, UpdateTablespaceResponse.Builder::tablespace).handleResponseHeaderString("opc-request-id", UpdateTablespaceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DbManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DbManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DbManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DbManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DbManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DbManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DbManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "databasemanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"databasemanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DbManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

