/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.oracle.bmc.databasemanagement.DbManagement;
import com.oracle.bmc.databasemanagement.model.ExternalAsm;
import com.oracle.bmc.databasemanagement.model.ExternalAsmInstance;
import com.oracle.bmc.databasemanagement.model.ExternalCluster;
import com.oracle.bmc.databasemanagement.model.ExternalClusterInstance;
import com.oracle.bmc.databasemanagement.model.ExternalDbHome;
import com.oracle.bmc.databasemanagement.model.ExternalDbNode;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystem;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnector;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscovery;
import com.oracle.bmc.databasemanagement.model.ExternalListener;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.LifecycleStates;
import com.oracle.bmc.databasemanagement.requests.GetDbManagementPrivateEndpointRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalAsmInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalAsmRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalClusterInstanceRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalClusterRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbHomeRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbNodeRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemConnectorRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemDiscoveryRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalDbSystemRequest;
import com.oracle.bmc.databasemanagement.requests.GetExternalListenerRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetNamedCredentialRequest;
import com.oracle.bmc.databasemanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.databasemanagement.responses.GetDbManagementPrivateEndpointResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalAsmInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalAsmResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalClusterInstanceResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalClusterResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbHomeResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbNodeResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemConnectorResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemDiscoveryResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalDbSystemResponse;
import com.oracle.bmc.databasemanagement.responses.GetExternalListenerResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetNamedCredentialResponse;
import com.oracle.bmc.databasemanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DbManagementWaiters {
    private final ExecutorService executorService;
    private final DbManagement client;

    public DbManagementWaiters(ExecutorService executorService, DbManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse> forDbManagementPrivateEndpoint(GetDbManagementPrivateEndpointRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbManagementPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse> forDbManagementPrivateEndpoint(GetDbManagementPrivateEndpointRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbManagementPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse> forDbManagementPrivateEndpoint(GetDbManagementPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbManagementPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse> forDbManagementPrivateEndpoint(BmcGenericWaiter waiter, GetDbManagementPrivateEndpointRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDbManagementPrivateEndpointRequest, GetDbManagementPrivateEndpointResponse>(){

            @Override
            public GetDbManagementPrivateEndpointResponse apply(GetDbManagementPrivateEndpointRequest request) {
                return DbManagementWaiters.this.client.getDbManagementPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetDbManagementPrivateEndpointResponse>(){

            @Override
            public boolean test(GetDbManagementPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getDbManagementPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetExternalAsmRequest, GetExternalAsmResponse> forExternalAsm(GetExternalAsmRequest request, ExternalAsm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalAsm(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalAsmRequest, GetExternalAsmResponse> forExternalAsm(GetExternalAsmRequest request, ExternalAsm.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalAsm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalAsmRequest, GetExternalAsmResponse> forExternalAsm(GetExternalAsmRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalAsm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalAsm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalAsmRequest, GetExternalAsmResponse> forExternalAsm(BmcGenericWaiter waiter, GetExternalAsmRequest request, ExternalAsm.LifecycleState ... targetStates) {
        final HashSet<ExternalAsm.LifecycleState> targetStatesSet = new HashSet<ExternalAsm.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalAsmRequest, GetExternalAsmResponse>(){

            @Override
            public GetExternalAsmResponse apply(GetExternalAsmRequest request) {
                return DbManagementWaiters.this.client.getExternalAsm(request);
            }
        }, (Predicate)new Predicate<GetExternalAsmResponse>(){

            @Override
            public boolean test(GetExternalAsmResponse response) {
                return targetStatesSet.contains((Object)response.getExternalAsm().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalAsm.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse> forExternalAsmInstance(GetExternalAsmInstanceRequest request, ExternalAsmInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalAsmInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse> forExternalAsmInstance(GetExternalAsmInstanceRequest request, ExternalAsmInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalAsmInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse> forExternalAsmInstance(GetExternalAsmInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalAsmInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalAsmInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse> forExternalAsmInstance(BmcGenericWaiter waiter, GetExternalAsmInstanceRequest request, ExternalAsmInstance.LifecycleState ... targetStates) {
        final HashSet<ExternalAsmInstance.LifecycleState> targetStatesSet = new HashSet<ExternalAsmInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalAsmInstanceRequest, GetExternalAsmInstanceResponse>(){

            @Override
            public GetExternalAsmInstanceResponse apply(GetExternalAsmInstanceRequest request) {
                return DbManagementWaiters.this.client.getExternalAsmInstance(request);
            }
        }, (Predicate)new Predicate<GetExternalAsmInstanceResponse>(){

            @Override
            public boolean test(GetExternalAsmInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getExternalAsmInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalAsmInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalClusterRequest, GetExternalClusterResponse> forExternalCluster(GetExternalClusterRequest request, ExternalCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalClusterRequest, GetExternalClusterResponse> forExternalCluster(GetExternalClusterRequest request, ExternalCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalClusterRequest, GetExternalClusterResponse> forExternalCluster(GetExternalClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalClusterRequest, GetExternalClusterResponse> forExternalCluster(BmcGenericWaiter waiter, GetExternalClusterRequest request, ExternalCluster.LifecycleState ... targetStates) {
        final HashSet<ExternalCluster.LifecycleState> targetStatesSet = new HashSet<ExternalCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalClusterRequest, GetExternalClusterResponse>(){

            @Override
            public GetExternalClusterResponse apply(GetExternalClusterRequest request) {
                return DbManagementWaiters.this.client.getExternalCluster(request);
            }
        }, (Predicate)new Predicate<GetExternalClusterResponse>(){

            @Override
            public boolean test(GetExternalClusterResponse response) {
                return targetStatesSet.contains((Object)response.getExternalCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse> forExternalClusterInstance(GetExternalClusterInstanceRequest request, ExternalClusterInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalClusterInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse> forExternalClusterInstance(GetExternalClusterInstanceRequest request, ExternalClusterInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalClusterInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse> forExternalClusterInstance(GetExternalClusterInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalClusterInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalClusterInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse> forExternalClusterInstance(BmcGenericWaiter waiter, GetExternalClusterInstanceRequest request, ExternalClusterInstance.LifecycleState ... targetStates) {
        final HashSet<ExternalClusterInstance.LifecycleState> targetStatesSet = new HashSet<ExternalClusterInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalClusterInstanceRequest, GetExternalClusterInstanceResponse>(){

            @Override
            public GetExternalClusterInstanceResponse apply(GetExternalClusterInstanceRequest request) {
                return DbManagementWaiters.this.client.getExternalClusterInstance(request);
            }
        }, (Predicate)new Predicate<GetExternalClusterInstanceResponse>(){

            @Override
            public boolean test(GetExternalClusterInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getExternalClusterInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalClusterInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalDbHomeRequest, GetExternalDbHomeResponse> forExternalDbHome(GetExternalDbHomeRequest request, ExternalDbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalDbHome(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalDbHomeRequest, GetExternalDbHomeResponse> forExternalDbHome(GetExternalDbHomeRequest request, ExternalDbHome.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalDbHome(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalDbHomeRequest, GetExternalDbHomeResponse> forExternalDbHome(GetExternalDbHomeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalDbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalDbHome(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalDbHomeRequest, GetExternalDbHomeResponse> forExternalDbHome(BmcGenericWaiter waiter, GetExternalDbHomeRequest request, ExternalDbHome.LifecycleState ... targetStates) {
        final HashSet<ExternalDbHome.LifecycleState> targetStatesSet = new HashSet<ExternalDbHome.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalDbHomeRequest, GetExternalDbHomeResponse>(){

            @Override
            public GetExternalDbHomeResponse apply(GetExternalDbHomeRequest request) {
                return DbManagementWaiters.this.client.getExternalDbHome(request);
            }
        }, (Predicate)new Predicate<GetExternalDbHomeResponse>(){

            @Override
            public boolean test(GetExternalDbHomeResponse response) {
                return targetStatesSet.contains((Object)response.getExternalDbHome().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalDbHome.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalDbNodeRequest, GetExternalDbNodeResponse> forExternalDbNode(GetExternalDbNodeRequest request, ExternalDbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalDbNode(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalDbNodeRequest, GetExternalDbNodeResponse> forExternalDbNode(GetExternalDbNodeRequest request, ExternalDbNode.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalDbNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalDbNodeRequest, GetExternalDbNodeResponse> forExternalDbNode(GetExternalDbNodeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalDbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalDbNode(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalDbNodeRequest, GetExternalDbNodeResponse> forExternalDbNode(BmcGenericWaiter waiter, GetExternalDbNodeRequest request, ExternalDbNode.LifecycleState ... targetStates) {
        final HashSet<ExternalDbNode.LifecycleState> targetStatesSet = new HashSet<ExternalDbNode.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalDbNodeRequest, GetExternalDbNodeResponse>(){

            @Override
            public GetExternalDbNodeResponse apply(GetExternalDbNodeRequest request) {
                return DbManagementWaiters.this.client.getExternalDbNode(request);
            }
        }, (Predicate)new Predicate<GetExternalDbNodeResponse>(){

            @Override
            public boolean test(GetExternalDbNodeResponse response) {
                return targetStatesSet.contains((Object)response.getExternalDbNode().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalDbNode.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalDbSystemRequest, GetExternalDbSystemResponse> forExternalDbSystem(GetExternalDbSystemRequest request, ExternalDbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalDbSystemRequest, GetExternalDbSystemResponse> forExternalDbSystem(GetExternalDbSystemRequest request, ExternalDbSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalDbSystemRequest, GetExternalDbSystemResponse> forExternalDbSystem(GetExternalDbSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalDbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystem(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalDbSystemRequest, GetExternalDbSystemResponse> forExternalDbSystem(BmcGenericWaiter waiter, GetExternalDbSystemRequest request, ExternalDbSystem.LifecycleState ... targetStates) {
        final HashSet<ExternalDbSystem.LifecycleState> targetStatesSet = new HashSet<ExternalDbSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalDbSystemRequest, GetExternalDbSystemResponse>(){

            @Override
            public GetExternalDbSystemResponse apply(GetExternalDbSystemRequest request) {
                return DbManagementWaiters.this.client.getExternalDbSystem(request);
            }
        }, (Predicate)new Predicate<GetExternalDbSystemResponse>(){

            @Override
            public boolean test(GetExternalDbSystemResponse response) {
                return targetStatesSet.contains((Object)response.getExternalDbSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalDbSystem.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse> forExternalDbSystemConnector(GetExternalDbSystemConnectorRequest request, ExternalDbSystemConnector.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystemConnector(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse> forExternalDbSystemConnector(GetExternalDbSystemConnectorRequest request, ExternalDbSystemConnector.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalDbSystemConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse> forExternalDbSystemConnector(GetExternalDbSystemConnectorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalDbSystemConnector.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystemConnector(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse> forExternalDbSystemConnector(BmcGenericWaiter waiter, GetExternalDbSystemConnectorRequest request, ExternalDbSystemConnector.LifecycleState ... targetStates) {
        final HashSet<ExternalDbSystemConnector.LifecycleState> targetStatesSet = new HashSet<ExternalDbSystemConnector.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalDbSystemConnectorRequest, GetExternalDbSystemConnectorResponse>(){

            @Override
            public GetExternalDbSystemConnectorResponse apply(GetExternalDbSystemConnectorRequest request) {
                return DbManagementWaiters.this.client.getExternalDbSystemConnector(request);
            }
        }, (Predicate)new Predicate<GetExternalDbSystemConnectorResponse>(){

            @Override
            public boolean test(GetExternalDbSystemConnectorResponse response) {
                return targetStatesSet.contains((Object)response.getExternalDbSystemConnector().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalDbSystemConnector.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse> forExternalDbSystemDiscovery(GetExternalDbSystemDiscoveryRequest request, ExternalDbSystemDiscovery.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystemDiscovery(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse> forExternalDbSystemDiscovery(GetExternalDbSystemDiscoveryRequest request, ExternalDbSystemDiscovery.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalDbSystemDiscovery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse> forExternalDbSystemDiscovery(GetExternalDbSystemDiscoveryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalDbSystemDiscovery.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalDbSystemDiscovery(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse> forExternalDbSystemDiscovery(BmcGenericWaiter waiter, GetExternalDbSystemDiscoveryRequest request, ExternalDbSystemDiscovery.LifecycleState ... targetStates) {
        final HashSet<ExternalDbSystemDiscovery.LifecycleState> targetStatesSet = new HashSet<ExternalDbSystemDiscovery.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalDbSystemDiscoveryRequest, GetExternalDbSystemDiscoveryResponse>(){

            @Override
            public GetExternalDbSystemDiscoveryResponse apply(GetExternalDbSystemDiscoveryRequest request) {
                return DbManagementWaiters.this.client.getExternalDbSystemDiscovery(request);
            }
        }, (Predicate)new Predicate<GetExternalDbSystemDiscoveryResponse>(){

            @Override
            public boolean test(GetExternalDbSystemDiscoveryResponse response) {
                return targetStatesSet.contains((Object)response.getExternalDbSystemDiscovery().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalDbSystemDiscovery.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetExternalListenerRequest, GetExternalListenerResponse> forExternalListener(GetExternalListenerRequest request, ExternalListener.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExternalListener(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExternalListenerRequest, GetExternalListenerResponse> forExternalListener(GetExternalListenerRequest request, ExternalListener.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExternalListener(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetExternalListenerRequest, GetExternalListenerResponse> forExternalListener(GetExternalListenerRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExternalListener.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExternalListener(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetExternalListenerRequest, GetExternalListenerResponse> forExternalListener(BmcGenericWaiter waiter, GetExternalListenerRequest request, ExternalListener.LifecycleState ... targetStates) {
        final HashSet<ExternalListener.LifecycleState> targetStatesSet = new HashSet<ExternalListener.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetExternalListenerRequest, GetExternalListenerResponse>(){

            @Override
            public GetExternalListenerResponse apply(GetExternalListenerRequest request) {
                return DbManagementWaiters.this.client.getExternalListener(request);
            }
        }, (Predicate)new Predicate<GetExternalListenerResponse>(){

            @Override
            public boolean test(GetExternalListenerResponse response) {
                return targetStatesSet.contains((Object)response.getExternalListener().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExternalListener.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, Job.LifecycleState ... targetStates) {
        final HashSet<Job.LifecycleState> targetStatesSet = new HashSet<Job.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJobRequest, GetJobResponse>(){

            @Override
            public GetJobResponse apply(GetJobRequest request) {
                return DbManagementWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            @Override
            public boolean test(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(BmcGenericWaiter waiter, GetManagedDatabaseGroupRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse>(){

            @Override
            public GetManagedDatabaseGroupResponse apply(GetManagedDatabaseGroupRequest request) {
                return DbManagementWaiters.this.client.getManagedDatabaseGroup(request);
            }
        }, (Predicate)new Predicate<GetManagedDatabaseGroupResponse>(){

            @Override
            public boolean test(GetManagedDatabaseGroupResponse response) {
                return targetStatesSet.contains((Object)response.getManagedDatabaseGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetNamedCredentialRequest, GetNamedCredentialResponse> forNamedCredential(GetNamedCredentialRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNamedCredential(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNamedCredentialRequest, GetNamedCredentialResponse> forNamedCredential(GetNamedCredentialRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNamedCredential(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNamedCredentialRequest, GetNamedCredentialResponse> forNamedCredential(GetNamedCredentialRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNamedCredential(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNamedCredentialRequest, GetNamedCredentialResponse> forNamedCredential(BmcGenericWaiter waiter, GetNamedCredentialRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNamedCredentialRequest, GetNamedCredentialResponse>(){

            @Override
            public GetNamedCredentialResponse apply(GetNamedCredentialRequest request) {
                return DbManagementWaiters.this.client.getNamedCredential(request);
            }
        }, (Predicate)new Predicate<GetNamedCredentialResponse>(){

            @Override
            public boolean test(GetNamedCredentialResponse response) {
                return targetStatesSet.contains((Object)response.getNamedCredential().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DbManagementWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

