/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutomaticCaptureFilterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final Name name;
    @JsonProperty(value="valuesToInclude")
    private final List<String> valuesToInclude;
    @JsonProperty(value="valuesToExclude")
    private final List<String> valuesToExclude;

    @Deprecated
    @ConstructorProperties(value={"name", "valuesToInclude", "valuesToExclude"})
    public AutomaticCaptureFilterDetails(Name name, List<String> valuesToInclude, List<String> valuesToExclude) {
        this.name = name;
        this.valuesToInclude = valuesToInclude;
        this.valuesToExclude = valuesToExclude;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Name getName() {
        return this.name;
    }

    public List<String> getValuesToInclude() {
        return this.valuesToInclude;
    }

    public List<String> getValuesToExclude() {
        return this.valuesToExclude;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutomaticCaptureFilterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf((Object)this.name));
        sb.append(", valuesToInclude=").append(String.valueOf(this.valuesToInclude));
        sb.append(", valuesToExclude=").append(String.valueOf(this.valuesToExclude));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutomaticCaptureFilterDetails)) {
            return false;
        }
        AutomaticCaptureFilterDetails other = (AutomaticCaptureFilterDetails)((Object)o);
        return Objects.equals((Object)this.name, (Object)other.name) && Objects.equals(this.valuesToInclude, other.valuesToInclude) && Objects.equals(this.valuesToExclude, other.valuesToExclude) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.valuesToInclude == null ? 43 : this.valuesToInclude.hashCode());
        result = result * 59 + (this.valuesToExclude == null ? 43 : this.valuesToExclude.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Name implements BmcEnum
    {
        AutoCaptureSqlText("AUTO_CAPTURE_SQL_TEXT"),
        AutoCaptureParsingSchemaName("AUTO_CAPTURE_PARSING_SCHEMA_NAME"),
        AutoCaptureModule("AUTO_CAPTURE_MODULE"),
        AutoCaptureAction("AUTO_CAPTURE_ACTION");

        private final String value;
        private static Map<String, Name> map;

        private Name(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Name create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Name: " + key);
        }

        static {
            map = new HashMap<String, Name>();
            for (Name v : Name.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private Name name;
        @JsonProperty(value="valuesToInclude")
        private List<String> valuesToInclude;
        @JsonProperty(value="valuesToExclude")
        private List<String> valuesToExclude;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(Name name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder valuesToInclude(List<String> valuesToInclude) {
            this.valuesToInclude = valuesToInclude;
            this.__explicitlySet__.add("valuesToInclude");
            return this;
        }

        public Builder valuesToExclude(List<String> valuesToExclude) {
            this.valuesToExclude = valuesToExclude;
            this.__explicitlySet__.add("valuesToExclude");
            return this;
        }

        public AutomaticCaptureFilterDetails build() {
            AutomaticCaptureFilterDetails model = new AutomaticCaptureFilterDetails(this.name, this.valuesToInclude, this.valuesToExclude);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutomaticCaptureFilterDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("valuesToInclude")) {
                this.valuesToInclude(model.getValuesToInclude());
            }
            if (model.wasPropertyExplicitlySet("valuesToExclude")) {
                this.valuesToExclude(model.getValuesToExclude());
            }
            return this;
        }
    }
}

