/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.DatabaseConnectionStringDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType")
@JsonFilter(value="explicitlySetFilter")
public final class BasicDatabaseConnectionStringDetails
extends DatabaseConnectionStringDetails {
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="protocol")
    private final Protocol protocol;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BasicDatabaseConnectionStringDetails(String service, Integer port, Protocol protocol) {
        this.service = service;
        this.port = port;
        this.protocol = protocol;
    }

    public String getService() {
        return this.service;
    }

    public Integer getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicDatabaseConnectionStringDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", protocol=").append(String.valueOf((Object)this.protocol));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicDatabaseConnectionStringDetails)) {
            return false;
        }
        BasicDatabaseConnectionStringDetails other = (BasicDatabaseConnectionStringDetails)((Object)o);
        return Objects.equals(this.service, other.service) && Objects.equals(this.port, other.port) && Objects.equals((Object)this.protocol, (Object)other.protocol) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        return result;
    }

    public static enum Protocol implements BmcEnum
    {
        Tcp("TCP"),
        Tcps("TCPS");

        private final String value;
        private static Map<String, Protocol> map;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Protocol create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Protocol: " + key);
        }

        static {
            map = new HashMap<String, Protocol>();
            for (Protocol v : Protocol.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="protocol")
        private Protocol protocol;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public BasicDatabaseConnectionStringDetails build() {
            BasicDatabaseConnectionStringDetails model = new BasicDatabaseConnectionStringDetails(this.service, this.port, this.protocol);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BasicDatabaseConnectionStringDetails model) {
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            return this;
        }
    }
}

