/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDataPoint;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseTimeAggregateMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cpuCount")
    private final MetricDataPoint cpuCount;
    @JsonProperty(value="cpuTime")
    private final MetricDataPoint cpuTime;
    @JsonProperty(value="waitTime")
    private final MetricDataPoint waitTime;
    @JsonProperty(value="userIoTime")
    private final MetricDataPoint userIoTime;
    @JsonProperty(value="cluster")
    private final MetricDataPoint cluster;

    @Deprecated
    @ConstructorProperties(value={"cpuCount", "cpuTime", "waitTime", "userIoTime", "cluster"})
    public DatabaseTimeAggregateMetrics(MetricDataPoint cpuCount, MetricDataPoint cpuTime, MetricDataPoint waitTime, MetricDataPoint userIoTime, MetricDataPoint cluster) {
        this.cpuCount = cpuCount;
        this.cpuTime = cpuTime;
        this.waitTime = waitTime;
        this.userIoTime = userIoTime;
        this.cluster = cluster;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricDataPoint getCpuCount() {
        return this.cpuCount;
    }

    public MetricDataPoint getCpuTime() {
        return this.cpuTime;
    }

    public MetricDataPoint getWaitTime() {
        return this.waitTime;
    }

    public MetricDataPoint getUserIoTime() {
        return this.userIoTime;
    }

    public MetricDataPoint getCluster() {
        return this.cluster;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseTimeAggregateMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("cpuCount=").append(String.valueOf((Object)this.cpuCount));
        sb.append(", cpuTime=").append(String.valueOf((Object)this.cpuTime));
        sb.append(", waitTime=").append(String.valueOf((Object)this.waitTime));
        sb.append(", userIoTime=").append(String.valueOf((Object)this.userIoTime));
        sb.append(", cluster=").append(String.valueOf((Object)this.cluster));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseTimeAggregateMetrics)) {
            return false;
        }
        DatabaseTimeAggregateMetrics other = (DatabaseTimeAggregateMetrics)((Object)o);
        return Objects.equals((Object)this.cpuCount, (Object)other.cpuCount) && Objects.equals((Object)this.cpuTime, (Object)other.cpuTime) && Objects.equals((Object)this.waitTime, (Object)other.waitTime) && Objects.equals((Object)this.userIoTime, (Object)other.userIoTime) && Objects.equals((Object)this.cluster, (Object)other.cluster) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cpuCount == null ? 43 : this.cpuCount.hashCode());
        result = result * 59 + (this.cpuTime == null ? 43 : this.cpuTime.hashCode());
        result = result * 59 + (this.waitTime == null ? 43 : this.waitTime.hashCode());
        result = result * 59 + (this.userIoTime == null ? 43 : this.userIoTime.hashCode());
        result = result * 59 + (this.cluster == null ? 43 : this.cluster.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cpuCount")
        private MetricDataPoint cpuCount;
        @JsonProperty(value="cpuTime")
        private MetricDataPoint cpuTime;
        @JsonProperty(value="waitTime")
        private MetricDataPoint waitTime;
        @JsonProperty(value="userIoTime")
        private MetricDataPoint userIoTime;
        @JsonProperty(value="cluster")
        private MetricDataPoint cluster;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cpuCount(MetricDataPoint cpuCount) {
            this.cpuCount = cpuCount;
            this.__explicitlySet__.add("cpuCount");
            return this;
        }

        public Builder cpuTime(MetricDataPoint cpuTime) {
            this.cpuTime = cpuTime;
            this.__explicitlySet__.add("cpuTime");
            return this;
        }

        public Builder waitTime(MetricDataPoint waitTime) {
            this.waitTime = waitTime;
            this.__explicitlySet__.add("waitTime");
            return this;
        }

        public Builder userIoTime(MetricDataPoint userIoTime) {
            this.userIoTime = userIoTime;
            this.__explicitlySet__.add("userIoTime");
            return this;
        }

        public Builder cluster(MetricDataPoint cluster) {
            this.cluster = cluster;
            this.__explicitlySet__.add("cluster");
            return this;
        }

        public DatabaseTimeAggregateMetrics build() {
            DatabaseTimeAggregateMetrics model = new DatabaseTimeAggregateMetrics(this.cpuCount, this.cpuTime, this.waitTime, this.userIoTime, this.cluster);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseTimeAggregateMetrics model) {
            if (model.wasPropertyExplicitlySet("cpuCount")) {
                this.cpuCount(model.getCpuCount());
            }
            if (model.wasPropertyExplicitlySet("cpuTime")) {
                this.cpuTime(model.getCpuTime());
            }
            if (model.wasPropertyExplicitlySet("waitTime")) {
                this.waitTime(model.getWaitTime());
            }
            if (model.wasPropertyExplicitlySet("userIoTime")) {
                this.userIoTime(model.getUserIoTime());
            }
            if (model.wasPropertyExplicitlySet("cluster")) {
                this.cluster(model.getCluster());
            }
            return this;
        }
    }
}

