/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.AssociatedComponent;
import com.oracle.bmc.databasemanagement.model.DiscoveredExternalDbSystemComponent;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemDiscoveryConnector;
import com.oracle.bmc.databasemanagement.model.ExternalListenerEndpoint;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="componentType")
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveredExternalListener
extends DiscoveredExternalDbSystemComponent {
    @JsonProperty(value="dbNodeName")
    private final String dbNodeName;
    @JsonProperty(value="oracleHome")
    private final String oracleHome;
    @JsonProperty(value="listenerAlias")
    private final String listenerAlias;
    @JsonProperty(value="adrHomeDirectory")
    private final String adrHomeDirectory;
    @JsonProperty(value="logDirectory")
    private final String logDirectory;
    @JsonProperty(value="traceDirectory")
    private final String traceDirectory;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="listenerType")
    private final ListenerType listenerType;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="endpoints")
    private final List<ExternalListenerEndpoint> endpoints;
    @JsonProperty(value="connector")
    private final ExternalDbSystemDiscoveryConnector connector;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DiscoveredExternalListener(String componentId, String displayName, String componentName, String resourceId, Boolean isSelectedForMonitoring, DiscoveredExternalDbSystemComponent.Status status, List<AssociatedComponent> associatedComponents, String dbNodeName, String oracleHome, String listenerAlias, String adrHomeDirectory, String logDirectory, String traceDirectory, String version, ListenerType listenerType, String hostName, List<ExternalListenerEndpoint> endpoints, ExternalDbSystemDiscoveryConnector connector) {
        super(componentId, displayName, componentName, resourceId, isSelectedForMonitoring, status, associatedComponents);
        this.dbNodeName = dbNodeName;
        this.oracleHome = oracleHome;
        this.listenerAlias = listenerAlias;
        this.adrHomeDirectory = adrHomeDirectory;
        this.logDirectory = logDirectory;
        this.traceDirectory = traceDirectory;
        this.version = version;
        this.listenerType = listenerType;
        this.hostName = hostName;
        this.endpoints = endpoints;
        this.connector = connector;
    }

    public String getDbNodeName() {
        return this.dbNodeName;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getListenerAlias() {
        return this.listenerAlias;
    }

    public String getAdrHomeDirectory() {
        return this.adrHomeDirectory;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public ListenerType getListenerType() {
        return this.listenerType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public List<ExternalListenerEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public ExternalDbSystemDiscoveryConnector getConnector() {
        return this.connector;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveredExternalListener(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dbNodeName=").append(String.valueOf(this.dbNodeName));
        sb.append(", oracleHome=").append(String.valueOf(this.oracleHome));
        sb.append(", listenerAlias=").append(String.valueOf(this.listenerAlias));
        sb.append(", adrHomeDirectory=").append(String.valueOf(this.adrHomeDirectory));
        sb.append(", logDirectory=").append(String.valueOf(this.logDirectory));
        sb.append(", traceDirectory=").append(String.valueOf(this.traceDirectory));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", listenerType=").append(String.valueOf((Object)this.listenerType));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", endpoints=").append(String.valueOf(this.endpoints));
        sb.append(", connector=").append(String.valueOf((Object)this.connector));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveredExternalListener)) {
            return false;
        }
        DiscoveredExternalListener other = (DiscoveredExternalListener)((Object)o);
        return Objects.equals(this.dbNodeName, other.dbNodeName) && Objects.equals(this.oracleHome, other.oracleHome) && Objects.equals(this.listenerAlias, other.listenerAlias) && Objects.equals(this.adrHomeDirectory, other.adrHomeDirectory) && Objects.equals(this.logDirectory, other.logDirectory) && Objects.equals(this.traceDirectory, other.traceDirectory) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.listenerType, (Object)other.listenerType) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.endpoints, other.endpoints) && Objects.equals((Object)this.connector, (Object)other.connector) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbNodeName == null ? 43 : this.dbNodeName.hashCode());
        result = result * 59 + (this.oracleHome == null ? 43 : this.oracleHome.hashCode());
        result = result * 59 + (this.listenerAlias == null ? 43 : this.listenerAlias.hashCode());
        result = result * 59 + (this.adrHomeDirectory == null ? 43 : this.adrHomeDirectory.hashCode());
        result = result * 59 + (this.logDirectory == null ? 43 : this.logDirectory.hashCode());
        result = result * 59 + (this.traceDirectory == null ? 43 : this.traceDirectory.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.listenerType == null ? 43 : this.listenerType.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.endpoints == null ? 43 : this.endpoints.hashCode());
        result = result * 59 + (this.connector == null ? 43 : this.connector.hashCode());
        return result;
    }

    public static enum ListenerType implements BmcEnum
    {
        Asm("ASM"),
        Local("LOCAL"),
        Scan("SCAN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ListenerType> map;

        private ListenerType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ListenerType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ListenerType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ListenerType.class);
            map = new HashMap<String, ListenerType>();
            for (ListenerType v : ListenerType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="componentId")
        private String componentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="componentName")
        private String componentName;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="isSelectedForMonitoring")
        private Boolean isSelectedForMonitoring;
        @JsonProperty(value="status")
        private DiscoveredExternalDbSystemComponent.Status status;
        @JsonProperty(value="associatedComponents")
        private List<AssociatedComponent> associatedComponents;
        @JsonProperty(value="dbNodeName")
        private String dbNodeName;
        @JsonProperty(value="oracleHome")
        private String oracleHome;
        @JsonProperty(value="listenerAlias")
        private String listenerAlias;
        @JsonProperty(value="adrHomeDirectory")
        private String adrHomeDirectory;
        @JsonProperty(value="logDirectory")
        private String logDirectory;
        @JsonProperty(value="traceDirectory")
        private String traceDirectory;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="listenerType")
        private ListenerType listenerType;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="endpoints")
        private List<ExternalListenerEndpoint> endpoints;
        @JsonProperty(value="connector")
        private ExternalDbSystemDiscoveryConnector connector;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder componentId(String componentId) {
            this.componentId = componentId;
            this.__explicitlySet__.add("componentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.__explicitlySet__.add("componentName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder isSelectedForMonitoring(Boolean isSelectedForMonitoring) {
            this.isSelectedForMonitoring = isSelectedForMonitoring;
            this.__explicitlySet__.add("isSelectedForMonitoring");
            return this;
        }

        public Builder status(DiscoveredExternalDbSystemComponent.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder associatedComponents(List<AssociatedComponent> associatedComponents) {
            this.associatedComponents = associatedComponents;
            this.__explicitlySet__.add("associatedComponents");
            return this;
        }

        public Builder dbNodeName(String dbNodeName) {
            this.dbNodeName = dbNodeName;
            this.__explicitlySet__.add("dbNodeName");
            return this;
        }

        public Builder oracleHome(String oracleHome) {
            this.oracleHome = oracleHome;
            this.__explicitlySet__.add("oracleHome");
            return this;
        }

        public Builder listenerAlias(String listenerAlias) {
            this.listenerAlias = listenerAlias;
            this.__explicitlySet__.add("listenerAlias");
            return this;
        }

        public Builder adrHomeDirectory(String adrHomeDirectory) {
            this.adrHomeDirectory = adrHomeDirectory;
            this.__explicitlySet__.add("adrHomeDirectory");
            return this;
        }

        public Builder logDirectory(String logDirectory) {
            this.logDirectory = logDirectory;
            this.__explicitlySet__.add("logDirectory");
            return this;
        }

        public Builder traceDirectory(String traceDirectory) {
            this.traceDirectory = traceDirectory;
            this.__explicitlySet__.add("traceDirectory");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder listenerType(ListenerType listenerType) {
            this.listenerType = listenerType;
            this.__explicitlySet__.add("listenerType");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder endpoints(List<ExternalListenerEndpoint> endpoints) {
            this.endpoints = endpoints;
            this.__explicitlySet__.add("endpoints");
            return this;
        }

        public Builder connector(ExternalDbSystemDiscoveryConnector connector) {
            this.connector = connector;
            this.__explicitlySet__.add("connector");
            return this;
        }

        public DiscoveredExternalListener build() {
            DiscoveredExternalListener model = new DiscoveredExternalListener(this.componentId, this.displayName, this.componentName, this.resourceId, this.isSelectedForMonitoring, this.status, this.associatedComponents, this.dbNodeName, this.oracleHome, this.listenerAlias, this.adrHomeDirectory, this.logDirectory, this.traceDirectory, this.version, this.listenerType, this.hostName, this.endpoints, this.connector);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveredExternalListener model) {
            if (model.wasPropertyExplicitlySet("componentId")) {
                this.componentId(model.getComponentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("componentName")) {
                this.componentName(model.getComponentName());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("isSelectedForMonitoring")) {
                this.isSelectedForMonitoring(model.getIsSelectedForMonitoring());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("associatedComponents")) {
                this.associatedComponents(model.getAssociatedComponents());
            }
            if (model.wasPropertyExplicitlySet("dbNodeName")) {
                this.dbNodeName(model.getDbNodeName());
            }
            if (model.wasPropertyExplicitlySet("oracleHome")) {
                this.oracleHome(model.getOracleHome());
            }
            if (model.wasPropertyExplicitlySet("listenerAlias")) {
                this.listenerAlias(model.getListenerAlias());
            }
            if (model.wasPropertyExplicitlySet("adrHomeDirectory")) {
                this.adrHomeDirectory(model.getAdrHomeDirectory());
            }
            if (model.wasPropertyExplicitlySet("logDirectory")) {
                this.logDirectory(model.getLogDirectory());
            }
            if (model.wasPropertyExplicitlySet("traceDirectory")) {
                this.traceDirectory(model.getTraceDirectory());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("listenerType")) {
                this.listenerType(model.getListenerType());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("endpoints")) {
                this.endpoints(model.getEndpoints());
            }
            if (model.wasPropertyExplicitlySet("connector")) {
                this.connector(model.getConnector());
            }
            return this;
        }
    }
}

