/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalAsmInstanceParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="asmInstanceId")
    private final String asmInstanceId;
    @JsonProperty(value="asmInstanceDisplayName")
    private final String asmInstanceDisplayName;
    @JsonProperty(value="diskDiscoveryPath")
    private final String diskDiscoveryPath;
    @JsonProperty(value="autoMountDiskGroups")
    private final List<String> autoMountDiskGroups;
    @JsonProperty(value="rebalancePower")
    private final Integer rebalancePower;
    @JsonProperty(value="preferredReadFailureGroups")
    private final List<String> preferredReadFailureGroups;

    @Deprecated
    @ConstructorProperties(value={"asmInstanceId", "asmInstanceDisplayName", "diskDiscoveryPath", "autoMountDiskGroups", "rebalancePower", "preferredReadFailureGroups"})
    public ExternalAsmInstanceParameters(String asmInstanceId, String asmInstanceDisplayName, String diskDiscoveryPath, List<String> autoMountDiskGroups, Integer rebalancePower, List<String> preferredReadFailureGroups) {
        this.asmInstanceId = asmInstanceId;
        this.asmInstanceDisplayName = asmInstanceDisplayName;
        this.diskDiscoveryPath = diskDiscoveryPath;
        this.autoMountDiskGroups = autoMountDiskGroups;
        this.rebalancePower = rebalancePower;
        this.preferredReadFailureGroups = preferredReadFailureGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAsmInstanceId() {
        return this.asmInstanceId;
    }

    public String getAsmInstanceDisplayName() {
        return this.asmInstanceDisplayName;
    }

    public String getDiskDiscoveryPath() {
        return this.diskDiscoveryPath;
    }

    public List<String> getAutoMountDiskGroups() {
        return this.autoMountDiskGroups;
    }

    public Integer getRebalancePower() {
        return this.rebalancePower;
    }

    public List<String> getPreferredReadFailureGroups() {
        return this.preferredReadFailureGroups;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalAsmInstanceParameters(");
        sb.append("super=").append(super.toString());
        sb.append("asmInstanceId=").append(String.valueOf(this.asmInstanceId));
        sb.append(", asmInstanceDisplayName=").append(String.valueOf(this.asmInstanceDisplayName));
        sb.append(", diskDiscoveryPath=").append(String.valueOf(this.diskDiscoveryPath));
        sb.append(", autoMountDiskGroups=").append(String.valueOf(this.autoMountDiskGroups));
        sb.append(", rebalancePower=").append(String.valueOf(this.rebalancePower));
        sb.append(", preferredReadFailureGroups=").append(String.valueOf(this.preferredReadFailureGroups));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalAsmInstanceParameters)) {
            return false;
        }
        ExternalAsmInstanceParameters other = (ExternalAsmInstanceParameters)((Object)o);
        return Objects.equals(this.asmInstanceId, other.asmInstanceId) && Objects.equals(this.asmInstanceDisplayName, other.asmInstanceDisplayName) && Objects.equals(this.diskDiscoveryPath, other.diskDiscoveryPath) && Objects.equals(this.autoMountDiskGroups, other.autoMountDiskGroups) && Objects.equals(this.rebalancePower, other.rebalancePower) && Objects.equals(this.preferredReadFailureGroups, other.preferredReadFailureGroups) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.asmInstanceId == null ? 43 : this.asmInstanceId.hashCode());
        result = result * 59 + (this.asmInstanceDisplayName == null ? 43 : this.asmInstanceDisplayName.hashCode());
        result = result * 59 + (this.diskDiscoveryPath == null ? 43 : this.diskDiscoveryPath.hashCode());
        result = result * 59 + (this.autoMountDiskGroups == null ? 43 : this.autoMountDiskGroups.hashCode());
        result = result * 59 + (this.rebalancePower == null ? 43 : this.rebalancePower.hashCode());
        result = result * 59 + (this.preferredReadFailureGroups == null ? 43 : this.preferredReadFailureGroups.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="asmInstanceId")
        private String asmInstanceId;
        @JsonProperty(value="asmInstanceDisplayName")
        private String asmInstanceDisplayName;
        @JsonProperty(value="diskDiscoveryPath")
        private String diskDiscoveryPath;
        @JsonProperty(value="autoMountDiskGroups")
        private List<String> autoMountDiskGroups;
        @JsonProperty(value="rebalancePower")
        private Integer rebalancePower;
        @JsonProperty(value="preferredReadFailureGroups")
        private List<String> preferredReadFailureGroups;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder asmInstanceId(String asmInstanceId) {
            this.asmInstanceId = asmInstanceId;
            this.__explicitlySet__.add("asmInstanceId");
            return this;
        }

        public Builder asmInstanceDisplayName(String asmInstanceDisplayName) {
            this.asmInstanceDisplayName = asmInstanceDisplayName;
            this.__explicitlySet__.add("asmInstanceDisplayName");
            return this;
        }

        public Builder diskDiscoveryPath(String diskDiscoveryPath) {
            this.diskDiscoveryPath = diskDiscoveryPath;
            this.__explicitlySet__.add("diskDiscoveryPath");
            return this;
        }

        public Builder autoMountDiskGroups(List<String> autoMountDiskGroups) {
            this.autoMountDiskGroups = autoMountDiskGroups;
            this.__explicitlySet__.add("autoMountDiskGroups");
            return this;
        }

        public Builder rebalancePower(Integer rebalancePower) {
            this.rebalancePower = rebalancePower;
            this.__explicitlySet__.add("rebalancePower");
            return this;
        }

        public Builder preferredReadFailureGroups(List<String> preferredReadFailureGroups) {
            this.preferredReadFailureGroups = preferredReadFailureGroups;
            this.__explicitlySet__.add("preferredReadFailureGroups");
            return this;
        }

        public ExternalAsmInstanceParameters build() {
            ExternalAsmInstanceParameters model = new ExternalAsmInstanceParameters(this.asmInstanceId, this.asmInstanceDisplayName, this.diskDiscoveryPath, this.autoMountDiskGroups, this.rebalancePower, this.preferredReadFailureGroups);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalAsmInstanceParameters model) {
            if (model.wasPropertyExplicitlySet("asmInstanceId")) {
                this.asmInstanceId(model.getAsmInstanceId());
            }
            if (model.wasPropertyExplicitlySet("asmInstanceDisplayName")) {
                this.asmInstanceDisplayName(model.getAsmInstanceDisplayName());
            }
            if (model.wasPropertyExplicitlySet("diskDiscoveryPath")) {
                this.diskDiscoveryPath(model.getDiskDiscoveryPath());
            }
            if (model.wasPropertyExplicitlySet("autoMountDiskGroups")) {
                this.autoMountDiskGroups(model.getAutoMountDiskGroups());
            }
            if (model.wasPropertyExplicitlySet("rebalancePower")) {
                this.rebalancePower(model.getRebalancePower());
            }
            if (model.wasPropertyExplicitlySet("preferredReadFailureGroups")) {
                this.preferredReadFailureGroups(model.getPreferredReadFailureGroups());
            }
            return this;
        }
    }
}

