/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDimensionDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FleetMetricSummaryDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="baselineValue")
    private final Double baselineValue;
    @JsonProperty(value="targetValue")
    private final Double targetValue;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="percentageChange")
    private final Double percentageChange;
    @JsonProperty(value="dimensions")
    private final List<MetricDimensionDefinition> dimensions;

    @Deprecated
    @ConstructorProperties(value={"metricName", "baselineValue", "targetValue", "unit", "percentageChange", "dimensions"})
    public FleetMetricSummaryDefinition(String metricName, Double baselineValue, Double targetValue, String unit, Double percentageChange, List<MetricDimensionDefinition> dimensions) {
        this.metricName = metricName;
        this.baselineValue = baselineValue;
        this.targetValue = targetValue;
        this.unit = unit;
        this.percentageChange = percentageChange;
        this.dimensions = dimensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Double getBaselineValue() {
        return this.baselineValue;
    }

    public Double getTargetValue() {
        return this.targetValue;
    }

    public String getUnit() {
        return this.unit;
    }

    public Double getPercentageChange() {
        return this.percentageChange;
    }

    public List<MetricDimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FleetMetricSummaryDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("metricName=").append(String.valueOf(this.metricName));
        sb.append(", baselineValue=").append(String.valueOf(this.baselineValue));
        sb.append(", targetValue=").append(String.valueOf(this.targetValue));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", percentageChange=").append(String.valueOf(this.percentageChange));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FleetMetricSummaryDefinition)) {
            return false;
        }
        FleetMetricSummaryDefinition other = (FleetMetricSummaryDefinition)((Object)o);
        return Objects.equals(this.metricName, other.metricName) && Objects.equals(this.baselineValue, other.baselineValue) && Objects.equals(this.targetValue, other.targetValue) && Objects.equals(this.unit, other.unit) && Objects.equals(this.percentageChange, other.percentageChange) && Objects.equals(this.dimensions, other.dimensions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.baselineValue == null ? 43 : this.baselineValue.hashCode());
        result = result * 59 + (this.targetValue == null ? 43 : this.targetValue.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.percentageChange == null ? 43 : this.percentageChange.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="baselineValue")
        private Double baselineValue;
        @JsonProperty(value="targetValue")
        private Double targetValue;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="percentageChange")
        private Double percentageChange;
        @JsonProperty(value="dimensions")
        private List<MetricDimensionDefinition> dimensions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder baselineValue(Double baselineValue) {
            this.baselineValue = baselineValue;
            this.__explicitlySet__.add("baselineValue");
            return this;
        }

        public Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            this.__explicitlySet__.add("targetValue");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder percentageChange(Double percentageChange) {
            this.percentageChange = percentageChange;
            this.__explicitlySet__.add("percentageChange");
            return this;
        }

        public Builder dimensions(List<MetricDimensionDefinition> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public FleetMetricSummaryDefinition build() {
            FleetMetricSummaryDefinition model = new FleetMetricSummaryDefinition(this.metricName, this.baselineValue, this.targetValue, this.unit, this.percentageChange, this.dimensions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FleetMetricSummaryDefinition model) {
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("baselineValue")) {
                this.baselineValue(model.getBaselineValue());
            }
            if (model.wasPropertyExplicitlySet("targetValue")) {
                this.targetValue(model.getTargetValue());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("percentageChange")) {
                this.percentageChange(model.getPercentageChange());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            return this;
        }
    }
}

