/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.HeatWaveClusterUsageMetrics;
import com.oracle.bmc.databasemanagement.model.HeatWaveFleetSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HeatWaveFleetMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="startTime")
    private final String startTime;
    @JsonProperty(value="endTime")
    private final String endTime;
    @JsonProperty(value="fleetClusters")
    private final List<HeatWaveClusterUsageMetrics> fleetClusters;
    @JsonProperty(value="fleetSummary")
    private final List<HeatWaveFleetSummary> fleetSummary;

    @Deprecated
    @ConstructorProperties(value={"startTime", "endTime", "fleetClusters", "fleetSummary"})
    public HeatWaveFleetMetrics(String startTime, String endTime, List<HeatWaveClusterUsageMetrics> fleetClusters, List<HeatWaveFleetSummary> fleetSummary) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.fleetClusters = fleetClusters;
        this.fleetSummary = fleetSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public List<HeatWaveClusterUsageMetrics> getFleetClusters() {
        return this.fleetClusters;
    }

    public List<HeatWaveFleetSummary> getFleetSummary() {
        return this.fleetSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HeatWaveFleetMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("startTime=").append(String.valueOf(this.startTime));
        sb.append(", endTime=").append(String.valueOf(this.endTime));
        sb.append(", fleetClusters=").append(String.valueOf(this.fleetClusters));
        sb.append(", fleetSummary=").append(String.valueOf(this.fleetSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeatWaveFleetMetrics)) {
            return false;
        }
        HeatWaveFleetMetrics other = (HeatWaveFleetMetrics)((Object)o);
        return Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.fleetClusters, other.fleetClusters) && Objects.equals(this.fleetSummary, other.fleetSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.fleetClusters == null ? 43 : this.fleetClusters.hashCode());
        result = result * 59 + (this.fleetSummary == null ? 43 : this.fleetSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="endTime")
        private String endTime;
        @JsonProperty(value="fleetClusters")
        private List<HeatWaveClusterUsageMetrics> fleetClusters;
        @JsonProperty(value="fleetSummary")
        private List<HeatWaveFleetSummary> fleetSummary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            this.__explicitlySet__.add("endTime");
            return this;
        }

        public Builder fleetClusters(List<HeatWaveClusterUsageMetrics> fleetClusters) {
            this.fleetClusters = fleetClusters;
            this.__explicitlySet__.add("fleetClusters");
            return this;
        }

        public Builder fleetSummary(List<HeatWaveFleetSummary> fleetSummary) {
            this.fleetSummary = fleetSummary;
            this.__explicitlySet__.add("fleetSummary");
            return this;
        }

        public HeatWaveFleetMetrics build() {
            HeatWaveFleetMetrics model = new HeatWaveFleetMetrics(this.startTime, this.endTime, this.fleetClusters, this.fleetSummary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HeatWaveFleetMetrics model) {
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("endTime")) {
                this.endTime(model.getEndTime());
            }
            if (model.wasPropertyExplicitlySet("fleetClusters")) {
                this.fleetClusters(model.getFleetClusters());
            }
            if (model.wasPropertyExplicitlySet("fleetSummary")) {
                this.fleetSummary(model.getFleetSummary());
            }
            return this;
        }
    }
}

