/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MetricDimensionDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MySqlFleetMetricSummaryDefinition
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricValue")
    private final BigDecimal metricValue;
    @JsonProperty(value="dimensions")
    private final List<MetricDimensionDefinition> dimensions;
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="unit")
    private final String unit;

    @Deprecated
    @ConstructorProperties(value={"metricValue", "dimensions", "metricName", "unit"})
    public MySqlFleetMetricSummaryDefinition(BigDecimal metricValue, List<MetricDimensionDefinition> dimensions, String metricName, String unit) {
        this.metricValue = metricValue;
        this.dimensions = dimensions;
        this.metricName = metricName;
        this.unit = unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BigDecimal getMetricValue() {
        return this.metricValue;
    }

    public List<MetricDimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MySqlFleetMetricSummaryDefinition(");
        sb.append("super=").append(super.toString());
        sb.append("metricValue=").append(String.valueOf(this.metricValue));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", metricName=").append(String.valueOf(this.metricName));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlFleetMetricSummaryDefinition)) {
            return false;
        }
        MySqlFleetMetricSummaryDefinition other = (MySqlFleetMetricSummaryDefinition)((Object)o);
        return Objects.equals(this.metricValue, other.metricValue) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.metricName, other.metricName) && Objects.equals(this.unit, other.unit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricValue == null ? 43 : this.metricValue.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricValue")
        private BigDecimal metricValue;
        @JsonProperty(value="dimensions")
        private List<MetricDimensionDefinition> dimensions;
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="unit")
        private String unit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricValue(BigDecimal metricValue) {
            this.metricValue = metricValue;
            this.__explicitlySet__.add("metricValue");
            return this;
        }

        public Builder dimensions(List<MetricDimensionDefinition> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public MySqlFleetMetricSummaryDefinition build() {
            MySqlFleetMetricSummaryDefinition model = new MySqlFleetMetricSummaryDefinition(this.metricValue, this.dimensions, this.metricName, this.unit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MySqlFleetMetricSummaryDefinition model) {
            if (model.wasPropertyExplicitlySet("metricValue")) {
                this.metricValue(model.getMetricValue());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            return this;
        }
    }
}

