/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.MySqlDatabaseUsageMetrics;
import com.oracle.bmc.databasemanagement.model.MySqlFleetSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MySqlFleetMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="startTime")
    private final String startTime;
    @JsonProperty(value="endTime")
    private final String endTime;
    @JsonProperty(value="fleetDatabases")
    private final List<MySqlDatabaseUsageMetrics> fleetDatabases;
    @JsonProperty(value="fleetSummary")
    private final List<MySqlFleetSummary> fleetSummary;

    @Deprecated
    @ConstructorProperties(value={"startTime", "endTime", "fleetDatabases", "fleetSummary"})
    public MySqlFleetMetrics(String startTime, String endTime, List<MySqlDatabaseUsageMetrics> fleetDatabases, List<MySqlFleetSummary> fleetSummary) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.fleetDatabases = fleetDatabases;
        this.fleetSummary = fleetSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public List<MySqlDatabaseUsageMetrics> getFleetDatabases() {
        return this.fleetDatabases;
    }

    public List<MySqlFleetSummary> getFleetSummary() {
        return this.fleetSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MySqlFleetMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("startTime=").append(String.valueOf(this.startTime));
        sb.append(", endTime=").append(String.valueOf(this.endTime));
        sb.append(", fleetDatabases=").append(String.valueOf(this.fleetDatabases));
        sb.append(", fleetSummary=").append(String.valueOf(this.fleetSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlFleetMetrics)) {
            return false;
        }
        MySqlFleetMetrics other = (MySqlFleetMetrics)((Object)o);
        return Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.fleetDatabases, other.fleetDatabases) && Objects.equals(this.fleetSummary, other.fleetSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.fleetDatabases == null ? 43 : this.fleetDatabases.hashCode());
        result = result * 59 + (this.fleetSummary == null ? 43 : this.fleetSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="startTime")
        private String startTime;
        @JsonProperty(value="endTime")
        private String endTime;
        @JsonProperty(value="fleetDatabases")
        private List<MySqlDatabaseUsageMetrics> fleetDatabases;
        @JsonProperty(value="fleetSummary")
        private List<MySqlFleetSummary> fleetSummary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            this.__explicitlySet__.add("endTime");
            return this;
        }

        public Builder fleetDatabases(List<MySqlDatabaseUsageMetrics> fleetDatabases) {
            this.fleetDatabases = fleetDatabases;
            this.__explicitlySet__.add("fleetDatabases");
            return this;
        }

        public Builder fleetSummary(List<MySqlFleetSummary> fleetSummary) {
            this.fleetSummary = fleetSummary;
            this.__explicitlySet__.add("fleetSummary");
            return this;
        }

        public MySqlFleetMetrics build() {
            MySqlFleetMetrics model = new MySqlFleetMetrics(this.startTime, this.endTime, this.fleetDatabases, this.fleetSummary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MySqlFleetMetrics model) {
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("endTime")) {
                this.endTime(model.getEndTime());
            }
            if (model.wasPropertyExplicitlySet("fleetDatabases")) {
                this.fleetDatabases(model.getFleetDatabases());
            }
            if (model.wasPropertyExplicitlySet("fleetSummary")) {
                this.fleetSummary(model.getFleetSummary());
            }
            return this;
        }
    }
}

