/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasemanagement.model.ExternalDbSystemConnectionInfo;
import com.oracle.bmc.databasemanagement.model.UpdateExternalDbSystemConnectorDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectorType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateExternalDbSystemMacsConnectorDetails
extends UpdateExternalDbSystemConnectorDetails {
    @JsonProperty(value="connectionInfo")
    private final ExternalDbSystemConnectionInfo connectionInfo;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateExternalDbSystemMacsConnectorDetails(ExternalDbSystemConnectionInfo connectionInfo, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.connectionInfo = connectionInfo;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public ExternalDbSystemConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateExternalDbSystemMacsConnectorDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", connectionInfo=").append(String.valueOf((Object)this.connectionInfo));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateExternalDbSystemMacsConnectorDetails)) {
            return false;
        }
        UpdateExternalDbSystemMacsConnectorDetails other = (UpdateExternalDbSystemMacsConnectorDetails)((Object)o);
        return Objects.equals((Object)this.connectionInfo, (Object)other.connectionInfo) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionInfo == null ? 43 : this.connectionInfo.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionInfo")
        private ExternalDbSystemConnectionInfo connectionInfo;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionInfo(ExternalDbSystemConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            this.__explicitlySet__.add("connectionInfo");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateExternalDbSystemMacsConnectorDetails build() {
            UpdateExternalDbSystemMacsConnectorDetails model = new UpdateExternalDbSystemMacsConnectorDetails(this.connectionInfo, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateExternalDbSystemMacsConnectorDetails model) {
            if (model.wasPropertyExplicitlySet("connectionInfo")) {
                this.connectionInfo(model.getConnectionInfo());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

