/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.ChangePlanRetentionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangePlanRetentionRequest
extends BmcRequest<ChangePlanRetentionDetails> {
    private String managedDatabaseId;
    private ChangePlanRetentionDetails changePlanRetentionDetails;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public ChangePlanRetentionDetails getChangePlanRetentionDetails() {
        return this.changePlanRetentionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangePlanRetentionDetails getBody$() {
        return this.changePlanRetentionDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).changePlanRetentionDetails(this.changePlanRetentionDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",changePlanRetentionDetails=").append(String.valueOf((Object)this.changePlanRetentionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangePlanRetentionRequest)) {
            return false;
        }
        ChangePlanRetentionRequest other = (ChangePlanRetentionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.changePlanRetentionDetails, (Object)other.changePlanRetentionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.changePlanRetentionDetails == null ? 43 : this.changePlanRetentionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangePlanRetentionRequest, ChangePlanRetentionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private ChangePlanRetentionDetails changePlanRetentionDetails = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder changePlanRetentionDetails(ChangePlanRetentionDetails changePlanRetentionDetails) {
            this.changePlanRetentionDetails = changePlanRetentionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangePlanRetentionRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.changePlanRetentionDetails(o.getChangePlanRetentionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangePlanRetentionRequest build() {
            ChangePlanRetentionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangePlanRetentionDetails body) {
            this.changePlanRetentionDetails(body);
            return this;
        }

        public ChangePlanRetentionRequest buildWithoutInvocationCallback() {
            ChangePlanRetentionRequest request = new ChangePlanRetentionRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.changePlanRetentionDetails = this.changePlanRetentionDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

