/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.ChangeSpaceBudgetDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeSpaceBudgetRequest
extends BmcRequest<ChangeSpaceBudgetDetails> {
    private String managedDatabaseId;
    private ChangeSpaceBudgetDetails changeSpaceBudgetDetails;
    private String opcRequestId;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public ChangeSpaceBudgetDetails getChangeSpaceBudgetDetails() {
        return this.changeSpaceBudgetDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeSpaceBudgetDetails getBody$() {
        return this.changeSpaceBudgetDetails;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).changeSpaceBudgetDetails(this.changeSpaceBudgetDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",changeSpaceBudgetDetails=").append(String.valueOf((Object)this.changeSpaceBudgetDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeSpaceBudgetRequest)) {
            return false;
        }
        ChangeSpaceBudgetRequest other = (ChangeSpaceBudgetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals((Object)this.changeSpaceBudgetDetails, (Object)other.changeSpaceBudgetDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.changeSpaceBudgetDetails == null ? 43 : this.changeSpaceBudgetDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeSpaceBudgetRequest, ChangeSpaceBudgetDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private ChangeSpaceBudgetDetails changeSpaceBudgetDetails = null;
        private String opcRequestId = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder changeSpaceBudgetDetails(ChangeSpaceBudgetDetails changeSpaceBudgetDetails) {
            this.changeSpaceBudgetDetails = changeSpaceBudgetDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSpaceBudgetRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.changeSpaceBudgetDetails(o.getChangeSpaceBudgetDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSpaceBudgetRequest build() {
            ChangeSpaceBudgetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeSpaceBudgetDetails body) {
            this.changeSpaceBudgetDetails(body);
            return this;
        }

        public ChangeSpaceBudgetRequest buildWithoutInvocationCallback() {
            ChangeSpaceBudgetRequest request = new ChangeSpaceBudgetRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.changeSpaceBudgetDetails = this.changeSpaceBudgetDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

