/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.databasemanagement.model.EnableDatabaseManagementFeatureDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class EnableDatabaseManagementFeatureRequest
extends BmcRequest<EnableDatabaseManagementFeatureDetails> {
    private String databaseId;
    private EnableDatabaseManagementFeatureDetails enableDatabaseManagementFeatureDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public EnableDatabaseManagementFeatureDetails getEnableDatabaseManagementFeatureDetails() {
        return this.enableDatabaseManagementFeatureDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public EnableDatabaseManagementFeatureDetails getBody$() {
        return this.enableDatabaseManagementFeatureDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).enableDatabaseManagementFeatureDetails(this.enableDatabaseManagementFeatureDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",enableDatabaseManagementFeatureDetails=").append(String.valueOf((Object)this.enableDatabaseManagementFeatureDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnableDatabaseManagementFeatureRequest)) {
            return false;
        }
        EnableDatabaseManagementFeatureRequest other = (EnableDatabaseManagementFeatureRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.enableDatabaseManagementFeatureDetails, (Object)other.enableDatabaseManagementFeatureDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.enableDatabaseManagementFeatureDetails == null ? 43 : this.enableDatabaseManagementFeatureDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<EnableDatabaseManagementFeatureRequest, EnableDatabaseManagementFeatureDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private EnableDatabaseManagementFeatureDetails enableDatabaseManagementFeatureDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder enableDatabaseManagementFeatureDetails(EnableDatabaseManagementFeatureDetails enableDatabaseManagementFeatureDetails) {
            this.enableDatabaseManagementFeatureDetails = enableDatabaseManagementFeatureDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EnableDatabaseManagementFeatureRequest o) {
            this.databaseId(o.getDatabaseId());
            this.enableDatabaseManagementFeatureDetails(o.getEnableDatabaseManagementFeatureDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EnableDatabaseManagementFeatureRequest build() {
            EnableDatabaseManagementFeatureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EnableDatabaseManagementFeatureDetails body) {
            this.enableDatabaseManagementFeatureDetails(body);
            return this;
        }

        public EnableDatabaseManagementFeatureRequest buildWithoutInvocationCallback() {
            EnableDatabaseManagementFeatureRequest request = new EnableDatabaseManagementFeatureRequest();
            request.databaseId = this.databaseId;
            request.enableDatabaseManagementFeatureDetails = this.enableDatabaseManagementFeatureDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

