/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataguardPerformanceMetricsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String startTime;
    private String endTime;
    private String opcRequestId;
    private String peerDatabaseCompartmentId;
    private String filterByMetricNames;

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPeerDatabaseCompartmentId() {
        return this.peerDatabaseCompartmentId;
    }

    public String getFilterByMetricNames() {
        return this.filterByMetricNames;
    }

    public Builder toBuilder() {
        return new Builder().managedDatabaseId(this.managedDatabaseId).startTime(this.startTime).endTime(this.endTime).opcRequestId(this.opcRequestId).peerDatabaseCompartmentId(this.peerDatabaseCompartmentId).filterByMetricNames(this.filterByMetricNames);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedDatabaseId=").append(String.valueOf(this.managedDatabaseId));
        sb.append(",startTime=").append(String.valueOf(this.startTime));
        sb.append(",endTime=").append(String.valueOf(this.endTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",peerDatabaseCompartmentId=").append(String.valueOf(this.peerDatabaseCompartmentId));
        sb.append(",filterByMetricNames=").append(String.valueOf(this.filterByMetricNames));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataguardPerformanceMetricsRequest)) {
            return false;
        }
        GetDataguardPerformanceMetricsRequest other = (GetDataguardPerformanceMetricsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedDatabaseId, other.managedDatabaseId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.peerDatabaseCompartmentId, other.peerDatabaseCompartmentId) && Objects.equals(this.filterByMetricNames, other.filterByMetricNames);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedDatabaseId == null ? 43 : this.managedDatabaseId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.peerDatabaseCompartmentId == null ? 43 : this.peerDatabaseCompartmentId.hashCode());
        result = result * 59 + (this.filterByMetricNames == null ? 43 : this.filterByMetricNames.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataguardPerformanceMetricsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedDatabaseId = null;
        private String startTime = null;
        private String endTime = null;
        private String opcRequestId = null;
        private String peerDatabaseCompartmentId = null;
        private String filterByMetricNames = null;

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder peerDatabaseCompartmentId(String peerDatabaseCompartmentId) {
            this.peerDatabaseCompartmentId = peerDatabaseCompartmentId;
            return this;
        }

        public Builder filterByMetricNames(String filterByMetricNames) {
            this.filterByMetricNames = filterByMetricNames;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataguardPerformanceMetricsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.opcRequestId(o.getOpcRequestId());
            this.peerDatabaseCompartmentId(o.getPeerDatabaseCompartmentId());
            this.filterByMetricNames(o.getFilterByMetricNames());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataguardPerformanceMetricsRequest build() {
            GetDataguardPerformanceMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataguardPerformanceMetricsRequest buildWithoutInvocationCallback() {
            GetDataguardPerformanceMetricsRequest request = new GetDataguardPerformanceMetricsRequest();
            request.managedDatabaseId = this.managedDatabaseId;
            request.startTime = this.startTime;
            request.endTime = this.endTime;
            request.opcRequestId = this.opcRequestId;
            request.peerDatabaseCompartmentId = this.peerDatabaseCompartmentId;
            request.filterByMetricNames = this.filterByMetricNames;
            return request;
        }
    }
}

