/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetManagedMySqlDatabaseRequest
extends BmcRequest<Void> {
    private String managedMySqlDatabaseId;
    private String opcRequestId;

    public String getManagedMySqlDatabaseId() {
        return this.managedMySqlDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().managedMySqlDatabaseId(this.managedMySqlDatabaseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",managedMySqlDatabaseId=").append(String.valueOf(this.managedMySqlDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetManagedMySqlDatabaseRequest)) {
            return false;
        }
        GetManagedMySqlDatabaseRequest other = (GetManagedMySqlDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.managedMySqlDatabaseId, other.managedMySqlDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.managedMySqlDatabaseId == null ? 43 : this.managedMySqlDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedMySqlDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String managedMySqlDatabaseId = null;
        private String opcRequestId = null;

        public Builder managedMySqlDatabaseId(String managedMySqlDatabaseId) {
            this.managedMySqlDatabaseId = managedMySqlDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedMySqlDatabaseRequest o) {
            this.managedMySqlDatabaseId(o.getManagedMySqlDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedMySqlDatabaseRequest build() {
            GetManagedMySqlDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetManagedMySqlDatabaseRequest buildWithoutInvocationCallback() {
            GetManagedMySqlDatabaseRequest request = new GetManagedMySqlDatabaseRequest();
            request.managedMySqlDatabaseId = this.managedMySqlDatabaseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

