/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.databasemanagement.model.DatabaseStatus;
import com.oracle.bmc.databasemanagement.model.MdsType;
import com.oracle.bmc.databasemanagement.model.MySqlDeploymentType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetMySqlFleetMetricRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String startTime;
    private String endTime;
    private String opcRequestId;
    private String filterByMetricNames;
    private MySqlDeploymentType filterByMySqlDeploymentTypeParam;
    private MdsType filterByMdsDeploymentType;
    private DatabaseStatus filterByMySqlStatus;
    private String filterByMySqlDatabaseVersion;
    private Boolean isHeatWaveEnabled;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getFilterByMetricNames() {
        return this.filterByMetricNames;
    }

    public MySqlDeploymentType getFilterByMySqlDeploymentTypeParam() {
        return this.filterByMySqlDeploymentTypeParam;
    }

    public MdsType getFilterByMdsDeploymentType() {
        return this.filterByMdsDeploymentType;
    }

    public DatabaseStatus getFilterByMySqlStatus() {
        return this.filterByMySqlStatus;
    }

    public String getFilterByMySqlDatabaseVersion() {
        return this.filterByMySqlDatabaseVersion;
    }

    public Boolean getIsHeatWaveEnabled() {
        return this.isHeatWaveEnabled;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).startTime(this.startTime).endTime(this.endTime).opcRequestId(this.opcRequestId).filterByMetricNames(this.filterByMetricNames).filterByMySqlDeploymentTypeParam(this.filterByMySqlDeploymentTypeParam).filterByMdsDeploymentType(this.filterByMdsDeploymentType).filterByMySqlStatus(this.filterByMySqlStatus).filterByMySqlDatabaseVersion(this.filterByMySqlDatabaseVersion).isHeatWaveEnabled(this.isHeatWaveEnabled);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",startTime=").append(String.valueOf(this.startTime));
        sb.append(",endTime=").append(String.valueOf(this.endTime));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",filterByMetricNames=").append(String.valueOf(this.filterByMetricNames));
        sb.append(",filterByMySqlDeploymentTypeParam=").append(String.valueOf((Object)this.filterByMySqlDeploymentTypeParam));
        sb.append(",filterByMdsDeploymentType=").append(String.valueOf((Object)this.filterByMdsDeploymentType));
        sb.append(",filterByMySqlStatus=").append(String.valueOf((Object)this.filterByMySqlStatus));
        sb.append(",filterByMySqlDatabaseVersion=").append(String.valueOf(this.filterByMySqlDatabaseVersion));
        sb.append(",isHeatWaveEnabled=").append(String.valueOf(this.isHeatWaveEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetMySqlFleetMetricRequest)) {
            return false;
        }
        GetMySqlFleetMetricRequest other = (GetMySqlFleetMetricRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.filterByMetricNames, other.filterByMetricNames) && Objects.equals((Object)this.filterByMySqlDeploymentTypeParam, (Object)other.filterByMySqlDeploymentTypeParam) && Objects.equals((Object)this.filterByMdsDeploymentType, (Object)other.filterByMdsDeploymentType) && Objects.equals((Object)this.filterByMySqlStatus, (Object)other.filterByMySqlStatus) && Objects.equals(this.filterByMySqlDatabaseVersion, other.filterByMySqlDatabaseVersion) && Objects.equals(this.isHeatWaveEnabled, other.isHeatWaveEnabled);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.filterByMetricNames == null ? 43 : this.filterByMetricNames.hashCode());
        result = result * 59 + (this.filterByMySqlDeploymentTypeParam == null ? 43 : this.filterByMySqlDeploymentTypeParam.hashCode());
        result = result * 59 + (this.filterByMdsDeploymentType == null ? 43 : this.filterByMdsDeploymentType.hashCode());
        result = result * 59 + (this.filterByMySqlStatus == null ? 43 : this.filterByMySqlStatus.hashCode());
        result = result * 59 + (this.filterByMySqlDatabaseVersion == null ? 43 : this.filterByMySqlDatabaseVersion.hashCode());
        result = result * 59 + (this.isHeatWaveEnabled == null ? 43 : this.isHeatWaveEnabled.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMySqlFleetMetricRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String startTime = null;
        private String endTime = null;
        private String opcRequestId = null;
        private String filterByMetricNames = null;
        private MySqlDeploymentType filterByMySqlDeploymentTypeParam = null;
        private MdsType filterByMdsDeploymentType = null;
        private DatabaseStatus filterByMySqlStatus = null;
        private String filterByMySqlDatabaseVersion = null;
        private Boolean isHeatWaveEnabled = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder filterByMetricNames(String filterByMetricNames) {
            this.filterByMetricNames = filterByMetricNames;
            return this;
        }

        public Builder filterByMySqlDeploymentTypeParam(MySqlDeploymentType filterByMySqlDeploymentTypeParam) {
            this.filterByMySqlDeploymentTypeParam = filterByMySqlDeploymentTypeParam;
            return this;
        }

        public Builder filterByMdsDeploymentType(MdsType filterByMdsDeploymentType) {
            this.filterByMdsDeploymentType = filterByMdsDeploymentType;
            return this;
        }

        public Builder filterByMySqlStatus(DatabaseStatus filterByMySqlStatus) {
            this.filterByMySqlStatus = filterByMySqlStatus;
            return this;
        }

        public Builder filterByMySqlDatabaseVersion(String filterByMySqlDatabaseVersion) {
            this.filterByMySqlDatabaseVersion = filterByMySqlDatabaseVersion;
            return this;
        }

        public Builder isHeatWaveEnabled(Boolean isHeatWaveEnabled) {
            this.isHeatWaveEnabled = isHeatWaveEnabled;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMySqlFleetMetricRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.opcRequestId(o.getOpcRequestId());
            this.filterByMetricNames(o.getFilterByMetricNames());
            this.filterByMySqlDeploymentTypeParam(o.getFilterByMySqlDeploymentTypeParam());
            this.filterByMdsDeploymentType(o.getFilterByMdsDeploymentType());
            this.filterByMySqlStatus(o.getFilterByMySqlStatus());
            this.filterByMySqlDatabaseVersion(o.getFilterByMySqlDatabaseVersion());
            this.isHeatWaveEnabled(o.getIsHeatWaveEnabled());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMySqlFleetMetricRequest build() {
            GetMySqlFleetMetricRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetMySqlFleetMetricRequest buildWithoutInvocationCallback() {
            GetMySqlFleetMetricRequest request = new GetMySqlFleetMetricRequest();
            request.compartmentId = this.compartmentId;
            request.startTime = this.startTime;
            request.endTime = this.endTime;
            request.opcRequestId = this.opcRequestId;
            request.filterByMetricNames = this.filterByMetricNames;
            request.filterByMySqlDeploymentTypeParam = this.filterByMySqlDeploymentTypeParam;
            request.filterByMdsDeploymentType = this.filterByMdsDeploymentType;
            request.filterByMySqlStatus = this.filterByMySqlStatus;
            request.filterByMySqlDatabaseVersion = this.filterByMySqlDatabaseVersion;
            request.isHeatWaveEnabled = this.isHeatWaveEnabled;
            return request;
        }
    }
}

